/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSElement;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSLine;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSScanner;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.refactoring.nls.ExternalizeWizard;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalizeStringsAction
extends SelectionDispatchAction {
    private CompilationUnitEditor fEditor;
    private NonNLSElement[] fElements;

    public ExternalizeStringsAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.ExternalizeStringsAction_label);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.externalize_strings_action");
    }

    public ExternalizeStringsAction(CompilationUnitEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(this.fEditor != null && SelectionConverter.canOperateOn(this.fEditor));
    }

    @Override
    public void selectionChanged(ITextSelection selection) {
    }

    @Override
    public void selectionChanged(IStructuredSelection selection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isExternalizeStringsAvailable(selection));
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.isExceptionToBeLogged(e)) {
                JavaPlugin.log(e);
            }
            this.setEnabled(false);
        }
    }

    @Override
    public void run(ITextSelection selection) {
        ITypeRoot element = SelectionConverter.getInput(this.fEditor);
        if (!(element instanceof ICompilationUnit)) {
            return;
        }
        this.run((ICompilationUnit)element);
    }

    @Override
    public void run(IStructuredSelection selection) {
        ICompilationUnit unit = ExternalizeStringsAction.getCompilationUnit(selection);
        if (unit != null) {
            this.run(unit);
        } else {
            try {
                PlatformUI.getWorkbench().getProgressService().run(true, true, this.createRunnable(selection));
            }
            catch (InvocationTargetException e) {
                ExceptionHandler.handle(e, this.getShell(), ActionMessages.ExternalizeStringsAction_dialog_title, ActionMessages.FindStringsToExternalizeAction_error_message);
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            this.showResults();
        }
    }

    public void run(ICompilationUnit unit) {
        if (!ActionUtil.isEditable(this.fEditor, this.getShell(), unit)) {
            return;
        }
        ExternalizeWizard.open(unit, this.getShell());
    }

    private static ICompilationUnit getCompilationUnit(IStructuredSelection selection) {
        if (selection.isEmpty() || selection.size() != 1) {
            return null;
        }
        Object first = selection.getFirstElement();
        if (first instanceof ICompilationUnit) {
            return (ICompilationUnit)first;
        }
        if (first instanceof IType) {
            return ((IType)first).getCompilationUnit();
        }
        return null;
    }

    private IRunnableWithProgress createRunnable(final IStructuredSelection selection) {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor pm) throws InvocationTargetException {
                try {
                    ExternalizeStringsAction.this.fElements = ExternalizeStringsAction.this.doRun(selection, pm);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
    }

    private NonNLSElement[] doRun(IStructuredSelection selection, IProgressMonitor pm) throws CoreException {
        List<?> elements = ExternalizeStringsAction.getSelectedElementList(selection);
        if (elements == null || elements.isEmpty()) {
            return new NonNLSElement[0];
        }
        pm.beginTask(ActionMessages.FindStringsToExternalizeAction_find_strings, elements.size());
        try {
            ArrayList<NonNLSElement> result = new ArrayList<NonNLSElement>();
            for (Object obj : elements) {
                result.addAll(this.analyze(obj, pm));
            }
            NonNLSElement[] nonNLSElementArray = result.toArray(new NonNLSElement[result.size()]);
            return nonNLSElementArray;
        }
        finally {
            pm.done();
        }
    }

    private List<NonNLSElement> analyze(Object obj, IProgressMonitor pm) throws CoreException, JavaModelException {
        if (obj instanceof IJavaElement) {
            IJavaElement element = (IJavaElement)obj;
            int elementType = element.getElementType();
            if (elementType == 4) {
                return this.analyze((IPackageFragment)element, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            }
            if (elementType == 3) {
                IPackageFragmentRoot root = (IPackageFragmentRoot)element;
                if (!root.isExternal() && !ReorgUtils.isClassFolder(root)) {
                    return this.analyze((IPackageFragmentRoot)element, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                }
                pm.worked(1);
            } else {
                if (elementType == 2) {
                    return this.analyze((IJavaProject)element, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                }
                if (elementType == 5) {
                    NonNLSElement nlsElement;
                    ICompilationUnit cu = (ICompilationUnit)element;
                    if (cu.exists() && (nlsElement = this.analyze(cu)) != null) {
                        pm.worked(1);
                        ArrayList<NonNLSElement> result = new ArrayList<NonNLSElement>();
                        result.add(nlsElement);
                        return result;
                    }
                    pm.worked(1);
                } else if (elementType == 7) {
                    NonNLSElement nlsElement;
                    IType type = (IType)element;
                    ICompilationUnit cu = type.getCompilationUnit();
                    if (cu != null && cu.exists() && (nlsElement = this.analyze(cu)) != null) {
                        pm.worked(1);
                        ArrayList<NonNLSElement> result = new ArrayList<NonNLSElement>();
                        result.add(nlsElement);
                        return result;
                    }
                    pm.worked(1);
                } else {
                    pm.worked(1);
                }
            }
        } else {
            if (obj instanceof IWorkingSet) {
                ArrayList<NonNLSElement> result = new ArrayList<NonNLSElement>();
                IWorkingSet workingSet = (IWorkingSet)obj;
                IAdaptable[] elements = workingSet.getElements();
                int i = 0;
                while (i < elements.length) {
                    result.addAll(this.analyze(elements[i], (IProgressMonitor)new NullProgressMonitor()));
                    ++i;
                }
                pm.worked(1);
                return result;
            }
            pm.worked(1);
        }
        return Collections.emptyList();
    }

    private void showResults() {
        if (this.noStrings()) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.ExternalizeStringsAction_dialog_title, (String)ActionMessages.FindStringsToExternalizeAction_noStrings);
        } else {
            new NonNLSListDialog(this.getShell(), this.fElements, this.countStrings()).open();
        }
    }

    private boolean noStrings() {
        if (this.fElements != null) {
            int i = 0;
            while (i < this.fElements.length) {
                if (this.fElements[i].count != 0) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private List<NonNLSElement> analyze(IPackageFragment pack, IProgressMonitor pm) throws CoreException {
        try {
            if (pack == null) {
                ArrayList<NonNLSElement> arrayList = new ArrayList<NonNLSElement>(0);
                return arrayList;
            }
            ICompilationUnit[] cus = pack.getCompilationUnits();
            pm.beginTask("", cus.length);
            pm.setTaskName(pack.getElementName());
            ArrayList<NonNLSElement> l = new ArrayList<NonNLSElement>(cus.length);
            int i = 0;
            while (i < cus.length) {
                pm.subTask(BasicElementLabels.getFileName(cus[i]));
                NonNLSElement element = this.analyze(cus[i]);
                if (element != null) {
                    l.add(element);
                }
                pm.worked(1);
                if (pm.isCanceled()) {
                    throw new OperationCanceledException();
                }
                ++i;
            }
            ArrayList<NonNLSElement> arrayList = l;
            return arrayList;
        }
        finally {
            pm.done();
        }
    }

    private List<NonNLSElement> analyze(IPackageFragmentRoot sourceFolder, IProgressMonitor pm) throws CoreException {
        try {
            IJavaElement[] children = sourceFolder.getChildren();
            pm.beginTask("", children.length);
            pm.setTaskName(JavaElementLabels.getElementLabel(sourceFolder, JavaElementLabels.ALL_DEFAULT));
            ArrayList<NonNLSElement> result = new ArrayList<NonNLSElement>();
            int i = 0;
            while (i < children.length) {
                IJavaElement iJavaElement = children[i];
                if (iJavaElement.getElementType() == 4) {
                    IPackageFragment pack = (IPackageFragment)iJavaElement;
                    if (!pack.isReadOnly()) {
                        result.addAll(this.analyze(pack, (IProgressMonitor)new SubProgressMonitor(pm, 1)));
                    } else {
                        pm.worked(1);
                    }
                } else {
                    pm.worked(1);
                }
                ++i;
            }
            ArrayList<NonNLSElement> arrayList = result;
            return arrayList;
        }
        finally {
            pm.done();
        }
    }

    private List<NonNLSElement> analyze(IJavaProject project, IProgressMonitor pm) throws CoreException {
        try {
            IPackageFragment[] packs = project.getPackageFragments();
            pm.beginTask("", packs.length);
            ArrayList<NonNLSElement> result = new ArrayList<NonNLSElement>();
            int i = 0;
            while (i < packs.length) {
                if (!packs[i].isReadOnly()) {
                    result.addAll(this.analyze(packs[i], (IProgressMonitor)new SubProgressMonitor(pm, 1)));
                } else {
                    pm.worked(1);
                }
                ++i;
            }
            ArrayList<NonNLSElement> arrayList = result;
            return arrayList;
        }
        finally {
            pm.done();
        }
    }

    private int countStrings() {
        int found = 0;
        if (this.fElements != null) {
            int i = 0;
            while (i < this.fElements.length) {
                found += this.fElements[i].count;
                ++i;
            }
        }
        return found;
    }

    private NonNLSElement analyze(ICompilationUnit cu) throws CoreException {
        int count = this.countNonExternalizedStrings(cu);
        if (count == 0) {
            return null;
        }
        return new NonNLSElement(cu, count);
    }

    private int countNonExternalizedStrings(ICompilationUnit cu) throws CoreException {
        try {
            NLSLine[] lines = NLSScanner.scan(cu);
            int result = 0;
            int i = 0;
            while (i < lines.length) {
                result += this.countNonExternalizedStrings(lines[i]);
                ++i;
            }
            return result;
        }
        catch (InvalidInputException e) {
            throw new CoreException(new Status(4, JavaPlugin.getPluginId(), 4, Messages.format(ActionMessages.FindStringsToExternalizeAction_error_cannotBeParsed, BasicElementLabels.getFileName(cu)), e));
        }
        catch (BadLocationException e) {
            throw new CoreException(new Status(4, JavaPlugin.getPluginId(), 4, Messages.format(ActionMessages.FindStringsToExternalizeAction_error_cannotBeParsed, BasicElementLabels.getFileName(cu)), e));
        }
    }

    private int countNonExternalizedStrings(NLSLine line) {
        int result = 0;
        NLSElement[] elements = line.getElements();
        int i = 0;
        while (i < elements.length) {
            if (!elements[i].hasTag()) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    private static List<?> getSelectedElementList(IStructuredSelection selection) {
        if (selection == null) {
            return null;
        }
        return selection.toList();
    }

    private static class NonNLSElement {
        ICompilationUnit cu;
        int count;

        NonNLSElement(ICompilationUnit cu, int count) {
            this.cu = cu;
            this.count = count;
        }
    }

    private static class NonNLSListDialog
    extends ListDialog {
        private static final int OPEN_BUTTON_ID = 1025;
        private Button fOpenButton;

        NonNLSListDialog(Shell parent, NonNLSElement[] input, int count) {
            super(parent);
            this.setAddCancelButton(false);
            this.setInput(Arrays.asList(input));
            this.setTitle(ActionMessages.ExternalizeStringsAction_dialog_title);
            String message = count == 1 ? ActionMessages.FindStringsToExternalizeAction_non_externalized_singular : Messages.format(ActionMessages.FindStringsToExternalizeAction_non_externalized_plural, new Object[]{new Integer(count)});
            this.setMessage(message);
            this.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
            this.setLabelProvider((ILabelProvider)NonNLSListDialog.createLabelProvider());
        }

        protected Point getInitialSize() {
            return this.getShell().computeSize(-1, -1, true);
        }

        protected Control createDialogArea(Composite parent) {
            Composite result = (Composite)super.createDialogArea(parent);
            this.getTableViewer().addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (NonNLSListDialog.this.fOpenButton != null) {
                        NonNLSListDialog.this.fOpenButton.setEnabled(!NonNLSListDialog.this.getTableViewer().getSelection().isEmpty());
                    }
                }
            });
            this.getTableViewer().getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    NonNLSElement element = (NonNLSElement)e.item.getData();
                    ExternalizeWizard.open(element.cu, NonNLSListDialog.this.getShell());
                }
            });
            this.getTableViewer().getTable().setFocus();
            NonNLSListDialog.applyDialogFont((Control)result);
            return result;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.fOpenButton = this.createButton(parent, 1025, ActionMessages.FindStringsToExternalizeAction_button_label, true);
            this.fOpenButton.setEnabled(false);
            this.createButton(parent, 1, IDialogConstants.CLOSE_LABEL, false);
        }

        protected void buttonPressed(int buttonId) {
            IStructuredSelection ss;
            if (buttonId != 1025) {
                super.buttonPressed(buttonId);
                return;
            }
            ISelection s = this.getTableViewer().getSelection();
            if (s instanceof IStructuredSelection && (ss = (IStructuredSelection)s).getFirstElement() instanceof NonNLSElement) {
                ExternalizeWizard.open(((NonNLSElement)ss.getFirstElement()).cu, this.getShell());
            }
        }

        private static LabelProvider createLabelProvider() {
            return new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT){

                public String getText(Object element) {
                    NonNLSElement nlsel = (NonNLSElement)element;
                    String elementName = BasicElementLabels.getPathLabel(nlsel.cu.getResource().getFullPath(), false);
                    return Messages.format(ActionMessages.FindStringsToExternalizeAction_foundStrings, new Object[]{new Integer(nlsel.count), elementName});
                }

                public Image getImage(Object element) {
                    return super.getImage(((NonNLSElement)element).cu);
                }
            };
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.jdt.ui.nonnls_dialog_context");
        }
    }
}

