/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.jdt.internal.ui.search.FindOccurrencesEngine;
import org.eclipse.jdt.internal.ui.search.MethodExitsFinder;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IEditorStatusLine;

public class FindMethodExitOccurrencesAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public FindMethodExitOccurrencesAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(FindMethodExitOccurrencesAction.getEditorInput(editor) != null);
    }

    public FindMethodExitOccurrencesAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.FindMethodExitOccurrencesAction_label);
        this.setToolTipText(ActionMessages.FindMethodExitOccurrencesAction_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.find_return_target_occurrences");
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(true);
    }

    public void selectionChanged(JavaTextSelection selection) {
        CompilationUnit astRoot = selection.resolvePartialAstAtOffset();
        this.setEnabled(astRoot != null && new MethodExitsFinder().initialize(astRoot, selection.getOffset(), selection.getLength()) == null);
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(false);
    }

    public final void run(ITextSelection ts) {
        ITypeRoot input = FindMethodExitOccurrencesAction.getEditorInput(this.fEditor);
        if (!ActionUtil.isProcessable(this.getShell(), input)) {
            return;
        }
        FindOccurrencesEngine engine = FindOccurrencesEngine.create(new MethodExitsFinder());
        try {
            String result = engine.run(input, ts.getOffset(), ts.getLength());
            if (result != null) {
                FindMethodExitOccurrencesAction.showMessage(this.getShell(), this.fEditor, result);
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
    }

    private static ITypeRoot getEditorInput(JavaEditor editor) {
        return JavaUI.getEditorInputTypeRoot(editor.getEditorInput());
    }

    private static void showMessage(Shell shell, JavaEditor editor, String msg) {
        IEditorStatusLine statusLine = (IEditorStatusLine)editor.getAdapter(IEditorStatusLine.class);
        if (statusLine != null) {
            statusLine.setMessage(true, msg, null);
        }
        shell.getDisplay().beep();
    }
}

