/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.GenerateHashCodeEqualsOperation;
import org.eclipse.jdt.internal.corext.dom.TypeRules;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.dialogs.GenerateHashCodeEqualsDialog;
import org.eclipse.jdt.internal.ui.dialogs.SourceActionDialog;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.actions.GenerateMethodAbstractAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public final class GenerateHashCodeEqualsAction
extends GenerateMethodAbstractAction {
    private static final String METHODNAME_HASH_CODE = "hashCode";
    private static final String METHODNAME_EQUALS = "equals";
    private List<IVariableBinding> allFields;
    private List<IVariableBinding> selectedFields;
    private ArrayList<ITypeBinding> alreadyCheckedMemberTypes;

    public GenerateHashCodeEqualsAction(CompilationUnitEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(this.fEditor != null && SelectionConverter.canOperateOn(this.fEditor));
    }

    public GenerateHashCodeEqualsAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.GenerateHashCodeEqualsAction_label);
        this.setDescription(ActionMessages.GenerateHashCodeEqualsAction_description);
        this.setToolTipText(ActionMessages.GenerateHashCodeEqualsAction_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.add_hashcode_equals_action_context");
    }

    boolean isMethodAlreadyImplemented(ITypeBinding typeBinding) {
        HashCodeEqualsInfo info = this.getTypeInfo(typeBinding, false);
        return info.foundEquals || info.foundHashCode;
    }

    private HashCodeEqualsInfo getTypeInfo(ITypeBinding someType, boolean checkSuperclasses) {
        HashCodeEqualsInfo info = new HashCodeEqualsInfo();
        if (someType.isTypeVariable()) {
            someType = someType.getErasure();
        }
        block0: do {
            IMethodBinding[] declaredMethods = someType.getDeclaredMethods();
            int i = 0;
            while (i < declaredMethods.length) {
                ITypeBinding[] b;
                if (declaredMethods[i].getName().equals(METHODNAME_EQUALS) && (b = declaredMethods[i].getParameterTypes()).length == 1 && b[0].getQualifiedName().equals("java.lang.Object")) {
                    info.foundEquals = true;
                    if (Modifier.isFinal(declaredMethods[i].getModifiers())) {
                        info.foundFinalEquals = true;
                    }
                }
                if (declaredMethods[i].getName().equals(METHODNAME_HASH_CODE) && declaredMethods[i].getParameterTypes().length == 0) {
                    info.foundHashCode = true;
                    if (Modifier.isFinal(declaredMethods[i].getModifiers())) {
                        info.foundFinalHashCode = true;
                    }
                }
                if (info.foundEquals && info.foundHashCode) continue block0;
                ++i;
            }
        } while (checkSuperclasses && (someType = someType.getSuperclass()) != null && !TypeRules.isJavaLangObject(someType));
        return info;
    }

    private RefactoringStatus checkHashCodeEqualsExists(ITypeBinding someType, boolean superClass) {
        RefactoringStatus status = new RefactoringStatus();
        HashCodeEqualsInfo info = this.getTypeInfo(someType, true);
        String concreteTypeWarning = superClass ? ActionMessages.GenerateMethodAbstractAction_super_class : ActionMessages.GenerateHashCodeEqualsAction_field_type;
        String concreteMethWarning = someType.isInterface() || Modifier.isAbstract(someType.getModifiers()) ? ActionMessages.GenerateHashCodeEqualsAction_interface_does_not_declare_hashCode_equals_error : ActionMessages.GenerateHashCodeEqualsAction_type_does_not_implement_hashCode_equals_error;
        String concreteHCEWarning = null;
        if (!info.foundEquals && !info.foundHashCode) {
            concreteHCEWarning = ActionMessages.GenerateHashCodeEqualsAction_equals_and_hashCode;
        } else if (!info.foundEquals) {
            concreteHCEWarning = ActionMessages.GenerateHashCodeEqualsAction_equals;
        } else if (!info.foundHashCode) {
            concreteHCEWarning = ActionMessages.GenerateHashCodeEqualsAction_hashCode;
        }
        if (!info.foundEquals || !info.foundHashCode) {
            status.addWarning(Messages.format(concreteMethWarning, new String[]{Messages.format(concreteTypeWarning, BindingLabelProvider.getBindingLabel(someType, JavaElementLabels.ALL_FULLY_QUALIFIED)), concreteHCEWarning}), GenerateHashCodeEqualsAction.createRefactoringStatusContext(someType.getJavaElement()));
        }
        if (superClass && (info.foundFinalEquals || info.foundFinalHashCode)) {
            status.addError(Messages.format(ActionMessages.GenerateMethodAbstractAction_final_method_in_superclass_error, new String[]{Messages.format(concreteTypeWarning, BasicElementLabels.getJavaElementName(someType.getQualifiedName())), ActionMessages.GenerateHashCodeEqualsAction_hashcode_or_equals}), GenerateHashCodeEqualsAction.createRefactoringStatusContext(someType.getJavaElement()));
        }
        return status;
    }

    CodeGenerationSettings createSettings(IType type, SourceActionDialog dialog) {
        HashCodeEqualsGenerationSettings settings = new HashCodeEqualsGenerationSettings();
        super.createSettings(type, dialog).setSettings(settings);
        settings.createComments = dialog.getGenerateComment();
        GenerateHashCodeEqualsDialog generateHashCodeEqualsDialog = (GenerateHashCodeEqualsDialog)dialog;
        settings.useInstanceOf = generateHashCodeEqualsDialog.isUseInstanceOf();
        settings.useBlocks = generateHashCodeEqualsDialog.isUseBlocks();
        return settings;
    }

    void initialize(IType type) throws JavaModelException {
        super.initialize(type);
        this.alreadyCheckedMemberTypes = new ArrayList();
    }

    String getAlreadyImplementedErrorMethodName() {
        return ActionMessages.GenerateHashCodeEqualsAction_hashcode_or_equals;
    }

    boolean generateCandidates() {
        IVariableBinding[] fCandidateFields = this.fTypeBinding.getDeclaredFields();
        this.allFields = new ArrayList<IVariableBinding>();
        this.selectedFields = new ArrayList<IVariableBinding>();
        int i = 0;
        while (i < fCandidateFields.length) {
            if (!Modifier.isStatic(fCandidateFields[i].getModifiers())) {
                this.allFields.add(fCandidateFields[i]);
                if (!Modifier.isTransient(fCandidateFields[i].getModifiers())) {
                    this.selectedFields.add(fCandidateFields[i]);
                }
            }
            ++i;
        }
        return !this.allFields.isEmpty();
    }

    SourceActionDialog createDialog(Shell shell, IType type) throws JavaModelException {
        IVariableBinding[] allFieldBindings = this.allFields.toArray(new IVariableBinding[0]);
        IVariableBinding[] selectedFieldBindings = this.selectedFields.toArray(new IVariableBinding[0]);
        return new GenerateHashCodeEqualsDialog(shell, this.fEditor, type, allFieldBindings, selectedFieldBindings);
    }

    RefactoringStatus checkSuperClass(ITypeBinding superclass) {
        return this.checkHashCodeEqualsExists(superclass, true);
    }

    RefactoringStatus checkGeneralConditions(IType type, CodeGenerationSettings settings, Object[] selected) {
        return new RefactoringStatus();
    }

    RefactoringStatus checkMember(Object memberBinding) {
        RefactoringStatus status = new RefactoringStatus();
        IVariableBinding variableBinding = (IVariableBinding)memberBinding;
        ITypeBinding fieldsType = variableBinding.getType();
        if (fieldsType.isArray()) {
            fieldsType = fieldsType.getElementType();
        }
        if (!(fieldsType.isPrimitive() || fieldsType.isEnum() || this.alreadyCheckedMemberTypes.contains(fieldsType) || fieldsType.equals(this.fTypeBinding))) {
            status.merge(this.checkHashCodeEqualsExists(fieldsType, false));
            this.alreadyCheckedMemberTypes.add(fieldsType);
        }
        if (Modifier.isTransient(variableBinding.getModifiers())) {
            status.addWarning(Messages.format(ActionMessages.GenerateHashCodeEqualsAction_transient_field_included_error, BasicElementLabels.getJavaElementName(variableBinding.getName())), GenerateHashCodeEqualsAction.createRefactoringStatusContext(variableBinding.getJavaElement()));
        }
        return status;
    }

    IWorkspaceRunnable createOperation(Object[] selectedBindings, CodeGenerationSettings settings, boolean regenerate, IJavaElement type, IJavaElement elementPosition) {
        IVariableBinding[] selectedVariableBindings = Arrays.asList(selectedBindings).toArray(new IVariableBinding[0]);
        HashCodeEqualsGenerationSettings hashCodeEqualsGenerationSettings = (HashCodeEqualsGenerationSettings)settings;
        GenerateHashCodeEqualsOperation operation = new GenerateHashCodeEqualsOperation(this.fTypeBinding, selectedVariableBindings, this.fUnit, elementPosition, settings, hashCodeEqualsGenerationSettings.useInstanceOf, regenerate, true, false);
        operation.setUseBlocksForThen(hashCodeEqualsGenerationSettings.useBlocks);
        return operation;
    }

    String getErrorCaption() {
        return ActionMessages.GenerateHashCodeEqualsAction_error_caption;
    }

    String getNoMembersError() {
        return ActionMessages.GenerateHashCodeEqualsAction_no_nonstatic_fields_error;
    }

    private class HashCodeEqualsGenerationSettings
    extends CodeGenerationSettings {
        public boolean useInstanceOf = false;
        public boolean useBlocks = false;

        private HashCodeEqualsGenerationSettings() {
        }
    }

    private class HashCodeEqualsInfo {
        public boolean foundHashCode = false;
        public boolean foundEquals = false;
        public boolean foundFinalHashCode = false;
        public boolean foundFinalEquals = false;

        private HashCodeEqualsInfo() {
        }
    }
}

