/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public class ModifyParametersAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public ModifyParametersAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public ModifyParametersAction(IWorkbenchSite site) {
        super(site);
        this.setText(RefactoringMessages.RefactoringGroup_modify_Parameters_label);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.modify_parameters_action");
    }

    public void selectionChanged(IStructuredSelection selection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isChangeSignatureAvailable(selection));
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.isExceptionToBeLogged(e)) {
                JavaPlugin.log(e);
            }
            this.setEnabled(false);
        }
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(true);
    }

    public void selectionChanged(JavaTextSelection selection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isChangeSignatureAvailable(selection));
        }
        catch (JavaModelException javaModelException) {
            this.setEnabled(false);
        }
    }

    public void run(IStructuredSelection selection) {
        try {
            if (RefactoringAvailabilityTester.isChangeSignatureAvailable(selection)) {
                IMethod method = ModifyParametersAction.getSingleSelectedMethod(selection);
                if (!ActionUtil.isEditable(this.getShell(), method)) {
                    return;
                }
                RefactoringExecutionStarter.startChangeSignatureRefactoring(method, this, this.getShell());
            }
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle(e, RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }

    public void run(ITextSelection selection) {
        try {
            if (!ActionUtil.isEditable(this.fEditor)) {
                return;
            }
            IMethod method = this.getSingleSelectedMethod(selection);
            if (RefactoringAvailabilityTester.isChangeSignatureAvailable(method)) {
                RefactoringExecutionStarter.startChangeSignatureRefactoring(method, this, this.getShell());
            } else {
                MessageDialog.openInformation((Shell)this.getShell(), (String)RefactoringMessages.OpenRefactoringWizardAction_unavailable, (String)RefactoringMessages.ModifyParametersAction_unavailable);
            }
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle(e, RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }

    private static IMethod getSingleSelectedMethod(IStructuredSelection selection) {
        if (selection.isEmpty() || selection.size() != 1) {
            return null;
        }
        if (selection.getFirstElement() instanceof IMethod) {
            return (IMethod)selection.getFirstElement();
        }
        return null;
    }

    private IMethod getSingleSelectedMethod(ITextSelection selection) throws JavaModelException {
        IJavaElement[] elements = SelectionConverter.codeResolve(this.fEditor);
        if (elements.length > 1) {
            return null;
        }
        if (elements.length == 1 && elements[0] instanceof IMethod) {
            return (IMethod)elements[0];
        }
        IJavaElement elementAt = SelectionConverter.getInputAsCompilationUnit(this.fEditor).getElementAt(selection.getOffset());
        if (elementAt instanceof IMethod) {
            return (IMethod)elementAt;
        }
        return null;
    }
}

