/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ISetSelectionTarget;

public class ShowInNavigatorViewAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public ShowInNavigatorViewAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.ShowInNavigatorView_label);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.show_in_navigator_action");
    }

    public ShowInNavigatorViewAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public void selectionChanged(ITextSelection selection) {
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.getResource(selection) != null);
    }

    public void run(ITextSelection selection) {
        ITypeRoot input = SelectionConverter.getInput(this.fEditor);
        if (!ActionUtil.isProcessable(this.getShell(), input)) {
            return;
        }
        try {
            IJavaElement[] elements = SelectionConverter.codeResolveOrInputForked(this.fEditor);
            if (elements == null || elements.length == 0) {
                return;
            }
            IJavaElement candidate = elements[0];
            if (elements.length > 1) {
                candidate = SelectionConverter.selectJavaElement(elements, this.getShell(), ShowInNavigatorViewAction.getDialogTitle(), ActionMessages.ShowInNavigatorView_dialog_message);
            }
            if (candidate != null) {
                this.run(this.getResource(candidate));
            }
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, ShowInNavigatorViewAction.getDialogTitle(), ActionMessages.SelectionConverter_codeResolve_failed);
        }
        catch (InterruptedException interruptedException) {}
    }

    public void run(IStructuredSelection selection) {
        this.run(this.getResource(selection));
    }

    public void run(IResource resource) {
        if (resource == null) {
            return;
        }
        try {
            IWorkbenchPage page = this.getSite().getWorkbenchWindow().getActivePage();
            IViewPart view = page.showView("org.eclipse.ui.views.ResourceNavigator");
            if (view instanceof ISetSelectionTarget) {
                StructuredSelection selection = new StructuredSelection((Object)resource);
                ((ISetSelectionTarget)view).selectReveal((ISelection)selection);
            }
        }
        catch (PartInitException e) {
            ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), ShowInNavigatorViewAction.getDialogTitle(), ActionMessages.ShowInNavigatorView_error_activation_failed);
        }
    }

    private IResource getResource(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return null;
        }
        Object element = selection.getFirstElement();
        if (element instanceof IResource) {
            return (IResource)element;
        }
        if (element instanceof IJavaElement) {
            return this.getResource((IJavaElement)element);
        }
        return null;
    }

    private IResource getResource(IJavaElement element) {
        if (element == null) {
            return null;
        }
        if ((element = (IJavaElement)((Object)element.getOpenable())) instanceof ICompilationUnit) {
            element = ((ICompilationUnit)element).getPrimary();
        }
        return element.getResource();
    }

    private static String getDialogTitle() {
        return ActionMessages.ShowInNavigatorView_dialog_title;
    }
}

