/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.codemanipulation.SortMembersOperation;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.jdt.internal.ui.dialogs.OptionalMessageDialog;
import org.eclipse.jdt.internal.ui.dialogs.SortMembersMessageDialog;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.IJavaAnnotation;
import org.eclipse.jdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.jdt.internal.ui.util.ElementValidator;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public class SortMembersAction
extends SelectionDispatchAction {
    private CompilationUnitEditor fEditor;
    private static final String ID_OPTIONAL_DIALOG = "org.eclipse.jdt.ui.actions.SortMembersAction";

    public SortMembersAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.SortMembersAction_label);
        this.setDescription(ActionMessages.SortMembersAction_description);
        this.setToolTipText(ActionMessages.SortMembersAction_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.sort_members_action");
    }

    public SortMembersAction(CompilationUnitEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(this.checkEnabledEditor());
    }

    private boolean checkEnabledEditor() {
        return this.fEditor != null && SelectionConverter.canOperateOn(this.fEditor);
    }

    public void selectionChanged(IStructuredSelection selection) {
        boolean enabled = false;
        enabled = this.getSelectedCompilationUnit(selection) != null;
        this.setEnabled(enabled);
    }

    public void run(IStructuredSelection selection) {
        Shell shell = this.getShell();
        try {
            ICompilationUnit cu = this.getSelectedCompilationUnit(selection);
            if (cu == null) {
                return;
            }
            IJavaElement[] types = cu.getTypes();
            if (!this.hasMembersToSort(types)) {
                return;
            }
            if (!ActionUtil.isEditable(this.getShell(), cu)) {
                return;
            }
            SortMembersMessageDialog dialog = new SortMembersMessageDialog(this.getShell());
            if (dialog.open() != 0) {
                return;
            }
            if (!ElementValidator.check(cu, this.getShell(), this.getDialogTitle(), false)) {
                return;
            }
            IEditorPart editor = JavaUI.openInEditor(cu);
            if (editor != null) {
                this.run(shell, cu, editor, dialog.isNotSortingFieldsEnabled());
            }
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, shell, this.getDialogTitle(), null);
        }
    }

    private boolean hasMembersToSort(IJavaElement[] members) throws JavaModelException {
        IJavaElement elem;
        if (members.length > 1) {
            return true;
        }
        if (members.length == 1 && (elem = members[0]) instanceof IParent) {
            return this.hasMembersToSort(((IParent)((Object)elem)).getChildren());
        }
        return false;
    }

    public void selectionChanged(ITextSelection selection) {
    }

    public void run(ITextSelection selection) {
        Shell shell = this.getShell();
        ITypeRoot input = SelectionConverter.getInput(this.fEditor);
        if (input instanceof ICompilationUnit) {
            if (!ActionUtil.isEditable(this.fEditor)) {
                return;
            }
            SortMembersMessageDialog dialog = new SortMembersMessageDialog(this.getShell());
            if (dialog.open() != 0) {
                return;
            }
            if (!ElementValidator.check(input, this.getShell(), this.getDialogTitle(), true)) {
                return;
            }
            this.run(shell, (ICompilationUnit)input, (IEditorPart)this.fEditor, dialog.isNotSortingFieldsEnabled());
        } else {
            MessageDialog.openInformation((Shell)shell, (String)this.getDialogTitle(), (String)ActionMessages.SortMembersAction_not_applicable);
        }
    }

    private boolean containsRelevantMarkers(IEditorPart editor) {
        IAnnotationModel model = JavaUI.getDocumentProvider().getAnnotationModel((Object)editor.getEditorInput());
        Iterator iterator = model.getAnnotationIterator();
        while (iterator.hasNext()) {
            IJavaAnnotation annot;
            Annotation element = (Annotation)iterator.next();
            if (!(element instanceof IJavaAnnotation) || (annot = (IJavaAnnotation)element).isMarkedDeleted() || !annot.isPersistent() || annot.isProblem()) continue;
            return true;
        }
        return false;
    }

    private void run(Shell shell, ICompilationUnit cu, IEditorPart editor, boolean isNotSortFields) {
        int returnCode;
        if (this.containsRelevantMarkers(editor) && (returnCode = OptionalMessageDialog.open(ID_OPTIONAL_DIALOG, this.getShell(), this.getDialogTitle(), null, ActionMessages.SortMembersAction_containsmarkers, 4, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0)) != 1025 && returnCode != 0) {
            return;
        }
        SortMembersOperation op = new SortMembersOperation(cu, null, isNotSortFields);
        try {
            BusyIndicatorRunnableContext context = new BusyIndicatorRunnableContext();
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)context, (IRunnableWithProgress)new WorkbenchRunnableAdapter(op, op.getScheduleRule()), op.getScheduleRule());
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, shell, this.getDialogTitle(), null);
        }
        catch (InterruptedException interruptedException) {}
    }

    private ICompilationUnit getSelectedCompilationUnit(IStructuredSelection selection) {
        if (selection.size() == 1) {
            IType type;
            Object element = selection.getFirstElement();
            if (element instanceof ICompilationUnit) {
                return (ICompilationUnit)element;
            }
            if (element instanceof IType && (type = (IType)element).getParent() instanceof ICompilationUnit) {
                return type.getCompilationUnit();
            }
        }
        return null;
    }

    private String getDialogTitle() {
        return ActionMessages.SortMembersAction_dialog_title;
    }
}

