/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.cleanup;

import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CleanUpOptions {
    private final Map<String, String> fOptions;
    public static final String TRUE = "true";
    public static final String FALSE = "false";

    protected CleanUpOptions(Map<String, String> options) {
        this.fOptions = options;
    }

    public CleanUpOptions() {
        this.fOptions = new Hashtable<String, String>();
    }

    public boolean isEnabled(String key) {
        Assert.isLegal(key != null);
        String value = this.fOptions.get(key);
        return TRUE == value || TRUE.equals(value);
    }

    public String getValue(String key) {
        Assert.isLegal(key != null);
        String value = this.fOptions.get(key);
        Assert.isLegal(value != null);
        return value;
    }

    public void setOption(String key, String value) {
        Assert.isLegal(key != null);
        Assert.isLegal(value != null);
        this.fOptions.put(key, value);
    }

    public Set<String> getKeys() {
        return Collections.unmodifiableSet(this.fOptions.keySet());
    }
}

