/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.jarpackager;

import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.jarpackager.JarFileExportOperation;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackageReader;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackageWriter;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackagerUtil;
import org.eclipse.jdt.internal.ui.jarpackager.PlainJarBuilder;
import org.eclipse.jdt.internal.ui.jarpackagerfat.UnpackFatJarBuilder;
import org.eclipse.jdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.jdt.ui.jarpackager.IJarBuilder;
import org.eclipse.jdt.ui.jarpackager.IJarDescriptionReader;
import org.eclipse.jdt.ui.jarpackager.IJarDescriptionWriter;
import org.eclipse.jdt.ui.jarpackager.IJarExportRunnable;
import org.eclipse.jdt.ui.jarpackager.IManifestProvider;
import org.eclipse.jdt.ui.jarpackager.JarWriter2;
import org.eclipse.jdt.ui.jarpackager.JarWriter3;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.swt.widgets.Shell;

public class JarPackageData {
    private String fManifestVersion;
    private boolean fExportClassFiles;
    private boolean fExportOutputFolders;
    private boolean fExportJavaFiles;
    private boolean fUseSourceFolderHierarchy;
    private boolean fBuildIfNeeded;
    private Object[] fElements;
    private IPath fJarLocation;
    private boolean fOverwrite;
    private boolean fCompress;
    private boolean fSaveDescription;
    private IPath fDescriptionLocation;
    private boolean fUsesManifest;
    private boolean fSaveManifest;
    private boolean fReuseManifest;
    private boolean fGenerateManifest;
    private IPath fManifestLocation;
    private boolean fSealJar;
    private IPackageFragment[] fPackagesToSeal;
    private IPackageFragment[] fPackagesToUnseal;
    private IType fManifestMainClass;
    private String fComment;
    private boolean fExportErrors;
    private boolean fExportWarnings;
    private IManifestProvider fManifestProvider;
    private boolean fIncludeDirectoryEntries;
    private IProject[] fRefactoringProjects = new IProject[0];
    private boolean fRefactoringAware = false;
    private boolean fRefactoringStructural = false;
    private boolean fDeprecationAware = true;
    private RefactoringDescriptorProxy[] fRefactoringDescriptors = new RefactoringDescriptorProxy[0];
    private IJarBuilder fJarBuilder;
    private String fLaunchConfigurationName;

    public JarPackageData() {
        this.setExportClassFiles(true);
        this.setExportOutputFolders(false);
        this.setUseSourceFolderHierarchy(false);
        this.setCompress(true);
        this.setSaveDescription(false);
        this.setJarLocation(Path.EMPTY);
        this.setDescriptionLocation(Path.EMPTY);
        this.setUsesManifest(true);
        this.setGenerateManifest(true);
        this.setReuseManifest(false);
        this.setSaveManifest(false);
        this.setManifestLocation(Path.EMPTY);
        this.setExportErrors(true);
        this.setExportWarnings(true);
        this.setBuildIfNeeded(true);
        this.setIncludeDirectoryEntries(false);
    }

    public boolean isCompressed() {
        return this.fCompress;
    }

    public void setCompress(boolean state) {
        this.fCompress = state;
    }

    public boolean allowOverwrite() {
        return this.fOverwrite;
    }

    public void setOverwrite(boolean state) {
        this.fOverwrite = state;
    }

    public boolean areClassFilesExported() {
        return this.fExportClassFiles;
    }

    public void setExportClassFiles(boolean state) {
        this.fExportClassFiles = state;
    }

    public boolean areOutputFoldersExported() {
        return this.fExportOutputFolders;
    }

    public void setExportOutputFolders(boolean state) {
        this.fExportOutputFolders = state;
    }

    public boolean areGeneratedFilesExported() {
        return this.fExportOutputFolders || this.fExportClassFiles;
    }

    public boolean areJavaFilesExported() {
        return this.fExportJavaFiles;
    }

    public void setExportJavaFiles(boolean state) {
        this.fExportJavaFiles = state;
    }

    public boolean useSourceFolderHierarchy() {
        return this.fUseSourceFolderHierarchy;
    }

    public void setUseSourceFolderHierarchy(boolean state) {
        this.fUseSourceFolderHierarchy = state;
    }

    public IPath getAbsoluteJarLocation() {
        if (!this.fJarLocation.isAbsolute()) {
            IFile file;
            IPath absolutePath;
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            if (this.fJarLocation.segmentCount() >= 2 && !"..".equals(this.fJarLocation.segment(0)) && (absolutePath = (file = root.getFile(this.fJarLocation)).getLocation()) != null) {
                return absolutePath;
            }
            return root.getLocation().append(this.fJarLocation);
        }
        return this.fJarLocation;
    }

    public IPath getJarLocation() {
        return this.fJarLocation;
    }

    public void setJarLocation(IPath jarLocation) {
        this.fJarLocation = jarLocation;
    }

    public boolean isManifestGenerated() {
        return this.fGenerateManifest;
    }

    public void setGenerateManifest(boolean state) {
        this.fGenerateManifest = state;
    }

    public boolean isManifestSaved() {
        return this.fSaveManifest;
    }

    public void setSaveManifest(boolean state) {
        this.fSaveManifest = state;
        if (!this.fSaveManifest) {
            this.setReuseManifest(false);
        }
    }

    public boolean isManifestReused() {
        return this.fReuseManifest;
    }

    public void setReuseManifest(boolean state) {
        this.fReuseManifest = state;
        if (this.fReuseManifest) {
            this.setSaveManifest(true);
        }
    }

    public IPath getManifestLocation() {
        return this.fManifestLocation;
    }

    public void setManifestLocation(IPath manifestLocation) {
        this.fManifestLocation = manifestLocation;
    }

    public IFile getManifestFile() {
        IPath path = this.getManifestLocation();
        if (path.isValidPath(path.toString()) && path.segmentCount() >= 2) {
            return JavaPlugin.getWorkspace().getRoot().getFile(path);
        }
        return null;
    }

    public String getManifestVersion() {
        if (this.fManifestVersion == null) {
            return "1.0";
        }
        return this.fManifestVersion;
    }

    public void setManifestVersion(String manifestVersion) {
        this.fManifestVersion = manifestVersion;
    }

    public boolean usesManifest() {
        return this.fUsesManifest;
    }

    public void setUsesManifest(boolean state) {
        this.fUsesManifest = state;
    }

    public IManifestProvider getManifestProvider() {
        if (this.fManifestProvider == null) {
            return this.getJarBuilder().getManifestProvider();
        }
        return this.fManifestProvider;
    }

    public void setManifestProvider(IManifestProvider manifestProvider) {
        this.fManifestProvider = manifestProvider;
    }

    public boolean isJarSealed() {
        return this.fSealJar;
    }

    public void setSealJar(boolean sealJar) {
        this.fSealJar = sealJar;
    }

    public void setPackagesToSeal(IPackageFragment[] packagesToSeal) {
        this.fPackagesToSeal = packagesToSeal;
    }

    public IPackageFragment[] getPackagesToSeal() {
        if (this.fPackagesToSeal == null) {
            return new IPackageFragment[0];
        }
        return this.fPackagesToSeal;
    }

    public IPackageFragment[] getPackagesToUnseal() {
        if (this.fPackagesToUnseal == null) {
            return new IPackageFragment[0];
        }
        return this.fPackagesToUnseal;
    }

    public void setPackagesToUnseal(IPackageFragment[] packagesToUnseal) {
        this.fPackagesToUnseal = packagesToUnseal;
    }

    public boolean isDescriptionSaved() {
        return this.fSaveDescription;
    }

    public void setSaveDescription(boolean state) {
        this.fSaveDescription = state;
    }

    public IPath getDescriptionLocation() {
        return this.fDescriptionLocation;
    }

    public void setDescriptionLocation(IPath descriptionLocation) {
        this.fDescriptionLocation = descriptionLocation;
    }

    public IFile getDescriptionFile() {
        IPath path = this.getDescriptionLocation();
        if (path.isValidPath(path.toString()) && path.segmentCount() >= 2) {
            return JavaPlugin.getWorkspace().getRoot().getFile(path);
        }
        return null;
    }

    public IType getManifestMainClass() {
        return this.fManifestMainClass;
    }

    public void setManifestMainClass(IType manifestMainClass) {
        this.fManifestMainClass = manifestMainClass;
    }

    public Object[] getElements() {
        if (this.fElements == null) {
            this.setElements(new Object[0]);
        }
        return this.fElements;
    }

    public void setElements(Object[] elements) {
        this.fElements = elements;
    }

    public String getComment() {
        return this.fComment;
    }

    public void setComment(String comment) {
        this.fComment = comment;
    }

    public boolean logErrors() {
        return true;
    }

    public void setLogErrors(boolean logErrors) {
    }

    public boolean logWarnings() {
        return true;
    }

    public void setLogWarnings(boolean logWarnings) {
    }

    public boolean areErrorsExported() {
        return this.fExportErrors;
    }

    public void setExportErrors(boolean exportErrors) {
        this.fExportErrors = exportErrors;
    }

    public boolean exportWarnings() {
        return this.fExportWarnings;
    }

    public void setExportWarnings(boolean exportWarnings) {
        this.fExportWarnings = exportWarnings;
    }

    public boolean isBuildingIfNeeded() {
        return this.fBuildIfNeeded;
    }

    public void setBuildIfNeeded(boolean buildIfNeeded) {
        this.fBuildIfNeeded = buildIfNeeded;
    }

    public IFile[] findClassfilesFor(IFile javaFile) throws CoreException {
        return null;
    }

    public JarWriter2 createJarWriter(Shell parent) throws CoreException {
        return new JarWriter2(this, parent);
    }

    public JarWriter3 createJarWriter3(Shell parent) throws CoreException {
        return new JarWriter3(this, parent);
    }

    public IJarBuilder createPlainJarBuilder() {
        return new PlainJarBuilder();
    }

    public IJarBuilder createFatJarBuilder() {
        return new UnpackFatJarBuilder();
    }

    public IJarExportRunnable createJarExportRunnable(Shell parent) {
        return new JarFileExportOperation(this, parent);
    }

    public IJarExportRunnable createJarExportRunnable(JarPackageData[] jarPackagesData, Shell parent) {
        return new JarFileExportOperation(jarPackagesData, parent);
    }

    public IJarDescriptionWriter createJarDescriptionWriter(OutputStream outputStream) {
        return new JarPackageWriter(outputStream, "UTF-8");
    }

    public IJarDescriptionWriter createJarDescriptionWriter(OutputStream outputStream, String encoding) {
        return new JarPackageWriter(outputStream, encoding);
    }

    public IJarDescriptionReader createJarDescriptionReader(InputStream inputStream) {
        return new JarPackageReader(inputStream);
    }

    public boolean isValid() {
        return (this.areGeneratedFilesExported() || this.areJavaFilesExported()) && this.getElements() != null && this.getElements().length > 0 && this.getAbsoluteJarLocation() != null && this.isManifestAccessible() && this.isMainClassValid(new BusyIndicatorRunnableContext());
    }

    public boolean isManifestAccessible() {
        if (this.isManifestGenerated()) {
            return true;
        }
        IFile file = this.getManifestFile();
        return file != null && file.isAccessible();
    }

    public boolean isMainClassValid(IRunnableContext context) {
        return JarPackagerUtil.isMainClassValid(this, context);
    }

    public boolean areDirectoryEntriesIncluded() {
        return this.fIncludeDirectoryEntries;
    }

    public void setIncludeDirectoryEntries(boolean includeDirectoryEntries) {
        this.fIncludeDirectoryEntries = includeDirectoryEntries;
    }

    public IProject[] getRefactoringProjects() {
        return this.fRefactoringProjects;
    }

    public boolean isExportStructuralOnly() {
        return this.fRefactoringStructural;
    }

    public boolean isRefactoringAware() {
        return this.fRefactoringAware;
    }

    public boolean isDeprecationAware() {
        return this.fDeprecationAware;
    }

    public void setRefactoringProjects(IProject[] projects) {
        Assert.isNotNull(projects);
        this.fRefactoringProjects = projects;
    }

    public void setRefactoringAware(boolean aware) {
        this.fRefactoringAware = aware;
    }

    public void setDeprecationAware(boolean aware) {
        this.fDeprecationAware = aware;
    }

    public void setRefactoringDescriptors(RefactoringDescriptorProxy[] descriptors) {
        Assert.isNotNull(descriptors);
        this.fRefactoringDescriptors = descriptors;
    }

    public RefactoringDescriptorProxy[] getRefactoringDescriptors() {
        return this.fRefactoringDescriptors;
    }

    public void setExportStructuralOnly(boolean structural) {
        this.fRefactoringStructural = structural;
    }

    public IJarBuilder getJarBuilder() {
        if (this.fJarBuilder == null) {
            this.fJarBuilder = this.createPlainJarBuilder();
        }
        return this.fJarBuilder;
    }

    public void setJarBuilder(IJarBuilder jarBuilder) {
        this.fJarBuilder = jarBuilder;
    }

    public String getLaunchConfigurationName() {
        return this.fLaunchConfigurationName;
    }

    public void setLaunchConfigurationName(String name) {
        this.fLaunchConfigurationName = name;
    }
}

