/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathsBlock;
import org.eclipse.jdt.ui.wizards.NewElementWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class JavaCapabilityConfigurationPage
extends NewElementWizardPage {
    private static final String PAGE_NAME = "JavaCapabilityConfigurationPage";
    private IJavaProject fJavaProject = null;
    private BuildPathsBlock fBuildPathsBlock;

    public JavaCapabilityConfigurationPage() {
        super(PAGE_NAME);
        this.setTitle(NewWizardMessages.JavaCapabilityConfigurationPage_title);
        this.setDescription(NewWizardMessages.JavaCapabilityConfigurationPage_description);
    }

    private BuildPathsBlock getBuildPathsBlock() {
        if (this.fBuildPathsBlock == null) {
            IStatusChangeListener listener = new IStatusChangeListener(){

                public void statusChanged(IStatus status) {
                    JavaCapabilityConfigurationPage.this.updateStatus(status);
                }
            };
            this.fBuildPathsBlock = new BuildPathsBlock(new BusyIndicatorRunnableContext(), listener, 0, this.useNewSourcePage(), null);
        }
        return this.fBuildPathsBlock;
    }

    public void dispose() {
        try {
            super.dispose();
        }
        finally {
            if (this.fBuildPathsBlock != null) {
                this.fBuildPathsBlock.dispose();
                this.fBuildPathsBlock = null;
            }
        }
    }

    protected boolean useNewSourcePage() {
        return false;
    }

    public void init(IJavaProject jproject, IPath defaultOutputLocation, IClasspathEntry[] defaultEntries, boolean defaultsOverrideExistingClasspath) {
        if (!defaultsOverrideExistingClasspath && jproject.exists() && jproject.getProject().getFile(".classpath").exists()) {
            defaultOutputLocation = null;
            defaultEntries = null;
        }
        this.getBuildPathsBlock().init(jproject, defaultOutputLocation, defaultEntries);
        this.fJavaProject = jproject;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout(1, false));
        Control control = this.getBuildPathsBlock().createControl(composite);
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jdt.ui.new_javaproject_wizard_page_context");
        this.setControl((Control)composite);
    }

    public IPath getOutputLocation() {
        return this.getBuildPathsBlock().getOutputLocation();
    }

    public IClasspathEntry[] getRawClassPath() {
        return this.getBuildPathsBlock().getRawClassPath();
    }

    public IJavaProject getJavaProject() {
        return this.fJavaProject;
    }

    public IRunnableWithProgress getRunnable() {
        if (this.getJavaProject() != null) {
            return new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        JavaCapabilityConfigurationPage.this.configureJavaProject(monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
        }
        return null;
    }

    public static void createProject(IProject project, IPath locationPath, IProgressMonitor monitor) throws CoreException {
        JavaCapabilityConfigurationPage.createProject(project, locationPath != null ? URIUtil.toURI((IPath)locationPath) : null, monitor);
    }

    public static void createProject(IProject project, URI locationURI, IProgressMonitor monitor) throws CoreException {
        BuildPathsBlock.createProject(project, locationURI, monitor);
    }

    public void configureJavaProject(IProgressMonitor monitor) throws CoreException, InterruptedException {
        this.configureJavaProject(null, monitor);
    }

    public void configureJavaProject(String newProjectCompliance, IProgressMonitor monitor) throws CoreException, InterruptedException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        int nSteps = 6;
        monitor.beginTask(NewWizardMessages.JavaCapabilityConfigurationPage_op_desc_java, nSteps);
        try {
            try {
                IProject project = this.getJavaProject().getProject();
                BuildPathsBlock.addJavaNature(project, new SubProgressMonitor(monitor, 1));
                this.getBuildPathsBlock().configureJavaProject(newProjectCompliance, new SubProgressMonitor(monitor, 5));
            }
            catch (OperationCanceledException operationCanceledException) {
                throw new InterruptedException();
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void setFocus() {
        this.getBuildPathsBlock().setFocus();
    }
}

