/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.client.eclipse;

import com.microsoft.tfs.client.common.console.NullConsole;
import com.microsoft.tfs.client.common.console.TFSConsoleProvider;
import com.microsoft.tfs.client.common.console.TFSEclipseConsole;
import com.microsoft.tfs.client.common.logging.TELoggingConfiguration;
import com.microsoft.tfs.client.common.repository.RepositoryManager;
import com.microsoft.tfs.client.common.server.ServerManager;
import com.microsoft.tfs.client.common.util.ExtensionLoader;
import com.microsoft.tfs.client.eclipse.Messages;
import com.microsoft.tfs.client.eclipse.project.ProjectRepositoryManager;
import com.microsoft.tfs.client.eclipse.refresh.ResourceRefreshManager;
import com.microsoft.tfs.client.eclipse.resourcechange.TFSResourceChangeListener;
import com.microsoft.tfs.client.eclipse.resourcedata.ResourceDataManager;
import com.microsoft.tfs.core.product.ProductInformation;
import com.microsoft.tfs.core.product.ProductName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.osgi.framework.BundleContext;

public final class TFSEclipseClientPlugin
extends Plugin {
    public static final String PLUGIN_ID = "com.microsoft.tfs.client.eclipse";
    private static final Log log = LogFactory.getLog(TFSEclipseClientPlugin.class);
    public static final String TFS_CONSOLE_EXTENSION_POINT_ID = "com.microsoft.tfs.client.eclipse.consoleProvider";
    private static TFSEclipseClientPlugin plugin;
    private final ServerManager serverManager = new ServerManager();
    private final RepositoryManager repositoryManager = new RepositoryManager();
    private final ProjectRepositoryManager projectManager = new ProjectRepositoryManager(this.serverManager, this.repositoryManager);
    private final ResourceRefreshManager resourceRefreshManager = new ResourceRefreshManager(this.repositoryManager);
    private final ResourceDataManager resourceDataManager = new ResourceDataManager(ResourcesPlugin.getWorkspace().getSynchronizer());
    private final TFSResourceChangeListener resourceChangedListener = new TFSResourceChangeListener();
    private final Object consoleLock = new Object();
    private TFSConsoleProvider consoleProvider = null;

    public TFSEclipseClientPlugin() {
        ProductInformation.initialize((ProductName)ProductName.PLUGIN);
        TELoggingConfiguration.configure();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceChangedListener, 1);
        Job projectStartupJob = new Job(Messages.getString("TFSEclipseClientPlugin.ConnectintToTfsJobTitle")){

            protected IStatus run(IProgressMonitor progressMonitor) {
                TFSEclipseClientPlugin.this.projectManager.start();
                return Status.OK_STATUS;
            }
        };
        projectStartupJob.setSystem(true);
        projectStartupJob.schedule();
    }

    public void stop(BundleContext context) throws Exception {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceChangedListener);
        plugin = null;
        super.stop(context);
    }

    public static TFSEclipseClientPlugin getDefault() {
        return plugin;
    }

    public ServerManager getServerManager() {
        return this.serverManager;
    }

    public RepositoryManager getRepositoryManager() {
        return this.repositoryManager;
    }

    public ProjectRepositoryManager getProjectManager() {
        return this.projectManager;
    }

    public ResourceDataManager getResourceDataManager() {
        return this.resourceDataManager;
    }

    public TFSResourceChangeListener getResourceChangeListener() {
        return this.resourceChangedListener;
    }

    public ResourceRefreshManager getResourceRefreshManager() {
        return this.resourceRefreshManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final TFSConsoleProvider getConsoleProvider() {
        Object object = this.consoleLock;
        synchronized (object) {
            if (this.consoleProvider == null) {
                try {
                    this.consoleProvider = (TFSConsoleProvider)ExtensionLoader.loadSingleExtensionClass((String)TFS_CONSOLE_EXTENSION_POINT_ID);
                }
                catch (Exception e) {
                    log.error((Object)"Could not load TFS console provider for the product", (Throwable)e);
                    this.consoleProvider = null;
                }
            }
            return this.consoleProvider;
        }
    }

    public TFSEclipseConsole getConsole() {
        TFSConsoleProvider consoleProvider = this.getConsoleProvider();
        if (consoleProvider != null) {
            return consoleProvider.getConsole();
        }
        return new NullConsole();
    }
}

