/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.client.eclipse;

import com.microsoft.tfs.client.common.commands.vc.AddCommand;
import com.microsoft.tfs.client.common.commands.vc.DeleteCommand;
import com.microsoft.tfs.client.common.commands.vc.DeleteWorkingFolderCommand;
import com.microsoft.tfs.client.common.commands.vc.EditCommand;
import com.microsoft.tfs.client.common.commands.vc.QueryItemsCommand;
import com.microsoft.tfs.client.common.commands.vc.QueryItemsExtendedCommand;
import com.microsoft.tfs.client.common.commands.vc.RefreshPendingChangesCommand;
import com.microsoft.tfs.client.common.commands.vc.RenameCommand;
import com.microsoft.tfs.client.common.commands.vc.RenameMultipleCommand;
import com.microsoft.tfs.client.common.commands.vc.UndoCommand;
import com.microsoft.tfs.client.common.commands.vc.UpdateLocalVersionCommand;
import com.microsoft.tfs.client.common.framework.command.Command;
import com.microsoft.tfs.client.common.framework.command.CommandExecutor;
import com.microsoft.tfs.client.common.framework.command.ExtensionPointAsyncObjectWaiter;
import com.microsoft.tfs.client.common.framework.command.IAsyncObjectWaiter;
import com.microsoft.tfs.client.common.framework.command.ICommand;
import com.microsoft.tfs.client.common.framework.command.JobCommandAdapter;
import com.microsoft.tfs.client.common.framework.resources.filter.CompositeResourceFilter;
import com.microsoft.tfs.client.common.framework.resources.filter.ResourceFilter;
import com.microsoft.tfs.client.common.framework.resources.filter.ResourceFilters;
import com.microsoft.tfs.client.common.repository.TFSRepository;
import com.microsoft.tfs.client.eclipse.Messages;
import com.microsoft.tfs.client.eclipse.TFSEclipseClientPlugin;
import com.microsoft.tfs.client.eclipse.TFSRepositoryProvider;
import com.microsoft.tfs.client.eclipse.filemodification.TFSFileModificationValidator;
import com.microsoft.tfs.client.eclipse.project.ProjectRepositoryStatus;
import com.microsoft.tfs.client.eclipse.repository.ResourceRepositoryMap;
import com.microsoft.tfs.client.eclipse.resource.PluginResourceFilters;
import com.microsoft.tfs.client.eclipse.resource.PluginResourceHelpers;
import com.microsoft.tfs.client.eclipse.resourcedata.ResourceDataManager;
import com.microsoft.tfs.client.eclipse.util.TeamUtils;
import com.microsoft.tfs.core.clients.versioncontrol.ClientLocalVersionUpdate;
import com.microsoft.tfs.core.clients.versioncontrol.GetItemsOptions;
import com.microsoft.tfs.core.clients.versioncontrol.GetOptions;
import com.microsoft.tfs.core.clients.versioncontrol.PendChangesOptions;
import com.microsoft.tfs.core.clients.versioncontrol.UpdateLocalVersionQueueOptions;
import com.microsoft.tfs.core.clients.versioncontrol.WorkspaceLocation;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.VersionControlException;
import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.core.clients.versioncontrol.path.ServerPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ChangeType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.DeletedState;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ExtendedItem;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemSet;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.LockLevel;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PendingChange;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RecursionType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.WorkingFolder;
import com.microsoft.tfs.core.clients.versioncontrol.specs.ItemSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.VersionSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.WorkspaceVersionSpec;
import com.microsoft.tfs.core.exceptions.InputValidationException;
import com.microsoft.tfs.core.product.ProductInformation;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.TypesafeEnum;
import java.io.File;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.team.IMoveDeleteHook;
import org.eclipse.core.resources.team.IResourceTree;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TFSMoveDeleteHook
implements IMoveDeleteHook {
    private final Log log = LogFactory.getLog(TFSMoveDeleteHook.class);
    private static final ChangeType ALL_CHANGE_TYPES = ChangeType.combine((ChangeType[])new ChangeType[]{ChangeType.ADD, ChangeType.BRANCH, ChangeType.DELETE, ChangeType.EDIT, ChangeType.ENCODING, ChangeType.LOCK, ChangeType.MERGE, ChangeType.RENAME, ChangeType.ROLLBACK, ChangeType.SOURCE_RENAME, ChangeType.UNDELETE});
    private static final ChangeType DELETE_DENIED_CHANGE_TYPES = ChangeType.combine((ChangeType[])new ChangeType[]{ChangeType.BRANCH, ChangeType.LOCK, ChangeType.MERGE, ChangeType.RENAME, ChangeType.ROLLBACK, ChangeType.SOURCE_RENAME, ChangeType.UNDELETE});
    private static final ChangeType ADD_DENIED_CHANGE_TYPES = ALL_CHANGE_TYPES;
    private static final ChangeType MOVE_DENIED_CHANGE_TYPES = ChangeType.combine((ChangeType[])new ChangeType[]{ChangeType.BRANCH, ChangeType.MERGE, ChangeType.SOURCE_RENAME});
    private static final ResourceFilter IGNORED_RESOURCES_FILTER = new CompositeResourceFilter.Builder(CompositeResourceFilter.CompositeResourceFilterType.ALL_MUST_ACCEPT).addFilter(PluginResourceFilters.TEAM_IGNORED_RESOURCES_FILTER).addFilter(ResourceFilters.TEAM_PRIVATE_RESOURCES_FILTER).addFilter(PluginResourceFilters.TPIGNORE_FILTER).build();
    private final TFSRepositoryProvider repositoryProvider;

    public TFSMoveDeleteHook(TFSRepositoryProvider repositoryProvider) {
        this.repositoryProvider = repositoryProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteFile(IResourceTree tree, IFile file, int updateFlags, IProgressMonitor progressMonitor) {
        this.log.trace((Object)("deleteFile: " + file.getFullPath()));
        progressMonitor.beginTask(MessageFormat.format(Messages.getString("TFSMoveDeleteHook.DeletingPathFormat"), file.getFullPath()), 30);
        try {
            ResourceInspectionResult inspectionResult = this.inspectResource(tree, (IResource)file, true, true, DELETE_DENIED_CHANGE_TYPES, updateFlags, false, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 5));
            if (inspectionResult.getStatus().equals((Object)ResourceInspectionStatus.DEFER)) {
                boolean bl = false;
                return bl;
            }
            if (this.repositoryProvider.getRepositoryStatus() == ProjectRepositoryStatus.CONNECTING) {
                throw new RuntimeException(Messages.getString("TFSMoveDeleteHook.ConnectionInProgressWaitBeforeDeleting"));
            }
            this.log.info((Object)MessageFormat.format("Deletion detected for file {0}", file));
            TFSRepository repository = inspectionResult.getRepository();
            PendingChange[] pendingChanges = inspectionResult.getPendingChanges();
            IStatus deleteStatus = this.deleteFile(file, repository, pendingChanges, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 10));
            if (!deleteStatus.isOK()) {
                throw new RuntimeException(deleteStatus.getMessage());
            }
            tree.standardDeleteFile(file, updateFlags, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 5));
            boolean bl = true;
            return bl;
        }
        finally {
            progressMonitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStatus deleteFile(IFile file, TFSRepository repository, PendingChange[] pendingChanges, IProgressMonitor progressMonitor) {
        progressMonitor.beginTask(MessageFormat.format(Messages.getString("TFSMoveDeleteHook.DeletingPathFormat"), file.getFullPath()), 20);
        try {
            DeleteCommand deleteCommand;
            IStatus deleteStatus;
            UndoCommand undoCommand;
            IStatus undoStatus;
            if (pendingChanges.length > 1) {
                throw new RuntimeException(Messages.getString("TFSMoveDeleteHook.ReceivedMultiplePendingChangesForSingleFile"));
            }
            if (pendingChanges.length == 1 && !(undoStatus = this.runCommand((Command)(undoCommand = new UndoCommand(repository, new ItemSpec[]{new ItemSpec(file.getLocation().toOSString(), RecursionType.NONE)})), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 10))).isOK()) {
                IStatus iStatus = undoStatus;
                return iStatus;
            }
            if (!(pendingChanges.length != 0 && pendingChanges[0].getChangeType().contains(ChangeType.ADD) || (deleteStatus = this.runCommand((Command)(deleteCommand = new DeleteCommand(repository, new String[]{file.getLocation().toOSString()}, RecursionType.NONE, LockLevel.UNCHANGED, GetOptions.NO_DISK_UPDATE, PendChangesOptions.NONE)), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 10))).isOK() || deleteStatus.getSeverity() != 4)) {
                IStatus iStatus = deleteStatus;
                return iStatus;
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            progressMonitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteFolder(IResourceTree tree, IFolder folder, int updateFlags, IProgressMonitor progressMonitor) {
        this.log.info((Object)("deleteFolder: " + folder.getFullPath()));
        if (this.repositoryProvider.getRepositoryStatus() == ProjectRepositoryStatus.CONNECTING) {
            throw new RuntimeException(Messages.getString("TFSMoveDeleteHook.ConnectionInProgressWaitBeforeDeleting"));
        }
        progressMonitor.beginTask(MessageFormat.format(Messages.getString("TFSMoveDeleteHook.DeletingPathFormat"), folder.getFullPath()), 20);
        try {
            ResourceInspectionResult inspectionResult = this.inspectResource(tree, (IResource)folder, true, true, DELETE_DENIED_CHANGE_TYPES, updateFlags, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 5));
            if (inspectionResult.getStatus().equals((Object)ResourceInspectionStatus.DEFER)) {
                boolean bl = false;
                return bl;
            }
            if (inspectionResult.getStatus().equals((Object)ResourceInspectionStatus.WARN)) {
                TFSEclipseClientPlugin.getDefault().getConsole().printWarning(inspectionResult.getMessage());
                this.log.warn((Object)"Deletion should be done later by a separate user's request.");
                this.log.warn((Object)inspectionResult.getMessage());
                boolean bl = true;
                return bl;
            }
            this.log.info((Object)MessageFormat.format("Deletion detected for folder {0}", folder));
            TFSRepository repository = inspectionResult.getRepository();
            PendingChange[] pendingChanges = inspectionResult.getPendingChanges();
            boolean isInServer = inspectionResult.isInServer();
            IStatus deleteStatus = this.deleteFolder(folder, repository, isInServer, pendingChanges, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 10));
            if (!deleteStatus.isOK()) {
                PendingChange[] allChanges = repository.getPendingChangeCache().getPendingChanges();
                this.log.info((Object)("All pending changes: [" + String.valueOf(allChanges.length) + "]"));
                for (PendingChange change : allChanges) {
                    this.log.info((Object)("  ChangeType: " + change.getChangeType().toString()));
                    this.log.info((Object)("    ServerItem: " + change.getServerItem()));
                    this.log.info((Object)("    LocalItem: " + (change.getLocalItem() == null ? "null" : change.getLocalItem())));
                    this.log.info((Object)("    SourceLocalItem: " + (change.getSourceLocalItem() == null ? "null" : change.getSourceLocalItem())));
                    this.log.info((Object)("    SourceServerItem: " + (change.getSourceServerItem() == null ? "null" : change.getSourceServerItem())));
                    this.log.info((Object)("    Date: " + new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS z").format(change.getWebServiceObject().getDate().getTime())));
                }
                this.log.info((Object)"Refreshing pending changes cache");
                repository.getPendingChangeCache().refresh();
                allChanges = repository.getPendingChangeCache().getPendingChanges();
                this.log.info((Object)("All pending changes: [" + String.valueOf(allChanges.length) + "]"));
                for (PendingChange change : allChanges) {
                    this.log.info((Object)("  ChangeType: " + change.getChangeType().toString()));
                    this.log.info((Object)("    ServerItem: " + change.getServerItem()));
                    this.log.info((Object)("    LocalItem: " + (change.getLocalItem() == null ? "null" : change.getLocalItem())));
                    this.log.info((Object)("    SourceLocalItem: " + (change.getSourceLocalItem() == null ? "null" : change.getSourceLocalItem())));
                    this.log.info((Object)("    SourceServerItem: " + (change.getSourceServerItem() == null ? "null" : change.getSourceServerItem())));
                    this.log.info((Object)("    Date: " + new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS z").format(change.getWebServiceObject().getDate().getTime())));
                }
                throw new RuntimeException(deleteStatus.getMessage());
            }
            tree.standardDeleteFolder(folder, updateFlags, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 5));
            boolean bl = true;
            return bl;
        }
        finally {
            progressMonitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStatus deleteFolder(IFolder folder, TFSRepository repository, boolean isInServer, PendingChange[] pendingChanges, IProgressMonitor progressMonitor) {
        progressMonitor.beginTask(MessageFormat.format(Messages.getString("TFSMoveDeleteHook.DeletingPathFormat"), folder.getFullPath()), 20);
        try {
            DeleteCommand deleteCommand;
            IStatus deleteStatus;
            boolean folderAddUndone = false;
            if (pendingChanges.length > 0) {
                for (int i = 0; i < pendingChanges.length; ++i) {
                    if (!pendingChanges[i].getLocalItem().equals(folder.getLocation().toOSString()) || !pendingChanges[i].getChangeType().contains(ChangeType.ADD)) continue;
                    folderAddUndone = true;
                }
                UndoCommand undoCommand = new UndoCommand(repository, new ItemSpec[]{new ItemSpec(folder.getLocation().toOSString(), RecursionType.FULL)});
                IStatus undoStatus = this.runCommand((Command)undoCommand, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 10));
                if (!undoStatus.isOK()) {
                    IStatus iStatus = undoStatus;
                    return iStatus;
                }
            }
            if (!folderAddUndone && isInServer && !(deleteStatus = this.runCommand((Command)(deleteCommand = new DeleteCommand(repository, new String[]{folder.getLocation().toOSString()}, RecursionType.FULL, LockLevel.UNCHANGED, GetOptions.NO_DISK_UPDATE, PendChangesOptions.NONE)), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 10))).isOK() && deleteStatus.getSeverity() == 4) {
                IStatus iStatus = deleteStatus;
                return iStatus;
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            progressMonitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteProject(IResourceTree tree, IProject project, int updateFlags, IProgressMonitor progressMonitor) {
        this.log.trace((Object)MessageFormat.format("deleteProject: {0}", project.getFullPath()));
        if (this.repositoryProvider.getRepositoryStatus() == ProjectRepositoryStatus.CONNECTING) {
            throw new RuntimeException(Messages.getString("TFSMoveDeleteHook.ConnectionInProgressWaitBeforeDeleting"));
        }
        progressMonitor.beginTask(MessageFormat.format(Messages.getString("TFSMoveDeleteHook.DeletingPathFormat"), project.getName()), 20);
        try {
            DeleteWorkingFolderCommand deleteWfCommand;
            IStatus deleteStatus;
            ResourceRepositoryMap repositoryMap = PluginResourceHelpers.mapResources(new IResource[]{project});
            TFSRepository repository = repositoryMap.getRepository((IResource)project);
            if (repository == null) {
                throw new RuntimeException(MessageFormat.format(Messages.getString("TFSMoveDeleteHook.CannotRemoveProjectWhileDisconnectedFormat"), project.getName()));
            }
            if ((updateFlags & 8) == 8) {
                TFSEclipseClientPlugin.getDefault().getProjectManager().removeProject(project);
                boolean bl = false;
                return bl;
            }
            QueryItemsExtendedCommand queryCommand = new QueryItemsExtendedCommand(repository, project.getLocation().toOSString(), ItemType.ANY, DeletedState.NON_DELETED, RecursionType.FULL, GetItemsOptions.NONE);
            IStatus queryStatus = this.runCommand((Command)queryCommand, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 5));
            if (!queryStatus.isOK()) {
                throw new RuntimeException(queryStatus.getMessage());
            }
            ExtendedItem[][] items = queryCommand.getItems();
            if (items == null || items.length == 0 || items[0] == null || items[0].length == 0) {
                boolean bl = true;
                return bl;
            }
            ClientLocalVersionUpdate[] updates = new ClientLocalVersionUpdate[items[0].length];
            for (int i = 0; i < items[0].length; ++i) {
                updates[i] = new ClientLocalVersionUpdate(items[0][i].getSourceServerItem(), items[0][i].getItemID(), null, items[0][i].getLocalVersion(), items[0][i].getPropertyValues());
            }
            UpdateLocalVersionCommand updateCommand = new UpdateLocalVersionCommand(repository, updates, UpdateLocalVersionQueueOptions.UPDATE_BOTH);
            IStatus updateStatus = this.runCommand((Command)updateCommand, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 10));
            if (!updateStatus.isOK()) {
                throw new RuntimeException(updateStatus.getMessage());
            }
            WorkingFolder workingFolder = repository.getWorkspace().getExactMappingForLocalPath(project.getLocation().toOSString());
            if (workingFolder != null && !(deleteStatus = this.runCommand((Command)(deleteWfCommand = new DeleteWorkingFolderCommand(repository, workingFolder)), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 5))).isOK()) {
                throw new RuntimeException(deleteStatus.getMessage());
            }
            TFSEclipseClientPlugin.getDefault().getProjectManager().removeProject(project);
            tree.standardDeleteProject(project, updateFlags, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 5));
            boolean bl = true;
            return bl;
        }
        finally {
            progressMonitor.done();
        }
    }

    public boolean moveFile(IResourceTree tree, IFile source, IFile target, int updateFlags, IProgressMonitor progressMonitor) {
        this.log.trace((Object)MessageFormat.format("moveFile: {0} to {1}", source.getFullPath(), target.getFullPath()));
        if (this.repositoryProvider.getRepositoryStatus() == ProjectRepositoryStatus.CONNECTING) {
            throw new RuntimeException(Messages.getString("TFSMoveDeleteHook.ConnectionInProgressWaitBeforeMoving"));
        }
        progressMonitor.beginTask(MessageFormat.format(Messages.getString("TFSMoveDeleteHook.MovingSourceToTargetFormat"), source.getFullPath(), target.getFullPath()), 20);
        try {
            MoveResourceInspectionResult moveResult = this.inspectMove(tree, (IResource)source, (IResource)target, updateFlags, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 5));
            if (moveResult.getStatus() == ResourceInspectionStatus.DEFER) {
                boolean bl = false;
                return bl;
            }
            if (moveResult.getOperation() == MoveResourceOperation.DELETE_SOURCE) {
                this.log.info((Object)MessageFormat.format("Rename detected from file {0} to {1} (target not managed by TFS, source will be deleted)", source, target));
                TFSRepository repository = moveResult.getRepository();
                PendingChange[] pendingChanges = moveResult.getSourcePendingChanges();
                IStatus deleteStatus = this.deleteFile(source, repository, pendingChanges, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 10));
                if (!deleteStatus.isOK()) {
                    throw new RuntimeException(deleteStatus.getMessage());
                }
                tree.standardMoveFile(source, target, updateFlags, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 5));
                this.refreshPendingChangesCache(repository);
                boolean bl = true;
                return bl;
            }
            if (moveResult.getOperation() == MoveResourceOperation.MOVE) {
                EditCommand editCommand;
                IStatus editStatus;
                this.log.info((Object)MessageFormat.format("Rename detected from file {0} to {1}", source, target));
                TFSRepository repository = moveResult.getRepository();
                String sourceServerPath = moveResult.getSourceServerPath();
                String targetServerPath = moveResult.getTargetServerPath();
                if (WorkspaceLocation.SERVER.equals((Object)repository.getWorkspace().getLocation()) && !source.isReadOnly() && !this.containsChangeType(moveResult.getSourcePendingChanges(), ChangeType.EDIT) && (editStatus = this.runCommand((Command)(editCommand = new EditCommand(repository, new ItemSpec[]{new ItemSpec(sourceServerPath, RecursionType.NONE)}, LockLevel.UNCHANGED, null, GetOptions.NO_DISK_UPDATE, PendChangesOptions.FORCE_CHECK_OUT_LOCAL_VERSION, false)), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 10))).getSeverity() == 4) {
                    throw new RuntimeException(editStatus.getMessage());
                }
                RenameCommand renameCommand = new RenameCommand(repository, sourceServerPath, targetServerPath, LockLevel.UNCHANGED, GetOptions.NO_DISK_UPDATE, true, PendChangesOptions.NONE);
                IStatus renameStatus = this.runCommand((Command)renameCommand, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 10));
                if (renameStatus.getSeverity() == 4) {
                    throw new RuntimeException(renameStatus.getMessage());
                }
                tree.standardMoveFile(source, target, updateFlags, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 5));
                this.refreshPendingChangesCache(repository);
                boolean bl = true;
                return bl;
            }
            throw new RuntimeException(MessageFormat.format(Messages.getString("TFSMoveDeleteHook.InconsistentStateMovingSourceToTargetFormat"), source.getFullPath(), target.getFullPath()));
        }
        finally {
            progressMonitor.done();
        }
    }

    private boolean containsChangeType(PendingChange[] changes, ChangeType changeType) {
        if (changes == null) {
            return false;
        }
        for (PendingChange change : changes) {
            if (!change.getChangeType().contains(changeType)) continue;
            return true;
        }
        return false;
    }

    public boolean moveFolder(IResourceTree tree, IFolder source, IFolder target, int updateFlags, IProgressMonitor progressMonitor) {
        this.log.trace((Object)MessageFormat.format("moveFolder: {0} to {1}", source.getFullPath(), target.getFullPath()));
        if (this.repositoryProvider.getRepositoryStatus() == ProjectRepositoryStatus.CONNECTING) {
            throw new RuntimeException(Messages.getString("TFSMoveDeleteHook.ConnectionInProgressWaitBeforeMoving"));
        }
        progressMonitor.beginTask(MessageFormat.format(Messages.getString("TFSMoveDeleteHook.MovingSourceToTargetFormat"), source.getFullPath(), target.getFullPath()), 20);
        try {
            MoveResourceInspectionResult moveResult = this.inspectMove(tree, (IResource)source, (IResource)target, updateFlags, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 5));
            if (moveResult.getStatus() == ResourceInspectionStatus.DEFER) {
                boolean bl = false;
                return bl;
            }
            if (moveResult.getOperation() == MoveResourceOperation.DELETE_SOURCE) {
                this.log.info((Object)MessageFormat.format("Rename detected from folder {0} to {1} (target not managed by TFS, source will be deleted)", source, target));
                TFSRepository repository = moveResult.getRepository();
                PendingChange[] pendingChanges = moveResult.getSourcePendingChanges();
                boolean inServer = moveResult.isSourceInServer();
                IStatus deleteStatus = this.deleteFolder(source, repository, inServer, pendingChanges, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 10));
                if (!deleteStatus.isOK()) {
                    throw new RuntimeException(deleteStatus.getMessage());
                }
                tree.standardMoveFolder(source, target, updateFlags, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 5));
                boolean bl = true;
                return bl;
            }
            if (moveResult.getOperation() == MoveResourceOperation.ADD_TARGET) {
                this.log.info((Object)MessageFormat.format("Rename detected from folder {0} to {1} (source not managed by TFS, target will be added)", source, target));
                TFSRepository repository = moveResult.getRepository();
                AddCommand addCommand = new AddCommand(repository, new String[]{target.getLocation().toOSString()}, true, LockLevel.UNCHANGED, GetOptions.NONE, PendChangesOptions.NONE);
                IStatus addStatus = this.runCommand((Command)addCommand, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 10));
                if (!addStatus.isOK()) {
                    throw new RuntimeException(addStatus.getMessage());
                }
                tree.standardMoveFolder(source, target, updateFlags, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 5));
                boolean deleteStatus = true;
                return deleteStatus;
            }
            if (moveResult.getOperation() == MoveResourceOperation.MOVE && !moveResult.isSourceInServer()) {
                this.log.info((Object)MessageFormat.format("Rename detected from folder {0} to {1} (source implicitly added, renaming child pending changes)", source, target));
                TFSRepository repository = moveResult.getRepository();
                PendingChange[] pendingChanges = moveResult.getSourcePendingChanges();
                String sourceFolderPath = moveResult.getSourceServerPath();
                String targetFolderPath = moveResult.getTargetServerPath();
                String[] sourcePaths = new String[pendingChanges.length];
                String[] targetPaths = new String[pendingChanges.length];
                for (int i = 0; i < pendingChanges.length; ++i) {
                    if (!pendingChanges[i].getChangeType().contains(ChangeType.ADD)) {
                        throw new RuntimeException(MessageFormat.format(Messages.getString("TFSMoveDeleteHook.UnexpectedChangeForFileFormat"), pendingChanges[i].getChangeType(), pendingChanges[i].getLocalItem()));
                    }
                    sourcePaths[i] = pendingChanges[i].getServerItem();
                    targetPaths[i] = ServerPath.combine((String)targetFolderPath, (String)ServerPath.makeRelative((String)sourcePaths[i], (String)sourceFolderPath));
                }
                RenameMultipleCommand renameCommand = new RenameMultipleCommand(repository, sourcePaths, targetPaths, LockLevel.UNCHANGED, GetOptions.NO_DISK_UPDATE, true, PendChangesOptions.NONE);
                IStatus renameStatus = this.runCommand((Command)renameCommand, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 10));
                if (!renameStatus.isOK()) {
                    throw new RuntimeException(renameStatus.getMessage());
                }
                tree.standardMoveFolder(source, target, updateFlags, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 5));
                boolean bl = true;
                return bl;
            }
            if (moveResult.getOperation() == MoveResourceOperation.MOVE) {
                this.log.info((Object)MessageFormat.format("Rename detected from folder {0} to {1}", source, target));
                TFSRepository repository = moveResult.getRepository();
                String sourceServerPath = moveResult.getSourceServerPath();
                String targetServerPath = moveResult.getTargetServerPath();
                RenameCommand renameCommand = new RenameCommand(repository, sourceServerPath, targetServerPath, LockLevel.UNCHANGED, GetOptions.NO_DISK_UPDATE, true, PendChangesOptions.NONE);
                IStatus renameStatus = this.runCommand((Command)renameCommand, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 10));
                if (!renameStatus.isOK()) {
                    throw new RuntimeException(renameStatus.getMessage());
                }
                tree.standardMoveFolder(source, target, updateFlags, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 5));
                this.refreshPendingChangesCache(repository);
                boolean bl = true;
                return bl;
            }
            throw new RuntimeException(MessageFormat.format(Messages.getString("TFSMoveDeleteHook.InconsistentStateMovingSourceToTargetFormat"), source.getFullPath(), target.getFullPath()));
        }
        finally {
            progressMonitor.done();
        }
    }

    private void refreshPendingChangesCache(TFSRepository repository) {
        RefreshPendingChangesCommand refreshCommand = new RefreshPendingChangesCommand(repository);
        JobCommandAdapter refreshJob = new JobCommandAdapter((ICommand)refreshCommand);
        refreshJob.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean moveProject(IResourceTree tree, IProject source, IProjectDescription target, int updateFlags, IProgressMonitor progressMonitor) {
        this.log.trace((Object)MessageFormat.format("moveProject: {0}", source.getFullPath()));
        progressMonitor.beginTask(MessageFormat.format(Messages.getString("TFSMoveDeleteHook.MovingProjectFormat"), source.getFullPath()), 10);
        this.log.info((Object)MessageFormat.format("Rename detected from project {0} to {1}", source, target));
        try {
            if (target.getName() != source.getName()) {
                target.setLocation(source.getLocation());
                tree.standardMoveProject(source, target, updateFlags, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 10));
                boolean bl = true;
                return bl;
            }
            tree.failed((IStatus)new Status(4, "com.microsoft.tfs.client.eclipse", 0, MessageFormat.format(Messages.getString("TFSMoveDeleteHook.MovingProjectNotSupportedInProductFormat"), ProductInformation.getCurrent().toString()), null));
            boolean bl = true;
            return bl;
        }
        finally {
            progressMonitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final MoveResourceInspectionResult inspectMove(IResourceTree tree, IResource source, IResource target, int updateFlags, IProgressMonitor progressMonitor) {
        this.log.trace((Object)MessageFormat.format("inspectMove: {0} to {1}", source.getFullPath(), target.getFullPath()));
        progressMonitor.beginTask(MessageFormat.format(Messages.getString("TFSMoveDeleteHook.InspectingMoveFromSourceToTargetFormat"), source.getFullPath(), target.getFullPath()), 15);
        try {
            boolean sourceManaged = TeamUtils.isConfiguredWith(source, "com.microsoft.tfs.client.eclipse.TFSRepositoryProvider");
            boolean targetManaged = TeamUtils.isConfiguredWith(target, "com.microsoft.tfs.client.eclipse.TFSRepositoryProvider");
            if (!sourceManaged && !targetManaged) {
                this.log.warn((Object)MessageFormat.format("inspecting resource move from {0} to {1}: neither managed by Team Foundation Server", source.getFullPath(), target.getFullPath()));
                MoveResourceInspectionResult moveResourceInspectionResult = new MoveResourceInspectionResult(ResourceInspectionStatus.DEFER);
                return moveResourceInspectionResult;
            }
            if (sourceManaged && !targetManaged) {
                ResourceInspectionResult sourceDetails = this.inspectResource(tree, source, true, true, DELETE_DENIED_CHANGE_TYPES, updateFlags, false, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 15));
                if (!sourceDetails.getStatus().equals((Object)ResourceInspectionStatus.CONTINUE)) {
                    MoveResourceInspectionResult moveResourceInspectionResult = new MoveResourceInspectionResult(sourceDetails.getStatus());
                    return moveResourceInspectionResult;
                }
                TFSRepository repository = sourceDetails.getRepository();
                MoveResourceInspectionResult moveResourceInspectionResult = new MoveResourceInspectionResult(repository, sourceDetails.isInServer(), sourceDetails.getPendingChanges(), false, null, MoveResourceOperation.DELETE_SOURCE);
                return moveResourceInspectionResult;
            }
            if (!sourceManaged && targetManaged) {
                ResourceInspectionResult targetDetails = this.inspectResource(tree, target, false, true, ADD_DENIED_CHANGE_TYPES, updateFlags, false, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 15));
                if (!targetDetails.getStatus().equals((Object)ResourceInspectionStatus.CONTINUE)) {
                    MoveResourceInspectionResult repository = new MoveResourceInspectionResult(targetDetails.getStatus());
                    return repository;
                }
                TFSRepository repository = targetDetails.getRepository();
                MoveResourceInspectionResult moveResourceInspectionResult = new MoveResourceInspectionResult(repository, false, null, targetDetails.isInServer(), targetDetails.getPendingChanges(), MoveResourceOperation.ADD_TARGET);
                return moveResourceInspectionResult;
            }
            ResourceInspectionResult sourceDetails = this.inspectResource(tree, source, true, false, MOVE_DENIED_CHANGE_TYPES, updateFlags, false, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 5));
            ResourceInspectionStatus sourceStatus = sourceDetails.getStatus();
            ResourceInspectionResult targetDetails = this.inspectResource(tree, target, false, false, MOVE_DENIED_CHANGE_TYPES, updateFlags, false, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 5));
            ResourceInspectionStatus targetStatus = targetDetails.getStatus();
            if (sourceStatus == ResourceInspectionStatus.DEFER) {
                this.log.debug((Object)MessageFormat.format("Ignoring resource {0} (not in TFS)", source.getLocation().toOSString()));
                MoveResourceInspectionResult moveResourceInspectionResult = new MoveResourceInspectionResult(ResourceInspectionStatus.DEFER);
                return moveResourceInspectionResult;
            }
            if (targetStatus == ResourceInspectionStatus.DEFER) {
                throw new RuntimeException(MessageFormat.format(Messages.getString("TFSMoveDeleteHook.TargetOfRenameIgnoredByTFSButSourceIsNotFormat"), target.getFullPath(), source.getFullPath()));
            }
            if (sourceDetails.isIgnored() && targetDetails.isIgnored()) {
                this.log.debug((Object)MessageFormat.format("Ignoring resource {0} because both source and target ignored", source.getLocation().toOSString()));
                MoveResourceInspectionResult moveResourceInspectionResult = new MoveResourceInspectionResult(ResourceInspectionStatus.DEFER);
                return moveResourceInspectionResult;
            }
            if (!sourceDetails.getRepository().equals((Object)targetDetails.getRepository())) {
                throw new RuntimeException(Messages.getString("TFSMoveDeleteHook.SourceAndTargetAreInDifferentWorkspaces"));
            }
            TFSRepository repository = sourceDetails.getRepository();
            String sourceServerPath = repository.getWorkspace().getMappedServerPath(source.getLocation().toOSString());
            String targetServerPath = repository.getWorkspace().getMappedServerPath(target.getLocation().toOSString());
            if (sourceServerPath == null && targetServerPath == null) {
                this.log.warn((Object)MessageFormat.format("Renaming {0} to {1}, both in cloaked folders, ignoring", source.getFullPath(), target.getFullPath()));
                MoveResourceInspectionResult moveResourceInspectionResult = new MoveResourceInspectionResult(ResourceInspectionStatus.DEFER);
                return moveResourceInspectionResult;
            }
            if (sourceServerPath == null) {
                throw new RuntimeException(MessageFormat.format(Messages.getString("TFSMoveDeleteHook.CannotRenameSourceToTargetBecauseSourceIsCloakedFormat"), source.getFullPath(), target.getFullPath()));
            }
            if (targetServerPath == null) {
                throw new RuntimeException(MessageFormat.format(Messages.getString("TFSMoveDeleteHook.CannotRenameSourceToTargetBecauseTargetIsCloakedFormat"), source.getFullPath(), target.getFullPath()));
            }
            progressMonitor.worked(5);
            MoveResourceInspectionResult moveResourceInspectionResult = new MoveResourceInspectionResult(repository, sourceDetails.isInServer(), sourceDetails.getPendingChanges(), targetDetails.isInServer(), targetDetails.getPendingChanges(), MoveResourceOperation.MOVE, sourceServerPath, targetServerPath);
            return moveResourceInspectionResult;
        }
        finally {
            progressMonitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ResourceInspectionResult inspectResource(IResourceTree tree, final IResource resource, boolean resourceMustExist, boolean deferIgnoredResources, ChangeType deniedChangeTypes, int updateFlags, boolean deletingFolder, IProgressMonitor progressMonitor) {
        progressMonitor.beginTask(MessageFormat.format(Messages.getString("TFSMoveDeleteHook.ExaminingResourceFormat"), resource.getFullPath()), 10);
        try {
            IStatus queryStatus;
            QueryItemsExtendedCommand queryCommand;
            ResourceDataManager resourceDataManager;
            int depth;
            if (resource.getLocation() == null) {
                this.log.info((Object)MessageFormat.format("Cannot move/delete linked resource {0}", resource));
                ResourceInspectionResult resourceInspectionResult = new ResourceInspectionResult(ResourceInspectionStatus.DEFER);
                return resourceInspectionResult;
            }
            if (resourceMustExist && !resource.exists()) {
                this.log.warn((Object)MessageFormat.format("Resource {0} no longer exists in the workspace.", resource.getFullPath()));
            }
            boolean isIgnored = IGNORED_RESOURCES_FILTER.filter(resource).isReject();
            if (deferIgnoredResources && isIgnored) {
                this.log.debug((Object)MessageFormat.format("Ignoring resource {0}", resource));
                ResourceInspectionResult resourceInspectionResult = new ResourceInspectionResult(ResourceInspectionStatus.DEFER);
                return resourceInspectionResult;
            }
            String resourcePath = resource.getLocation().toOSString();
            if (resourceMustExist) {
                File resourceFile = new File(resourcePath);
                if (!resourceFile.exists()) {
                    this.log.warn((Object)MessageFormat.format("Resource {0} no longer exists on disk", resourcePath));
                }
                if (resource instanceof IFile && resourceFile.isDirectory()) {
                    throw new RuntimeException(MessageFormat.format(Messages.getString("TFSMoveDeleteHook.ResourceExistsAsFileInWorkspaceButFolderOnDiskFormat"), resource.getFullPath()));
                }
                if (!(resource instanceof IFile) && resourceFile.isFile()) {
                    throw new RuntimeException(MessageFormat.format(Messages.getString("TFSMoveDeleteHook.ResourceExistsAsFolderInWorkspaceButFileOnDiskFormat"), resource.getFullPath()));
                }
            }
            int n = depth = resource instanceof IFile ? 0 : 2;
            if ((updateFlags & 1) != 1 && !tree.isSynchronized(resource, depth)) {
                throw new RuntimeException(MessageFormat.format(Messages.getString("TFSMoveDeleteHook.ResourceNotInSyncWithLocalFileSystemFormat"), resource.getFullPath()));
            }
            ResourceRepositoryMap repositoryMap = PluginResourceHelpers.mapResources(new IResource[]{resource});
            TFSRepository repository = repositoryMap.getRepository(resource);
            if (repository == null) {
                this.log.info((Object)MessageFormat.format("Repository is offline, delete for {0} must be reconciled when returning online to Team Foundation Server.", resource.getFullPath()));
                ResourceInspectionResult resourceInspectionResult = new ResourceInspectionResult(ResourceInspectionStatus.DEFER);
                return resourceInspectionResult;
            }
            if (!repository.equals((Object)this.repositoryProvider.getRepository())) {
                this.log.warn((Object)MessageFormat.format("Repository for resource {0} mapped to {1} but repository provider returned {2}", resource.getFullPath(), repository, this.repositoryProvider.getRepository()));
            }
            try {
                repository.getWorkspace().getMappedServerPath(resourcePath);
            }
            catch (InputValidationException e) {
                this.log.warn((Object)MessageFormat.format("Ignoring resource {0} because it is not a valid TFS path", resource), (Throwable)e);
                ResourceInspectionResult resourceInspectionResult = new ResourceInspectionResult(ResourceInspectionStatus.DEFER);
                progressMonitor.done();
                return resourceInspectionResult;
            }
            boolean needsQuery = resourceMustExist ? !(resourceDataManager = TFSEclipseClientPlugin.getDefault().getResourceDataManager()).hasCompletedRefresh(resource.getProject()) || resourceDataManager.getResourceData(resource) == null : false;
            if (repository.getWorkspace().getLocation() == WorkspaceLocation.SERVER && resource instanceof IFile) {
                final TFSFileModificationValidator validator = this.repositoryProvider.getTFSFileModificationValidator();
                try {
                    new ExtensionPointAsyncObjectWaiter().waitUntilTrue(new IAsyncObjectWaiter.Predicate(){

                        public boolean isTrue() {
                            return !validator.isCheckingOutFileInBackground((IFile)resource);
                        }
                    });
                }
                catch (InterruptedException e) {
                    throw new VersionControlException(MessageFormat.format(Messages.getString("TFSMoveDeleteHook.InterruptedWaitingForBackgroundCheckoutFormat"), resource.getName()));
                }
            }
            List<PendingChange> pendingChanges = this.getNestedPendingChanges(repository, resourcePath);
            this.log.info((Object)("Nested pending changes count: [" + String.valueOf(pendingChanges.size()) + "]"));
            if (deletingFolder) {
                String serverPath = repository.getWorkspace().getMappedServerPath(resourcePath);
                this.log.info((Object)("Local folder to be deleted: " + resourcePath));
                this.log.info((Object)("Server folder to be deleted: " + serverPath));
                boolean reject = false;
                for (PendingChange change : pendingChanges) {
                    if (!change.getChangeType().contains(ChangeType.RENAME) || this.isSamePendingChange(serverPath, resourcePath, change)) continue;
                    this.log.info((Object)"Child pending change:");
                    this.log.info((Object)("  ChangeType: " + change.getChangeType().toString()));
                    this.log.info((Object)("    ServerItem: " + change.getServerItem()));
                    this.log.info((Object)("    LocalItem: " + (change.getLocalItem() == null ? "null" : change.getLocalItem())));
                    this.log.info((Object)("    SourceLocalItem: " + (change.getSourceLocalItem() == null ? "null" : change.getSourceLocalItem())));
                    this.log.info((Object)("    SourceServerItem: " + (change.getSourceServerItem() == null ? "null" : change.getSourceServerItem())));
                    this.log.info((Object)("    Date: " + new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS z").format(change.getWebServiceObject().getDate().getTime())));
                    reject = true;
                }
                if (reject) {
                    progressMonitor.worked(1);
                    ResourceInspectionResult i$ = new ResourceInspectionResult(ResourceInspectionStatus.WARN, repository, true, pendingChanges.toArray(new PendingChange[pendingChanges.size()]), isIgnored, Messages.getString("TFSMoveDeleteHook.CannotDeleteFolder"));
                    return i$;
                }
            }
            boolean reject = false;
            for (PendingChange change : pendingChanges) {
                if (!change.getChangeType().containsAny(deniedChangeTypes)) continue;
                this.log.info((Object)("  ChangeType: " + change.getChangeType().toString()));
                this.log.info((Object)("    ServerItem: " + change.getServerItem()));
                this.log.info((Object)("    LocalItem: " + (change.getLocalItem() == null ? "null" : change.getLocalItem())));
                this.log.info((Object)("    SourceLocalItem: " + (change.getSourceLocalItem() == null ? "null" : change.getSourceLocalItem())));
                this.log.info((Object)("    SourceServerItem: " + (change.getSourceServerItem() == null ? "null" : change.getSourceServerItem())));
                this.log.info((Object)("    Date: " + new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS z").format(change.getWebServiceObject().getDate().getTime())));
                reject = true;
            }
            if (reject) {
                this.log.warn((Object)MessageFormat.format(Messages.getString("TFSMoveDeleteHook.ResourceHasPendingChangePleaseUndoBeforeContinuingFormat"), resource.getLocation().toOSString()));
                progressMonitor.worked(1);
                throw new RuntimeException(MessageFormat.format(Messages.getString("TFSMoveDeleteHook.ResourceHasPendingChangePleaseUndoBeforeContinuingFormat"), resource.getLocation().toOSString()));
            }
            boolean inServer = true;
            if (needsQuery && WorkspaceLocation.LOCAL.equals((Object)repository.getWorkspace().getLocation())) {
                queryCommand = new QueryItemsExtendedCommand(repository, new ItemSpec[]{new ItemSpec(resourcePath, RecursionType.NONE)}, DeletedState.NON_DELETED, ItemType.ANY, GetItemsOptions.LOCAL_ONLY);
                queryStatus = this.runCommand((Command)queryCommand, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 9));
                if (!queryStatus.isOK()) {
                    throw new RuntimeException(queryStatus.getMessage());
                }
                ExtendedItem[][] items = queryCommand.getItems();
                if (items == null || items.length == 0 || items[0] == null || items[0].length == 0) {
                    ResourceInspectionResult resourceInspectionResult = new ResourceInspectionResult(ResourceInspectionStatus.DEFER);
                    return resourceInspectionResult;
                }
            } else if (needsQuery) {
                queryCommand = new QueryItemsCommand(repository, new ItemSpec[]{new ItemSpec(resourcePath, RecursionType.NONE)}, (VersionSpec)new WorkspaceVersionSpec(repository.getWorkspace()), DeletedState.NON_DELETED, ItemType.ANY, GetItemsOptions.NONE);
                queryStatus = this.runCommand((Command)queryCommand, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 9));
                if (!queryStatus.isOK()) {
                    throw new RuntimeException(queryStatus.getMessage());
                }
                ItemSet[] itemSets = queryCommand.getItemSets();
                if (itemSets == null || itemSets.length == 0 || itemSets[0].getItems() == null || itemSets[0].getItems().length == 0) {
                    if (pendingChanges.size() == 0) {
                        ResourceInspectionResult resourceInspectionResult = new ResourceInspectionResult(ResourceInspectionStatus.DEFER);
                        return resourceInspectionResult;
                    }
                    inServer = false;
                }
            }
            progressMonitor.worked(1);
            ResourceInspectionResult resourceInspectionResult = new ResourceInspectionResult(repository, inServer, pendingChanges.toArray(new PendingChange[pendingChanges.size()]), isIgnored);
            return resourceInspectionResult;
        }
        finally {
            progressMonitor.done();
        }
    }

    private List<PendingChange> getNestedPendingChanges(TFSRepository repository, String resourcePath) {
        PendingChange[] allPendingChanges = repository.getPendingChangeCache().getPendingChanges();
        String serverPath = repository.getWorkspace().getMappedServerPath(resourcePath);
        ArrayList<PendingChange> nestedPendingChanges = new ArrayList<PendingChange>();
        for (int i = 0; i < allPendingChanges.length; ++i) {
            PendingChange change = allPendingChanges[i];
            if (change.getChangeType().containsAny(ChangeType.RENAME) && (change.getSourceLocalItem() == null || change.getSourceServerItem() == null)) {
                change.updateMissingProperties(repository.getVersionControlClient());
            }
            if (!this.isNestedPendingChange(serverPath, resourcePath, change)) continue;
            nestedPendingChanges.add(change);
        }
        return nestedPendingChanges;
    }

    private boolean isNestedPendingChange(String serverPath, String localPath, PendingChange change) {
        if (change.getLocalItem() != null && LocalPath.isChild((String)localPath, (String)change.getLocalItem())) {
            return true;
        }
        if (change.getServerItem() != null && ServerPath.isChild((String)serverPath, (String)change.getServerItem())) {
            return true;
        }
        if (change.getSourceLocalItem() != null && LocalPath.isChild((String)localPath, (String)change.getSourceLocalItem())) {
            return true;
        }
        return change.getSourceServerItem() != null && ServerPath.isChild((String)serverPath, (String)change.getSourceServerItem());
    }

    private boolean isSamePendingChange(String serverPath, String localPath, PendingChange change) {
        if (change.getLocalItem() != null && LocalPath.equals((String)localPath, (String)change.getLocalItem())) {
            return true;
        }
        if (change.getServerItem() != null && ServerPath.equals((String)serverPath, (String)change.getServerItem())) {
            return true;
        }
        if (change.getSourceLocalItem() != null && LocalPath.equals((String)localPath, (String)change.getSourceLocalItem())) {
            return true;
        }
        return change.getSourceServerItem() != null && ServerPath.equals((String)serverPath, (String)change.getSourceServerItem());
    }

    private final IStatus runCommand(Command command, IProgressMonitor progressMonitor) {
        CommandExecutor commandExecutor = new CommandExecutor(progressMonitor);
        return commandExecutor.execute((ICommand)command);
    }

    private static final class MoveResourceOperation
    extends TypesafeEnum {
        public static final MoveResourceOperation NONE = new MoveResourceOperation(0);
        public static final MoveResourceOperation MOVE = new MoveResourceOperation(1);
        public static final MoveResourceOperation DELETE_SOURCE = new MoveResourceOperation(2);
        public static final MoveResourceOperation ADD_TARGET = new MoveResourceOperation(3);

        private MoveResourceOperation(int value) {
            super(value);
        }
    }

    private static final class ResourceInspectionStatus
    extends TypesafeEnum {
        public static final ResourceInspectionStatus DEFER = new ResourceInspectionStatus(0);
        public static final ResourceInspectionStatus CONTINUE = new ResourceInspectionStatus(2);
        public static final ResourceInspectionStatus WARN = new ResourceInspectionStatus(3);

        private ResourceInspectionStatus(int value) {
            super(value);
        }
    }

    private static final class MoveResourceInspectionResult {
        private final ResourceInspectionStatus status;
        private final TFSRepository repository;
        private final MoveResourceOperation operation;
        private final boolean sourceInServer;
        private final String sourceServerPath;
        private final PendingChange[] sourcePendingChanges;
        private final boolean targetInServer;
        private final String targetServerPath;
        private final PendingChange[] targetPendingChanges;

        public MoveResourceInspectionResult(ResourceInspectionStatus status) {
            Check.notNull((Object)((Object)status), (String)"status");
            this.status = status;
            this.repository = null;
            this.operation = MoveResourceOperation.NONE;
            this.sourceInServer = false;
            this.sourceServerPath = null;
            this.sourcePendingChanges = new PendingChange[0];
            this.targetInServer = false;
            this.targetServerPath = null;
            this.targetPendingChanges = new PendingChange[0];
        }

        public MoveResourceInspectionResult(TFSRepository repository, boolean sourceInServer, PendingChange[] sourcePendingChanges, boolean targetInServer, PendingChange[] targetPendingChanges, MoveResourceOperation operation) {
            Check.notNull((Object)repository, (String)"repository");
            Check.notNull((Object)((Object)operation), (String)"operation");
            Check.isTrue((operation.equals((Object)MoveResourceOperation.DELETE_SOURCE) || operation.equals((Object)MoveResourceOperation.ADD_TARGET) ? 1 : 0) != 0, (String)"operation == DELETE_SOURCE || operation == ADD_TARGET");
            this.status = ResourceInspectionStatus.CONTINUE;
            this.repository = repository;
            this.operation = operation;
            this.sourceInServer = sourceInServer;
            this.sourceServerPath = null;
            this.sourcePendingChanges = sourcePendingChanges;
            this.targetInServer = targetInServer;
            this.targetServerPath = null;
            this.targetPendingChanges = targetPendingChanges;
        }

        public MoveResourceInspectionResult(TFSRepository repository, boolean sourceInServer, PendingChange[] sourcePendingChanges, boolean targetInServer, PendingChange[] targetPendingChanges, MoveResourceOperation operation, String sourceServerPath, String targetServerPath) {
            Check.notNull((Object)repository, (String)"repository");
            Check.notNull((Object)((Object)operation), (String)"operation");
            Check.isTrue((boolean)operation.equals((Object)MoveResourceOperation.MOVE), (String)"operation == MOVE");
            Check.notNull((Object)sourceServerPath, (String)"sourceServerPath");
            Check.notNull((Object)targetServerPath, (String)"targetServerPath");
            this.status = ResourceInspectionStatus.CONTINUE;
            this.repository = repository;
            this.operation = operation;
            this.sourceInServer = sourceInServer;
            this.sourceServerPath = sourceServerPath;
            this.sourcePendingChanges = sourcePendingChanges;
            this.targetInServer = targetInServer;
            this.targetServerPath = targetServerPath;
            this.targetPendingChanges = targetPendingChanges;
        }

        public final ResourceInspectionStatus getStatus() {
            return this.status;
        }

        public final TFSRepository getRepository() {
            return this.repository;
        }

        public MoveResourceOperation getOperation() {
            return this.operation;
        }

        public boolean isSourceInServer() {
            return this.sourceInServer;
        }

        public String getSourceServerPath() {
            return this.sourceServerPath;
        }

        public PendingChange[] getSourcePendingChanges() {
            return this.sourcePendingChanges;
        }

        public boolean isTargetInServer() {
            return this.targetInServer;
        }

        public String getTargetServerPath() {
            return this.targetServerPath;
        }

        public PendingChange[] getTargetPendingChanges() {
            return this.targetPendingChanges;
        }
    }

    private static class ResourceInspectionResult {
        private final ResourceInspectionStatus status;
        private final TFSRepository repository;
        private final boolean inServer;
        private final PendingChange[] pendingChanges;
        private final boolean ignored;
        private final String message;

        public ResourceInspectionResult(ResourceInspectionStatus status) {
            Check.notNull((Object)((Object)status), (String)"status");
            Check.isTrue((status.equals((Object)ResourceInspectionStatus.DEFER) || status.equals((Object)ResourceInspectionStatus.WARN) ? 1 : 0) != 0, (String)"status == DEFER || status == WARN");
            this.status = status;
            this.repository = null;
            this.inServer = false;
            this.pendingChanges = null;
            this.ignored = false;
            this.message = null;
        }

        public ResourceInspectionResult(TFSRepository repository, boolean inServer, PendingChange[] pendingChanges, boolean ignored) {
            this(ResourceInspectionStatus.CONTINUE, repository, inServer, pendingChanges, ignored, null);
        }

        public ResourceInspectionResult(ResourceInspectionStatus status, TFSRepository repository, boolean inServer, PendingChange[] pendingChanges, boolean ignored, String message) {
            Check.notNull((Object)repository, (String)"repository");
            this.status = status;
            this.repository = repository;
            this.inServer = inServer;
            this.pendingChanges = pendingChanges;
            this.ignored = ignored;
            this.message = message;
        }

        public final ResourceInspectionStatus getStatus() {
            return this.status;
        }

        public final TFSRepository getRepository() {
            return this.repository;
        }

        public final boolean isInServer() {
            return this.inServer;
        }

        public final PendingChange[] getPendingChanges() {
            return this.pendingChanges;
        }

        public boolean isIgnored() {
            return this.ignored;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

