/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.client.eclipse;

import com.microsoft.tfs.client.common.repository.TFSRepository;
import com.microsoft.tfs.client.eclipse.Messages;
import com.microsoft.tfs.client.eclipse.TFSEclipseClientPlugin;
import com.microsoft.tfs.client.eclipse.TFSMoveDeleteHook;
import com.microsoft.tfs.client.eclipse.filemodification.TFSFileModificationValidator;
import com.microsoft.tfs.client.eclipse.filemodification.TFSFileModificationValidator2;
import com.microsoft.tfs.client.eclipse.filemodification.TFSFileModificationValidatorLegacy;
import com.microsoft.tfs.client.eclipse.project.ProjectRepositoryStatus;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IFileModificationValidator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.team.FileModificationValidator;
import org.eclipse.core.resources.team.IMoveDeleteHook;
import org.eclipse.core.resources.team.ResourceRuleFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.team.core.RepositoryProvider;

public class TFSRepositoryProvider
extends RepositoryProvider {
    public static final String PROVIDER_ID = "com.microsoft.tfs.client.eclipse.TFSRepositoryProvider";
    private static final Log log = LogFactory.getLog(TFSRepositoryProvider.class);
    private final TFSMoveDeleteHook moveDeleteHook = new TFSMoveDeleteHook(this);
    private final TFSFileModificationValidator modificationValidator = new TFSFileModificationValidator(this);
    private Object modificationValidator2;
    private IFileModificationValidator modificationValidatorLegacy;
    private final Object modificationValidatorLock = new Object();

    public String getID() {
        return PROVIDER_ID;
    }

    public void configureProject() throws CoreException {
        IProject project = this.getProject();
        log.debug((Object)MessageFormat.format("Configured as repository provider for project {0}", project.getName()));
    }

    public void deconfigure() throws CoreException {
        IProject project = this.getProject();
        log.debug((Object)MessageFormat.format("Deconfigured as repository provided for project {0}", project.getName()));
    }

    public void setProject(final IProject project) {
        log.debug((Object)MessageFormat.format("Opening repository for project {0}", project.getName()));
        Job connectJob = new Job(MessageFormat.format(Messages.getString("TFSRepositoryProvider.ConnectingProjectFormat"), project.getName())){

            protected IStatus run(IProgressMonitor monitor) {
                TFSEclipseClientPlugin.getDefault().getProjectManager().connectIfNecessary(project);
                return Status.OK_STATUS;
            }
        };
        connectJob.setSystem(true);
        connectJob.schedule();
        super.setProject(project);
    }

    public TFSRepository getRepository() {
        IProject project = this.getProject();
        if (project == null) {
            return null;
        }
        return TFSEclipseClientPlugin.getDefault().getProjectManager().getRepository(project);
    }

    public ProjectRepositoryStatus getRepositoryStatus() {
        IProject project = this.getProject();
        if (project == null) {
            return null;
        }
        return TFSEclipseClientPlugin.getDefault().getProjectManager().getProjectStatus(project);
    }

    public boolean canHandleLinkedResources() {
        return this.canHandleLinkedResourceURI();
    }

    public boolean canHandleLinkedResourceURI() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileModificationValidator getFileModificationValidator2() {
        Object object = this.modificationValidatorLock;
        synchronized (object) {
            if (this.modificationValidator2 == null) {
                this.modificationValidator2 = new TFSFileModificationValidator2(this.modificationValidator);
            }
            return (FileModificationValidator)this.modificationValidator2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFileModificationValidator getFileModificationValidator() {
        Object object = this.modificationValidatorLock;
        synchronized (object) {
            if (this.modificationValidatorLegacy == null) {
                this.modificationValidatorLegacy = new TFSFileModificationValidatorLegacy(this.modificationValidator);
            }
            return this.modificationValidatorLegacy;
        }
    }

    public TFSFileModificationValidator getTFSFileModificationValidator() {
        return this.modificationValidator;
    }

    public IMoveDeleteHook getMoveDeleteHook() {
        return this.moveDeleteHook;
    }

    public IResourceRuleFactory getRuleFactory() {
        return new TFSRepositoryProviderRuleFactory();
    }

    static class TFSRepositoryProviderRuleFactory
    extends ResourceRuleFactory {
    }
}

