/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.client.eclipse;

import com.microsoft.tfs.client.eclipse.TFSEclipseClientPlugin;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.ProjectSetCapability;
import org.eclipse.team.core.ProjectSetSerializationContext;
import org.eclipse.team.core.RepositoryProviderType;
import org.eclipse.team.core.TeamException;

public class TFSRepositoryProviderType
extends RepositoryProviderType {
    public ProjectSetCapability getProjectSetCapability() {
        return new TFSProjectSetCapability();
    }

    public class TFSProjectSetCapability
    extends ProjectSetCapability {
        private final String SEPARATOR = ";";

        public String[] asReference(IProject[] providerProjects, ProjectSetSerializationContext context, IProgressMonitor monitor) throws TeamException {
            String[] references = new String[providerProjects.length];
            for (int i = 0; i < providerProjects.length; ++i) {
                IProject project = providerProjects[i];
                Workspace repositoryWorkspace = TFSEclipseClientPlugin.getDefault().getRepositoryManager().getDefaultRepository().getWorkspace();
                String serverPath = repositoryWorkspace.getMappedServerPath(project.getLocation().toOSString());
                String serverUrl = repositoryWorkspace.getClient().getConnection().getBaseURI().toString();
                references[i] = serverUrl + ";" + serverPath;
            }
            return references;
        }
    }
}

