/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.client.eclipse.commands.eclipse;

import com.microsoft.tfs.client.common.commands.TFSCommand;
import com.microsoft.tfs.client.common.commands.vc.AddCommand;
import com.microsoft.tfs.client.common.commands.vc.UndoCommand;
import com.microsoft.tfs.client.common.framework.command.ICommand;
import com.microsoft.tfs.client.common.framework.command.MultiCommandHelper;
import com.microsoft.tfs.client.common.framework.command.UndoableCommand;
import com.microsoft.tfs.client.common.framework.resources.command.ResourceChangingCommand;
import com.microsoft.tfs.client.common.repository.TFSRepository;
import com.microsoft.tfs.client.eclipse.Messages;
import com.microsoft.tfs.client.eclipse.commands.eclipse.EnumerateProjectFilesCommand;
import com.microsoft.tfs.core.clients.versioncontrol.GetOptions;
import com.microsoft.tfs.core.clients.versioncontrol.PendChangesOptions;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.LockLevel;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RecursionType;
import com.microsoft.tfs.core.clients.versioncontrol.specs.ItemSpec;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.LocaleUtil;
import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public final class AddProjectCommand
extends TFSCommand
implements UndoableCommand {
    private final TFSRepository repository;
    private final IProject project;
    private String[] addPaths;

    public AddProjectCommand(TFSRepository repository, IProject project) {
        this.repository = repository;
        this.project = project;
    }

    public String getName() {
        return Messages.getString("AddProjectCommand.CommandTextFormat");
    }

    public String getErrorDescription() {
        return Messages.getString("AddProjectCommand.ErrorTextFormat");
    }

    public String getLoggingDescription() {
        return Messages.getString("AddProjectCommand.CommandTextFormat", LocaleUtil.ROOT);
    }

    protected IStatus doRun(IProgressMonitor progressMonitor) throws Exception {
        MultiCommandHelper helper = new MultiCommandHelper(progressMonitor);
        EnumerateProjectFilesCommand enumerateProjectFilesCommand = new EnumerateProjectFilesCommand(this.project);
        IStatus status = helper.runSubCommand((ICommand)enumerateProjectFilesCommand);
        if (!status.isOK()) {
            return status;
        }
        this.addPaths = enumerateProjectFilesCommand.getPaths();
        if (this.addPaths.length == 0) {
            return new Status(4, "com.microsoft.tfs.client.eclipse", 0, MessageFormat.format(Messages.getString("AddProjectCommand.NoFilesRemainedErrorFormat"), this.project.getName(), ".tpignore"), null);
        }
        return helper.runSubCommand((ICommand)new AddCommand(this.repository, this.addPaths, false, LockLevel.UNCHANGED, GetOptions.NONE, PendChangesOptions.NONE));
    }

    public IStatus rollback(IProgressMonitor progressMonitor) throws Exception {
        Check.notNull((Object)this.addPaths, (String)"addPaths");
        if (this.addPaths.length == 0) {
            return Status.OK_STATUS;
        }
        ItemSpec[] itemSpecs = new ItemSpec[this.addPaths.length];
        for (int i = 0; i < itemSpecs.length; ++i) {
            itemSpecs[i] = new ItemSpec(this.addPaths[i], RecursionType.NONE);
        }
        return new ResourceChangingCommand((ICommand)new UndoCommand(this.repository, itemSpecs, GetOptions.NONE)).run(progressMonitor);
    }
}

