/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.client.eclipse.commands.eclipse;

import com.microsoft.tfs.client.common.framework.command.Command;
import com.microsoft.tfs.client.eclipse.Messages;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.LocaleUtil;
import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public class CloseProjectsCommand
extends Command {
    private final IProject[] projects;

    public CloseProjectsCommand(IProject[] projects) {
        Check.notNull((Object)projects, (String)"projects");
        this.projects = projects;
    }

    public String getName() {
        if (this.projects.length == 1) {
            return MessageFormat.format(Messages.getString("CloseProjectsCommand.ClosingProjectFormat"), this.projects[0].getName());
        }
        return MessageFormat.format(Messages.getString("CloseProjectsCommand.ClosingMultipleProjectsFormat"), this.projects.length);
    }

    public String getErrorDescription() {
        return Messages.getString("CloseProjectsCommand.ErrorDescription");
    }

    public String getLoggingDescription() {
        if (this.projects.length == 1) {
            return MessageFormat.format(Messages.getString("CloseProjectsCommand.ClosingProjectFormat", LocaleUtil.ROOT), this.projects[0].getName());
        }
        return MessageFormat.format(Messages.getString("CloseProjectsCommand.ClosingMultipleProjectsFormat", LocaleUtil.ROOT), this.projects.length);
    }

    protected IStatus doRun(IProgressMonitor progressMonitor) throws Exception {
        progressMonitor.beginTask(this.getName(), this.projects.length);
        for (int i = 0; i < this.projects.length; ++i) {
            SubProgressMonitor projectMonitor = new SubProgressMonitor(progressMonitor, 1);
            projectMonitor.setTaskName(MessageFormat.format(Messages.getString("CloseProjectsCommand.ClosingProjectFormat"), this.projects[i].getName()));
            try {
                this.projects[i].close((IProgressMonitor)projectMonitor);
            }
            catch (OperationCanceledException e) {
                return Status.CANCEL_STATUS;
            }
            if (!progressMonitor.isCanceled()) continue;
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }
}

