/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.client.eclipse.commands.eclipse;

import com.microsoft.tfs.client.common.commands.TFSCommand;
import com.microsoft.tfs.client.common.framework.command.UndoableCommand;
import com.microsoft.tfs.client.common.repository.TFSRepository;
import com.microsoft.tfs.client.eclipse.Messages;
import com.microsoft.tfs.client.eclipse.TFSEclipseClientPlugin;
import com.microsoft.tfs.client.eclipse.commands.eclipse.DisconnectProjectCommand;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.LocaleUtil;
import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.team.core.RepositoryProvider;

public final class ConnectProjectCommand
extends TFSCommand
implements UndoableCommand {
    private final IProject project;
    private final TFSRepository repository;

    public ConnectProjectCommand(IProject project, TFSRepository repository) {
        Check.notNull((Object)project, (String)"project");
        Check.notNull((Object)repository, (String)"repository");
        this.project = project;
        this.repository = repository;
    }

    public String getName() {
        String messageFormat = Messages.getString("ConnectProjectCommand.CommandTextFormat");
        return MessageFormat.format(messageFormat, this.project.getName());
    }

    public String getErrorDescription() {
        return MessageFormat.format(Messages.getString("ConnectProjectCommand.ErrorTextFormat"), this.project.getName());
    }

    public String getLoggingDescription() {
        String messageFormat = Messages.getString("ConnectProjectCommand.CommandTextFormat", LocaleUtil.ROOT);
        return MessageFormat.format(messageFormat, this.project.getName());
    }

    protected IStatus doRun(IProgressMonitor progressMonitor) throws Exception {
        TFSEclipseClientPlugin.getDefault().getProjectManager().addProject(this.project, this.repository);
        RepositoryProvider.map((IProject)this.project, (String)"com.microsoft.tfs.client.eclipse.TFSRepositoryProvider");
        return Status.OK_STATUS;
    }

    public IStatus rollback(IProgressMonitor progressMonitor) throws Exception {
        return new DisconnectProjectCommand(this.project).run(progressMonitor);
    }
}

