/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.client.eclipse.commands.eclipse;

import com.microsoft.tfs.client.common.framework.command.Command;
import com.microsoft.tfs.client.eclipse.Messages;
import com.microsoft.tfs.client.eclipse.TFSEclipseClientPlugin;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.LocaleUtil;
import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.team.core.RepositoryProvider;

public final class DisconnectProjectCommand
extends Command {
    private final IProject project;

    public DisconnectProjectCommand(IProject project) {
        Check.notNull((Object)project, (String)"project");
        this.project = project;
    }

    public String getName() {
        return MessageFormat.format(Messages.getString("DisconnectProjectCommand.CommandTextFormat"), this.project.getName());
    }

    public String getErrorDescription() {
        return MessageFormat.format(Messages.getString("DisconnectProjectCommand.ErrorTextFormat"), this.project.getName());
    }

    public String getLoggingDescription() {
        return MessageFormat.format(Messages.getString("DisconnectProjectCommand.CommandTextFormat", LocaleUtil.ROOT), this.project.getName());
    }

    protected IStatus doRun(IProgressMonitor progressMonitor) throws Exception {
        RepositoryProvider.unmap((IProject)this.project);
        TFSEclipseClientPlugin.getDefault().getProjectManager().removeProject(this.project);
        return Status.OK_STATUS;
    }
}

