/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.client.eclipse.commands.eclipse;

import com.microsoft.tfs.client.common.commands.TFSCommand;
import com.microsoft.tfs.client.common.framework.resources.LocationUnavailablePolicy;
import com.microsoft.tfs.client.common.framework.resources.Resources;
import com.microsoft.tfs.client.common.framework.resources.filter.CompositeResourceFilter;
import com.microsoft.tfs.client.common.framework.resources.filter.FilteredResourceCollector;
import com.microsoft.tfs.client.common.framework.resources.filter.ResourceFilter;
import com.microsoft.tfs.client.common.framework.resources.filter.ResourceFilterResult;
import com.microsoft.tfs.client.eclipse.Messages;
import com.microsoft.tfs.client.eclipse.resource.PluginResourceFilters;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.LocaleUtil;
import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class EnumerateProjectFilesCommand
extends TFSCommand {
    private final IProject project;
    private String[] paths;
    private boolean includeProject = true;
    private boolean includeFolders = true;

    public EnumerateProjectFilesCommand(IProject project) {
        Check.notNull((Object)project, (String)"project");
        this.project = project;
    }

    public String getName() {
        return MessageFormat.format(Messages.getString("EnumerateProjectFilesCommand.CommandTextFormat"), this.project.getName());
    }

    public String getErrorDescription() {
        return MessageFormat.format(Messages.getString("EnumerateProjectFilesCommand.ErrorTextFormat"), this.project.getName());
    }

    public String getLoggingDescription() {
        return MessageFormat.format(Messages.getString("EnumerateProjectFilesCommand.CommandTextFormat", LocaleUtil.ROOT), this.project.getName());
    }

    public void setIncludeProject(boolean includeProject) {
        this.includeProject = includeProject;
    }

    public void setIncludeFolders(boolean includeFolders) {
        this.includeFolders = includeFolders;
    }

    protected IStatus doRun(IProgressMonitor progressMonitor) throws Exception {
        progressMonitor.beginTask(MessageFormat.format(Messages.getString("EnumerateProjectFilesCommand.EnumeratingFilesInProjectFormat"), this.project.getName()), -1);
        FilteredResourceCollector collector = new FilteredResourceCollector(this.getProjectFilesEnumerationFilter(), 1, progressMonitor);
        this.project.accept((IResourceVisitor)collector);
        this.paths = Resources.getLocations((IResource[])collector.getResources(), (LocationUnavailablePolicy)LocationUnavailablePolicy.IGNORE_RESOURCE);
        return Status.OK_STATUS;
    }

    private ResourceFilter getProjectFilesEnumerationFilter() {
        CompositeResourceFilter.Builder builder = new CompositeResourceFilter.Builder(CompositeResourceFilter.CompositeResourceFilterType.ALL_MUST_ACCEPT);
        builder.addFilter(PluginResourceFilters.STANDARD_FILTER);
        builder.addFilter((ResourceFilter)new EnumerateProjectFilesFilter());
        return builder.build();
    }

    public String[] getPaths() {
        return this.paths;
    }

    private class EnumerateProjectFilesFilter
    extends ResourceFilter {
        private EnumerateProjectFilesFilter() {
        }

        public ResourceFilterResult filter(IResource resource, int flags) {
            int resultFlags = resource.getType() == 1 ? 1 : (resource.getType() == 2 ? (EnumerateProjectFilesCommand.this.includeFolders ? 1 : 2) : (resource.getType() == 4 ? (EnumerateProjectFilesCommand.this.includeProject ? 1 : 2) : 2));
            return ResourceFilterResult.getInstance((int)resultFlags);
        }
    }
}

