/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.client.eclipse.commands.eclipse;

import com.microsoft.tfs.client.common.framework.command.Command;
import com.microsoft.tfs.client.eclipse.Messages;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.LocaleUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public class RefreshResourcesCommand
extends Command {
    private final IResource[] resources;

    public RefreshResourcesCommand(IResource[] resources) {
        Check.notNull((Object)resources, (String)"resources");
        this.resources = resources;
    }

    public String getName() {
        if (this.resources.length == 1) {
            return MessageFormat.format(Messages.getString("RefreshResourcesCommand.RefreshingSingleResourceFormat"), this.resources[0].getName());
        }
        return Messages.getString("RefreshResourcesCommand.RefreshingMultipleResources");
    }

    public String getErrorDescription() {
        if (this.resources.length == 1) {
            return Messages.getString("RefreshResourcesCommand.ErrorRefreshingMultipleResources");
        }
        return Messages.getString("RefreshResourcesCommand.ErrorRefreshingSingleResource");
    }

    public String getLoggingDescription() {
        if (this.resources.length == 1) {
            return MessageFormat.format(Messages.getString("RefreshResourcesCommand.RefreshingSingleResourceFormat", LocaleUtil.ROOT), this.resources[0].getName());
        }
        return Messages.getString("RefreshResourcesCommand.RefreshingMultipleResources", LocaleUtil.ROOT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus doRun(IProgressMonitor progressMonitor) throws Exception {
        progressMonitor.beginTask(this.getName(), this.resources.length);
        ArrayList<Status> errors = new ArrayList<Status>();
        try {
            for (int i = 0; i < this.resources.length; ++i) {
                IResource resource = this.resources[i];
                int depth = resource.getType() == 1 ? 0 : 2;
                try {
                    resource.refreshLocal(depth, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                    continue;
                }
                catch (Exception e) {
                    errors.add(new Status(4, "com.microsoft.tfs.client.eclipse", 0, e.getLocalizedMessage(), (Throwable)e));
                }
            }
        }
        finally {
            progressMonitor.done();
        }
        if (errors.size() == 0) {
            return Status.OK_STATUS;
        }
        return new MultiStatus("com.microsoft.tfs.client.eclipse", 0, errors.toArray(new IStatus[errors.size()]), this.getErrorDescription(), null);
    }
}

