/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.client.eclipse.commands.eclipse;

import com.microsoft.tfs.client.common.commands.vc.SetWorkingFolderCommand;
import com.microsoft.tfs.client.common.framework.command.Command;
import com.microsoft.tfs.client.common.framework.command.CommandList;
import com.microsoft.tfs.client.common.framework.command.ICommand;
import com.microsoft.tfs.client.common.repository.TFSRepository;
import com.microsoft.tfs.client.eclipse.Messages;
import com.microsoft.tfs.client.eclipse.commands.eclipse.AddProjectCommand;
import com.microsoft.tfs.client.eclipse.commands.eclipse.ConnectProjectCommand;
import com.microsoft.tfs.client.eclipse.commands.eclipse.share.ShareProjectAction;
import com.microsoft.tfs.client.eclipse.commands.eclipse.share.ShareProjectConfiguration;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.LocaleUtil;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

public final class ShareProjectsCommand
extends Command {
    private final TFSRepository repository;
    private final ShareProjectConfiguration[] configuration;

    public ShareProjectsCommand(TFSRepository repository, ShareProjectConfiguration[] configuration) {
        Check.notNull((Object)repository, (String)"repository");
        Check.notNullOrEmpty((Object[])configuration, (String)"configuration");
        this.repository = repository;
        this.configuration = configuration;
    }

    public String getName() {
        if (this.configuration.length == 1) {
            return Messages.getString("ShareProjectsCommand.CommandTextSingular");
        }
        return Messages.getString("ShareProjectsCommand.CommandTextPlural");
    }

    public String getErrorDescription() {
        if (this.configuration.length == 1) {
            return Messages.getString("ShareProjectsCommand.ErrorTextSingular");
        }
        return Messages.getString("ShareProjectsCommand.ErrorTextPlural");
    }

    public String getLoggingDescription() {
        if (this.configuration.length == 1) {
            return Messages.getString("ShareProjectsCommand.CommandTextSingular", LocaleUtil.ROOT);
        }
        return Messages.getString("ShareProjectsCommand.CommandTextPlural", LocaleUtil.ROOT);
    }

    protected IStatus doRun(IProgressMonitor progressMonitor) throws Exception {
        int i;
        CommandList commands = new CommandList(this.getName(), this.getErrorDescription());
        commands.setRollback(true);
        for (i = 0; i < this.configuration.length; ++i) {
            String serverPath = this.configuration[i].getServerPath();
            String localPath = this.configuration[i].getProject().getLocation().toOSString();
            if (this.configuration[i].getAction() != ShareProjectAction.MAP_AND_UPLOAD) continue;
            commands.addCommand((ICommand)new SetWorkingFolderCommand(this.repository, serverPath, localPath));
        }
        for (i = 0; i < this.configuration.length; ++i) {
            if (this.configuration[i].getAction() != ShareProjectAction.MAP_AND_UPLOAD && this.configuration[0].getAction() != ShareProjectAction.UPLOAD) continue;
            commands.addCommand((ICommand)new AddProjectCommand(this.repository, this.configuration[i].getProject()));
        }
        for (i = 0; i < this.configuration.length; ++i) {
            commands.addCommand((ICommand)new ConnectProjectCommand(this.configuration[i].getProject(), this.repository));
        }
        return commands.run(progressMonitor);
    }
}

