/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.client.eclipse.filemodification;

import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.LockLevel;
import com.microsoft.tfs.util.Check;
import org.eclipse.core.runtime.IStatus;

public class TFSFileModificationOptions {
    private final IStatus status;
    private final String[] files;
    private final LockLevel lockLevel;
    private final boolean isSynchronous;
    private final boolean isForeground;
    private final boolean isGetLatest;

    public TFSFileModificationOptions(IStatus status) {
        Check.notNull((Object)status, (String)"status");
        Check.isTrue((!status.isOK() ? 1 : 0) != 0, (String)"! status.isOK");
        this.status = status;
        this.files = null;
        this.lockLevel = null;
        this.isSynchronous = true;
        this.isForeground = true;
        this.isGetLatest = true;
    }

    public TFSFileModificationOptions(IStatus status, String[] files, LockLevel lockLevel, boolean isSynchronous, boolean isForeground, boolean isGetLatest) {
        Check.notNull((Object)status, (String)"status");
        Check.notNullOrEmpty((Object[])files, (String)"files");
        Check.notNull((Object)lockLevel, (String)"lockLevel");
        this.status = status;
        this.files = files;
        this.lockLevel = lockLevel;
        this.isSynchronous = isSynchronous;
        this.isForeground = isForeground;
        this.isGetLatest = isGetLatest;
    }

    public IStatus getStatus() {
        return this.status;
    }

    public String[] getFiles() {
        return this.files;
    }

    public LockLevel getLockLevel() {
        return this.lockLevel;
    }

    public boolean isSynchronous() {
        return this.isSynchronous;
    }

    public boolean isForeground() {
        return this.isForeground;
    }

    public boolean isGetLatest() {
        return this.isGetLatest;
    }
}

