/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.client.eclipse.filemodification;

import com.microsoft.tfs.client.common.commands.vc.EditCommand;
import com.microsoft.tfs.client.common.framework.command.CommandExecutor;
import com.microsoft.tfs.client.common.framework.command.ICommand;
import com.microsoft.tfs.client.common.framework.command.JobCommandAdapter;
import com.microsoft.tfs.client.common.framework.resources.LocationUnavailablePolicy;
import com.microsoft.tfs.client.common.framework.resources.Resources;
import com.microsoft.tfs.client.common.framework.resources.filter.CompositeResourceFilter;
import com.microsoft.tfs.client.common.framework.resources.filter.ResourceFilter;
import com.microsoft.tfs.client.common.framework.resources.filter.ResourceFilterResult;
import com.microsoft.tfs.client.common.framework.resources.filter.ResourceFilters;
import com.microsoft.tfs.client.common.repository.TFSRepository;
import com.microsoft.tfs.client.common.util.ExtensionLoader;
import com.microsoft.tfs.client.eclipse.Messages;
import com.microsoft.tfs.client.eclipse.TFSEclipseClientPlugin;
import com.microsoft.tfs.client.eclipse.TFSRepositoryProvider;
import com.microsoft.tfs.client.eclipse.commands.eclipse.IgnoreResourceRefreshesEditCommand;
import com.microsoft.tfs.client.eclipse.filemodification.TFSFileModificationAdvisor;
import com.microsoft.tfs.client.eclipse.filemodification.TFSFileModificationOptions;
import com.microsoft.tfs.client.eclipse.filemodification.TFSFileModificationOptionsProvider;
import com.microsoft.tfs.client.eclipse.filemodification.TFSFileModificationStatusData;
import com.microsoft.tfs.client.eclipse.filemodification.TFSFileModificationStatusReporter;
import com.microsoft.tfs.client.eclipse.project.ProjectRepositoryStatus;
import com.microsoft.tfs.client.eclipse.resource.PluginResourceFilters;
import com.microsoft.tfs.client.eclipse.resourcedata.ResourceDataManager;
import com.microsoft.tfs.core.clients.versioncontrol.GetOptions;
import com.microsoft.tfs.core.clients.versioncontrol.PendChangesOptions;
import com.microsoft.tfs.core.clients.versioncontrol.SupportedFeatures;
import com.microsoft.tfs.core.clients.versioncontrol.WorkspaceLocation;
import com.microsoft.tfs.core.clients.versioncontrol.path.ServerPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ChangeType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.LockLevel;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PendingChange;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RecursionType;
import com.microsoft.tfs.core.clients.versioncontrol.specs.ItemSpec;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;

public final class TFSFileModificationValidator {
    private static final Log log = LogFactory.getLog(TFSFileModificationValidator.class);
    public static final String ADVISOR_EXTENSION_POINT_ID = "com.microsoft.tfs.client.eclipse.fileModificationAdvisor";
    private static final String IGNORE_UNDO_MANAGER_PROPERTY_NAME = "com.microsoft.tfs.client.eclipse.filemodification.ignoreUndoManager";
    private static final long CHECKOUT_WAIT_TIME = 30L;
    private static final ResourceFilter IGNORED_RESOURCES_FILTER = new CompositeResourceFilter.Builder(CompositeResourceFilter.CompositeResourceFilterType.ALL_MUST_ACCEPT).addFilter(PluginResourceFilters.TEAM_IGNORED_RESOURCES_FILTER).addFilter(ResourceFilters.TEAM_PRIVATE_RESOURCES_FILTER).addFilter(PluginResourceFilters.TPIGNORE_FILTER).build();
    private final TFSRepositoryProvider repositoryProvider;
    private final Map<IFile, TFSFileModificationStatusData> backgroundFiles = new HashMap<IFile, TFSFileModificationStatusData>();
    private final Object advisorLock = new Object();
    private TFSFileModificationAdvisor advisor = null;

    public TFSFileModificationValidator(TFSRepositoryProvider repositoryProvider) {
        this.repositoryProvider = repositoryProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus validateEdit(final IFile[] files, final boolean attemptUi, final Object shell) {
        TFSFileModificationOptions checkoutOptions;
        int i;
        ResourceDataManager resourceDataManager = TFSEclipseClientPlugin.getDefault().getResourceDataManager();
        final TFSRepository repository = this.repositoryProvider.getRepository();
        if (this.repositoryProvider.getRepositoryStatus() == ProjectRepositoryStatus.CONNECTING) {
            this.getStatusReporter(attemptUi, shell).reportError(Messages.getString("TFSFileModificationValidator.ErrorConnectionInProgress"), (IStatus)new Status(4, "com.microsoft.tfs.client.eclipse", 0, Messages.getString("TFSFileModificationValidator.ErrorConnectionInProgressDescription"), null));
            return Status.CANCEL_STATUS;
        }
        if (repository == null) {
            for (int i2 = 0; i2 < files.length; ++i2) {
                log.info((Object)MessageFormat.format("Setting {0} writable, project is offline from TFS server", files[i2]));
                files[i2].setReadOnly(false);
            }
            return Status.OK_STATUS;
        }
        if (WorkspaceLocation.LOCAL.equals((Object)repository.getWorkspace().getLocation())) {
            for (int i3 = 0; i3 < files.length; ++i3) {
                log.info((Object)MessageFormat.format("Ignoring read-only file {0} in local TFS workspace", files[i3]));
            }
            return Status.OK_STATUS;
        }
        if (!attemptUi && shell == null && !"false".equalsIgnoreCase(System.getProperty(IGNORE_UNDO_MANAGER_PROPERTY_NAME))) {
            Exception e = new Exception("");
            e.fillInStackTrace();
            StackTraceElement[] stackTrace = e.getStackTrace();
            if (stackTrace != null) {
                for (i = 0; i < stackTrace.length; ++i) {
                    if (!stackTrace[i].getClassName().equals("org.eclipse.ui.internal.ide.undo.WorkspaceUndoMonitor")) continue;
                    log.info((Object)"Ignoring file modification request from WorkspaceUndoMonitor");
                    return Status.OK_STATUS;
                }
            }
        }
        ArrayList<String> pathList = new ArrayList<String>();
        HashSet<String> projectSet = new HashSet<String>();
        for (i = 0; i < files.length; ++i) {
            if (IGNORED_RESOURCES_FILTER.filter((IResource)files[i]) == ResourceFilterResult.REJECT) {
                log.info((Object)MessageFormat.format("Setting {0} writable, file matches automatic validation filter", files[i]));
                files[i].setReadOnly(false);
                continue;
            }
            if (!resourceDataManager.hasResourceData((IResource)files[i]) && resourceDataManager.hasCompletedRefresh(files[i].getProject())) continue;
            String path = Resources.getLocation((IResource)files[i], (LocationUnavailablePolicy)LocationUnavailablePolicy.IGNORE_RESOURCE);
            String serverPath = repository.getWorkspace().getMappedServerPath(path);
            if (path == null) continue;
            PendingChange pendingChange = repository.getPendingChangeCache().getPendingChangeByLocalPath(path);
            if (pendingChange != null && (pendingChange.getChangeType().contains(ChangeType.ADD) || pendingChange.getChangeType().contains(ChangeType.EDIT))) {
                log.debug((Object)MessageFormat.format("File {0} has pending change {1}, ignoring", files[i], pendingChange.getChangeType().toUIString(true, pendingChange)));
                continue;
            }
            pathList.add(path);
            log.info((Object)MessageFormat.format("File {0} is being modified, checking out", files[i]));
            if (serverPath == null) continue;
            projectSet.add(ServerPath.getTeamProject((String)serverPath));
        }
        if (pathList.size() == 0) {
            return Status.OK_STATUS;
        }
        LockLevel forcedLockLevel = null;
        boolean forcedGetLatest = false;
        for (String teamProject : projectSet) {
            String exclusiveCheckoutAnnotation = repository.getAnnotationCache().getAnnotationValue("ExclusiveCheckout", teamProject, 0);
            String getLatestAnnotation = repository.getAnnotationCache().getAnnotationValue("GetLatestOnCheckout", teamProject, 0);
            if ("true".equalsIgnoreCase(exclusiveCheckoutAnnotation)) {
                forcedLockLevel = LockLevel.CHECKOUT;
                break;
            }
            if (!"true".equalsIgnoreCase(getLatestAnnotation)) continue;
            forcedGetLatest = true;
        }
        if (!(checkoutOptions = this.getOptions(attemptUi, shell, pathList.toArray(new String[pathList.size()]), forcedLockLevel)).getStatus().isOK()) {
            return checkoutOptions.getStatus();
        }
        String[] paths = checkoutOptions.getFiles();
        LockLevel lockLevel = checkoutOptions.getLockLevel();
        boolean getLatest = checkoutOptions.isGetLatest();
        boolean synchronousCheckout = checkoutOptions.isSynchronous();
        boolean foregroundCheckout = checkoutOptions.isForeground();
        if (paths.length == 0) {
            return Status.OK_STATUS;
        }
        ItemSpec[] itemSpecs = new ItemSpec[paths.length];
        for (int i4 = 0; i4 < paths.length; ++i4) {
            itemSpecs[i4] = new ItemSpec(paths[i4], RecursionType.NONE);
        }
        GetOptions getOptions = GetOptions.NO_DISK_UPDATE;
        PendChangesOptions pendChangesOptions = PendChangesOptions.NONE;
        if (repository.getWorkspace().getClient().getServerSupportedFeatures().contains(SupportedFeatures.GET_LATEST_ON_CHECKOUT) && getLatest) {
            pendChangesOptions = PendChangesOptions.GET_LATEST_ON_CHECKOUT;
            getOptions = GetOptions.NONE;
        }
        EditCommand editCommand = new EditCommand(repository, itemSpecs, lockLevel, null, getOptions, pendChangesOptions, false);
        if (synchronousCheckout || pendChangesOptions.contains(PendChangesOptions.GET_LATEST_ON_CHECKOUT) || forcedGetLatest) {
            IgnoreResourceRefreshesEditCommand wrappedEditCommand = new IgnoreResourceRefreshesEditCommand(editCommand);
            IStatus editStatus = this.getSynchronousCommandExecutor(attemptUi, shell).execute((ICommand)wrappedEditCommand);
            for (int i5 = 0; i5 < files.length; ++i5) {
                try {
                    files[i5].refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                    continue;
                }
                catch (Throwable e) {
                    log.warn((Object)MessageFormat.format("Could not refresh {0}", files[i5].getName()), e);
                }
            }
            return editStatus;
        }
        Map<IFile, TFSFileModificationStatusData> wrappedEditCommand = this.backgroundFiles;
        synchronized (wrappedEditCommand) {
            for (int i6 = 0; i6 < files.length; ++i6) {
                files[i6].setReadOnly(false);
                this.backgroundFiles.put(files[i6], new TFSFileModificationStatusData(files[i6]));
            }
        }
        final JobCommandAdapter editJob = new JobCommandAdapter((ICommand)editCommand);
        editJob.setPriority(10);
        editJob.setUser(foregroundCheckout);
        editJob.schedule();
        Thread editThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                IStatus editStatus;
                try {
                    editJob.join();
                    editStatus = editJob.getResult();
                }
                catch (Exception e) {
                    editStatus = new Status(4, "com.microsoft.tfs.client.eclipse", 0, null, (Throwable)e);
                }
                if (editStatus.isOK()) {
                    Map e = TFSFileModificationValidator.this.backgroundFiles;
                    synchronized (e) {
                        for (int i = 0; i < files.length; ++i) {
                            TFSFileModificationStatusData statusData = (TFSFileModificationStatusData)TFSFileModificationValidator.this.backgroundFiles.remove(files[i]);
                            if (statusData == null) continue;
                            log.info((Object)MessageFormat.format("File {0} checked out in {1} seconds", files[i], (int)((System.currentTimeMillis() - statusData.getStartTime()) / 1000L)));
                        }
                    }
                }
                ArrayList<TFSFileModificationStatusData> statusDataList = new ArrayList<TFSFileModificationStatusData>();
                Map i = TFSFileModificationValidator.this.backgroundFiles;
                synchronized (i) {
                    for (int i2 = 0; i2 < files.length; ++i2) {
                        TFSFileModificationStatusData statusData = (TFSFileModificationStatusData)TFSFileModificationValidator.this.backgroundFiles.remove(files[i2]);
                        if (statusData == null) continue;
                        log.info((Object)MessageFormat.format("File {0} failed to check out in {1} seconds", files[i2], (int)((System.currentTimeMillis() - statusData.getStartTime()) / 1000L)));
                        statusDataList.add(statusData);
                    }
                }
                TFSFileModificationStatusData[] statusData = statusDataList.toArray(new TFSFileModificationStatusData[statusDataList.size()]);
                TFSFileModificationValidator.this.getStatusReporter(attemptUi, shell).reportStatus(repository, statusData, editStatus);
            }
        });
        editThread.start();
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus validateSave(IFile file) {
        long startTime;
        TFSRepository repository = this.repositoryProvider.getRepository();
        if (repository != null && WorkspaceLocation.LOCAL.equals((Object)repository.getWorkspace().getLocation())) {
            return Status.OK_STATUS;
        }
        boolean inBackground = false;
        Map<IFile, TFSFileModificationStatusData> map = this.backgroundFiles;
        synchronized (map) {
            inBackground = this.backgroundFiles.get(file) != null;
        }
        long lastNotifyTime = startTime = System.currentTimeMillis();
        while (inBackground) {
            if (startTime == lastNotifyTime) {
                log.debug((Object)MessageFormat.format("File {0} still being checked out from TFS server, waiting for checkout to succeed before allowing save event", file.getLocation().toOSString()));
            }
            if (System.currentTimeMillis() - lastNotifyTime > 30000L) {
                log.warn((Object)MessageFormat.format("File {0} still being checked out from TFS server after {1} seconds.", file.getLocation().toOSString(), (int)((System.currentTimeMillis() - startTime) / 1000L)));
                lastNotifyTime = System.currentTimeMillis();
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                return Status.CANCEL_STATUS;
            }
            Map<IFile, TFSFileModificationStatusData> map2 = this.backgroundFiles;
            synchronized (map2) {
                inBackground = this.backgroundFiles.get(file) != null;
            }
        }
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCheckingOutFileInBackground(IFile file) {
        Map<IFile, TFSFileModificationStatusData> map = this.backgroundFiles;
        synchronized (map) {
            return this.backgroundFiles.get(file) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final TFSFileModificationAdvisor getFileModificationAdvisor() {
        Object object = this.advisorLock;
        synchronized (object) {
            if (this.advisor == null) {
                try {
                    this.advisor = (TFSFileModificationAdvisor)ExtensionLoader.loadSingleExtensionClass((String)ADVISOR_EXTENSION_POINT_ID);
                }
                catch (Exception e) {
                    log.error((Object)"Could not load file modification advisor for the product", (Throwable)e);
                    this.advisor = null;
                }
            }
            return this.advisor;
        }
    }

    private final TFSFileModificationOptions getOptions(boolean attemptUi, Object shell, String[] files, LockLevel forcedLockLevel) {
        TFSFileModificationOptionsProvider optionsProvider;
        TFSFileModificationAdvisor advisor = this.getFileModificationAdvisor();
        if (advisor != null && (optionsProvider = advisor.getOptionsProvider(attemptUi, shell)) != null) {
            return optionsProvider.getOptions(files, forcedLockLevel);
        }
        log.warn((Object)"File modification advisor not present or did not provide options, using default");
        return new TFSFileModificationOptions(Status.OK_STATUS, files, LockLevel.UNCHANGED, true, true, false);
    }

    private final CommandExecutor getSynchronousCommandExecutor(boolean attemptUi, Object shell) {
        CommandExecutor executor;
        TFSFileModificationAdvisor advisor = this.getFileModificationAdvisor();
        if (advisor != null && (executor = advisor.getSynchronousCommandExecutor(attemptUi, shell)) != null) {
            return executor;
        }
        log.warn((Object)"File modification advisor not present or did not provide a command executor, using default");
        return new CommandExecutor();
    }

    private final TFSFileModificationStatusReporter getStatusReporter(boolean attemptUi, Object shell) {
        TFSFileModificationStatusReporter statusReporter;
        TFSFileModificationAdvisor advisor = this.getFileModificationAdvisor();
        if (advisor != null && (statusReporter = advisor.getStatusReporter(attemptUi, shell)) != null) {
            return statusReporter;
        }
        log.warn((Object)"File modification advisor not present or did not provide a status reporter, using default");
        return new TFSFileModificationStatusReporter();
    }
}

