/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.client.eclipse.project;

import com.microsoft.tfs.client.common.repository.TFSRepository;
import com.microsoft.tfs.client.eclipse.project.ProjectManagerDataProviderFactory;
import com.microsoft.tfs.client.eclipse.project.ProjectRepositoryManager;
import com.microsoft.tfs.client.eclipse.util.TeamUtils;
import com.microsoft.tfs.util.Check;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;

public class ProjectCloseListener
implements IResourceChangeListener {
    private final Log log = LogFactory.getLog(ProjectCloseListener.class);
    private final ProjectRepositoryManager projectManager;

    public ProjectCloseListener(ProjectRepositoryManager projectManager) {
        Check.notNull((Object)projectManager, (String)"projectManager");
        this.projectManager = projectManager;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IProject[] allRepositoryProjects;
        String providerName;
        if (event.getType() != 2 || !(event.getResource() instanceof IProject)) {
            return;
        }
        IProject project = (IProject)event.getResource();
        if (!project.isOpen()) {
            this.log.error((Object)MessageFormat.format("Project Manager received close notification for project {0} (already closed)", project.getName()));
            return;
        }
        try {
            providerName = project.getPersistentProperty(TeamUtils.PROVIDER_PROP_KEY);
        }
        catch (CoreException e) {
            this.log.warn((Object)MessageFormat.format("Could not query repository manager for project {0} (when handling close notification)", project.getName()), (Throwable)e);
            return;
        }
        if (providerName == null || !providerName.equals("com.microsoft.tfs.client.eclipse.TFSRepositoryProvider")) {
            return;
        }
        TFSRepository repository = this.projectManager.getRepository(project);
        if (repository != null && (allRepositoryProjects = this.projectManager.getProjectsForRepository(repository)).length == 1 && allRepositoryProjects[0] == project) {
            ProjectManagerDataProviderFactory.getDataProvider().promptForDisconnect();
        }
        this.projectManager.close(project);
    }
}

