/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.client.eclipse.project;

import com.microsoft.tfs.client.common.commands.QueryLocalWorkspacesCommand;
import com.microsoft.tfs.client.common.framework.command.ExtensionPointAsyncObjectWaiter;
import com.microsoft.tfs.client.common.framework.command.ICommand;
import com.microsoft.tfs.client.common.framework.command.JobCommandAdapter;
import com.microsoft.tfs.client.common.repository.RepositoryConflictException;
import com.microsoft.tfs.client.common.repository.RepositoryManager;
import com.microsoft.tfs.client.common.repository.TFSRepository;
import com.microsoft.tfs.client.common.server.ServerManager;
import com.microsoft.tfs.client.common.server.TFSServer;
import com.microsoft.tfs.client.eclipse.Messages;
import com.microsoft.tfs.client.eclipse.TFSEclipseClientPlugin;
import com.microsoft.tfs.client.eclipse.project.ProjectConnectionManagerResult;
import com.microsoft.tfs.client.eclipse.project.ProjectManagerCachedWorkspaceConnectionJob;
import com.microsoft.tfs.client.eclipse.project.ProjectManagerConnectionJob;
import com.microsoft.tfs.client.eclipse.project.ProjectManagerDataProvider;
import com.microsoft.tfs.client.eclipse.project.ProjectManagerDataProviderFactory;
import com.microsoft.tfs.client.eclipse.project.ProjectManagerRepositoryJob;
import com.microsoft.tfs.core.TFSTeamProjectCollection;
import com.microsoft.tfs.core.clients.versioncontrol.WorkspaceKey;
import com.microsoft.tfs.core.clients.versioncontrol.Workstation;
import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.core.clients.versioncontrol.workspacecache.WorkspaceInfo;
import com.microsoft.tfs.core.config.persistence.DefaultPersistenceStoreProvider;
import com.microsoft.tfs.core.config.persistence.PersistenceStoreProvider;
import com.microsoft.tfs.util.Check;
import java.net.URI;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;

final class ProjectConnectionManager {
    private static final Log log = LogFactory.getLog(ProjectConnectionManager.class);
    private final ServerManager serverManager;
    private final RepositoryManager repositoryManager;
    private final Object cachedWorkspaceLock = new Object();
    private boolean emptyCachedWorkspaceFailures = false;
    private final Set<WorkspaceInfo> cachedWorkspaceFailures = new HashSet<WorkspaceInfo>();
    private final Object connectionLock = new Object();
    private final Map<WorkspaceKey, ProjectManagerRepositoryJob> workspaceJobMap = new HashMap<WorkspaceKey, ProjectManagerRepositoryJob>();
    private final Map<URI, ProjectManagerConnectionJob> serverConnectionJobMap = new HashMap<URI, ProjectManagerConnectionJob>();
    private final ProjectManagerRepositoryJobChangeListener repositoryJobChangeListener = new ProjectManagerRepositoryJobChangeListener();
    private final ProjectManagerConnectionJobChangeListener connectionJobChangeListener = new ProjectManagerConnectionJobChangeListener();

    ProjectConnectionManager(ServerManager serverManager, RepositoryManager repositoryManager) {
        this.serverManager = serverManager;
        this.repositoryManager = repositoryManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearErrors() {
        Object object = this.cachedWorkspaceLock;
        synchronized (object) {
            this.emptyCachedWorkspaceFailures = false;
            this.cachedWorkspaceFailures.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ProjectConnectionManagerResult connect(IProject project, boolean disconnectOtherServers) {
        IStatus result;
        ProjectManagerRepositoryJob repositoryJob;
        TFSRepository repository;
        WorkspaceInfo cachedWorkspace;
        Check.notNull((Object)project, (String)"project");
        ProjectManagerDataProvider dataProvider = ProjectManagerDataProviderFactory.getDataProvider();
        if (!project.isOpen()) {
            return new ProjectConnectionManagerResult((IStatus)new Status(4, "com.microsoft.tfs.client.eclipse", 0, MessageFormat.format(Messages.getString("ProjectConnectionManager.ProjectNotOpenFormat"), project.getName()), null));
        }
        if (project.getLocation() == null) {
            String message = MessageFormat.format(Messages.getString("ProjectConnectionManager.ProjectDoesNotHaveLocalFileSystemMappingFormat"), project.getName());
            return new ProjectConnectionManagerResult((IStatus)new Status(4, "com.microsoft.tfs.client.eclipse", 0, message, null));
        }
        Object object = this.cachedWorkspaceLock;
        synchronized (object) {
            cachedWorkspace = this.getCachedWorkspace(project);
            if (cachedWorkspace == null) {
                if (this.emptyCachedWorkspaceFailures) {
                    log.error((Object)MessageFormat.format("Project {0} was not found in workspace cache", project.getName()));
                    return new ProjectConnectionManagerResult((IStatus)new Status(4, "com.microsoft.tfs.client.eclipse", 0, MessageFormat.format(Messages.getString("ProjectConnectionManager.ProjectDoesNotHaveWorkingFolderMappingFormat"), project.getName()), null));
                }
                log.warn((Object)MessageFormat.format("Project {0} was not found in workspace cache", project.getName()));
                TFSRepository repository2 = this.connectRepository(project);
                if (repository2 == null) {
                    this.emptyCachedWorkspaceFailures = true;
                    return new ProjectConnectionManagerResult((IStatus)new Status(4, "com.microsoft.tfs.client.eclipse", 0, MessageFormat.format(Messages.getString("ProjectConnectionManager.ProjectDoesNotHaveWorkingFolderMappingFormat"), project.getName()), null));
                }
                return new ProjectConnectionManagerResult(repository2);
            }
        }
        WorkspaceKey workspaceKey = new WorkspaceKey(cachedWorkspace);
        Object object2 = this.connectionLock;
        synchronized (object2) {
            repository = TFSEclipseClientPlugin.getDefault().getRepositoryManager().getRepository(cachedWorkspace);
            if (repository != null) {
                log.debug((Object)MessageFormat.format("Project {0} can be connected to repository {1}", project.getName(), repository));
                return new ProjectConnectionManagerResult(repository);
            }
            repositoryJob = this.workspaceJobMap.get(workspaceKey);
            if (repositoryJob == null) {
                URI connectionURI = cachedWorkspace.getServerURI();
                TFSServer server = this.serverManager.getServer(connectionURI);
                if (server != null) {
                    log.debug((Object)MessageFormat.format("Project {0} will be connected to server {1}", project.getName(), server));
                    if (this.repositoryManager.getDefaultRepository() != null && !disconnectOtherServers) {
                        return new ProjectConnectionManagerResult((IStatus)new Status(4, "com.microsoft.tfs.client.eclipse", 0, MessageFormat.format(Messages.getString("ProjectConnectionManager.ProjectWillNotBeConnectedExistingConnectionExistsFormat"), project.getName()), null));
                    }
                    repositoryJob = new ProjectManagerRepositoryJob(this, dataProvider, cachedWorkspace, server.getConnection());
                    repositoryJob.addJobChangeListener((IJobChangeListener)this.repositoryJobChangeListener);
                    repositoryJob.schedule();
                    this.workspaceJobMap.put(workspaceKey, repositoryJob);
                } else {
                    ProjectManagerConnectionJob connectionJob = this.serverConnectionJobMap.get(connectionURI);
                    if (connectionJob == null) {
                        Object object3 = this.cachedWorkspaceLock;
                        synchronized (object3) {
                            if (this.cachedWorkspaceFailures.contains(cachedWorkspace)) {
                                return new ProjectConnectionManagerResult((IStatus)new Status(4, "com.microsoft.tfs.client.eclipse", 0, MessageFormat.format(Messages.getString("ProjectConnectionManager.ProjectWillNotBeConnectedPreviousConnectionCancelledFormat"), project.getName()), null));
                            }
                        }
                        if (this.serverManager.getDefaultServer() != null) {
                            log.debug((Object)MessageFormat.format("Another connection already exists while connecting project {0}", project.getName()));
                            if (!disconnectOtherServers) {
                                return new ProjectConnectionManagerResult((IStatus)new Status(4, "com.microsoft.tfs.client.eclipse", 0, MessageFormat.format(Messages.getString("ProjectConnectionManager.ProjectWillNotBeConnectedExistingConnectionExistsFormat"), project.getName()), null));
                            }
                            boolean retry = dataProvider.getConnectionConflictHandler().resolveServerConflict();
                            if (!retry || this.serverManager.getDefaultServer() != null) {
                                log.debug((Object)MessageFormat.format("Cancelled connection for project {0}, another connection already exists", project.getName()));
                                return new ProjectConnectionManagerResult((IStatus)new Status(4, "com.microsoft.tfs.client.eclipse", 0, MessageFormat.format(Messages.getString("ProjectConnectionManager.ProjectWillNotBeConnectedExistingConnectionExistsFormat"), project.getName()), null));
                            }
                        }
                        connectionJob = new ProjectManagerCachedWorkspaceConnectionJob(this, dataProvider, connectionURI, cachedWorkspace);
                        connectionJob.addJobChangeListener((IJobChangeListener)this.connectionJobChangeListener);
                        connectionJob.setSystem(true);
                        connectionJob.schedule();
                        this.serverConnectionJobMap.put(connectionURI, connectionJob);
                    }
                    log.debug((Object)MessageFormat.format("Project {0} will be connected through connection job {1}", new Object[]{project.getName(), connectionJob}));
                    repositoryJob = new ProjectManagerRepositoryJob(this, dataProvider, cachedWorkspace, connectionJob);
                    repositoryJob.addJobChangeListener((IJobChangeListener)this.repositoryJobChangeListener);
                    repositoryJob.schedule();
                    log.debug((Object)MessageFormat.format("Project {0} will be connected through repository realization job {1}", new Object[]{project.getName(), repositoryJob}));
                    this.workspaceJobMap.put(workspaceKey, repositoryJob);
                }
            }
        }
        try {
            log.debug((Object)"Waiting for repository job to finish");
            new ExtensionPointAsyncObjectWaiter().joinJob((Job)repositoryJob);
            result = repositoryJob.getResult();
        }
        catch (InterruptedException e) {
            result = new Status(4, "com.microsoft.tfs.client.eclipse", 0, MessageFormat.format(Messages.getString("ProjectConnectionManager.CouldNotConnectToConnectionFormat"), ProjectConnectionManager.getConnectionName(cachedWorkspace)), (Throwable)e);
        }
        if (result == null) {
            result = new Status(4, "com.microsoft.tfs.client.eclipse", 0, Messages.getString("ProjectConnectionManager.CouldNotExecuteProjectConnectionJobFormat"), null);
        }
        if (!result.isOK()) {
            return new ProjectConnectionManagerResult(null, result);
        }
        repository = repositoryJob.getRepository();
        return new ProjectConnectionManagerResult(repositoryJob.getRepository(), result);
    }

    public static String getConnectionName(WorkspaceInfo cachedWorkspace) {
        if (cachedWorkspace != null && cachedWorkspace.getServerURI() != null) {
            return cachedWorkspace.getServerURI().toString();
        }
        return Messages.getString("ProjectConnectionManager.TeamFoundationServerProductName");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connectionFailed(WorkspaceInfo cachedWorkspace) {
        Object object = this.cachedWorkspaceLock;
        synchronized (object) {
            this.cachedWorkspaceFailures.add(cachedWorkspace);
        }
    }

    private WorkspaceInfo getCachedWorkspace(IProject project) {
        String projectPath = LocalPath.canonicalize((String)project.getLocation().toOSString());
        return Workstation.getCurrent((PersistenceStoreProvider)DefaultPersistenceStoreProvider.INSTANCE).getLocalWorkspaceInfo(projectPath);
    }

    private TFSRepository connectRepository(IProject project) {
        TFSRepository repository;
        TFSTeamProjectCollection connection;
        block10: {
            Check.notNull((Object)project, (String)"project");
            Check.notNull((Object)project.getLocation(), (String)"project.getLocation()");
            Check.notNull((Object)project.getLocation().toOSString(), (String)"project.getLocation().toOSString()");
            ProjectManagerDataProvider dataProvider = ProjectManagerDataProviderFactory.getDataProvider();
            connection = dataProvider.promptForConnection(project);
            if (connection == null) {
                return null;
            }
            QueryLocalWorkspacesCommand updateCacheCommand = new QueryLocalWorkspacesCommand(connection);
            JobCommandAdapter updateCacheJob = new JobCommandAdapter((ICommand)updateCacheCommand);
            updateCacheJob.schedule();
            try {
                new ExtensionPointAsyncObjectWaiter().joinJob((Job)updateCacheJob);
            }
            catch (InterruptedException e) {
                return null;
            }
            if (!updateCacheJob.getResult().isOK()) {
                return null;
            }
            Workspace workspace = connection.getVersionControlClient().getWorkspace(project.getLocation().toOSString());
            if (workspace == null) {
                return null;
            }
            repository = null;
            try {
                repository = this.repositoryManager.getOrCreateRepository(workspace);
            }
            catch (RepositoryConflictException e) {
                if (!dataProvider.getConnectionConflictHandler().resolveRepositoryConflict()) break block10;
                try {
                    repository = this.repositoryManager.getOrCreateRepository(workspace);
                }
                catch (RepositoryConflictException f) {
                    dataProvider.getConnectionConflictHandler().notifyRepositoryConflict();
                }
            }
        }
        if (repository != null) {
            this.serverManager.setDefaultServer(connection);
        }
        return repository;
    }

    private class ProjectManagerConnectionJobChangeListener
    extends JobChangeAdapter {
        private ProjectManagerConnectionJobChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done(IJobChangeEvent event) {
            IStatus result = event.getResult();
            ProjectManagerConnectionJob job = (ProjectManagerConnectionJob)event.getJob();
            URI connectionURI = job.getServerURI();
            Object object = ProjectConnectionManager.this.connectionLock;
            synchronized (object) {
                ProjectManagerConnectionJob testJob = (ProjectManagerConnectionJob)((Object)ProjectConnectionManager.this.serverConnectionJobMap.remove(connectionURI));
                if (testJob == null) {
                    log.warn((Object)"Could not locate running server connection job in connection manager.");
                } else if (!((Object)((Object)testJob)).equals((Object)job)) {
                    log.warn((Object)"Multiple server connection jobs running for same connection key.");
                } else if (result.isOK()) {
                    ProjectConnectionManager.this.serverManager.addServer(job.getConnection());
                }
            }
        }
    }

    private class ProjectManagerRepositoryJobChangeListener
    extends JobChangeAdapter {
        private ProjectManagerRepositoryJobChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done(IJobChangeEvent event) {
            IStatus result = event.getResult();
            ProjectManagerRepositoryJob job = (ProjectManagerRepositoryJob)event.getJob();
            WorkspaceKey workspaceKey = new WorkspaceKey(job.getCachedWorkspace());
            Object object = ProjectConnectionManager.this.connectionLock;
            synchronized (object) {
                ProjectManagerRepositoryJob testJob = (ProjectManagerRepositoryJob)((Object)ProjectConnectionManager.this.workspaceJobMap.remove(workspaceKey));
                if (testJob == null) {
                    log.warn((Object)"Could not locate running repository connection job in connection manager.");
                } else if (!((Object)((Object)testJob)).equals((Object)job)) {
                    log.warn((Object)"Multiple repository connection jobs running for same connection key.");
                } else if (result.isOK()) {
                    log.debug((Object)"Project Manager connected project with repository");
                }
            }
        }
    }
}

