/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.client.eclipse.project;

import com.microsoft.tfs.client.eclipse.project.ProjectConnectionManager;
import com.microsoft.tfs.client.eclipse.project.ProjectManagerConnectionJob;
import com.microsoft.tfs.client.eclipse.project.ProjectManagerDataProvider;
import com.microsoft.tfs.core.clients.versioncontrol.WorkspaceLocation;
import com.microsoft.tfs.core.clients.versioncontrol.workspacecache.WorkspaceInfo;
import com.microsoft.tfs.core.config.persistence.DefaultPersistenceStoreProvider;
import com.microsoft.tfs.core.config.persistence.PersistenceStoreProvider;
import com.microsoft.tfs.core.credentials.CachedCredentials;
import com.microsoft.tfs.core.credentials.CredentialsManager;
import com.microsoft.tfs.core.credentials.CredentialsManagerFactory;
import com.microsoft.tfs.core.httpclient.Credentials;
import com.microsoft.tfs.core.httpclient.DefaultNTCredentials;
import com.microsoft.tfs.util.Check;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

class ProjectManagerCachedWorkspaceConnectionJob
extends ProjectManagerConnectionJob {
    private static final Log log = LogFactory.getLog(ProjectManagerCachedWorkspaceConnectionJob.class);
    private final ProjectConnectionManager connectionManager;
    private final WorkspaceInfo cachedWorkspace;

    ProjectManagerCachedWorkspaceConnectionJob(ProjectConnectionManager connectionManager, ProjectManagerDataProvider dataProvider, URI uri, WorkspaceInfo cachedWorkspace) {
        super(dataProvider, cachedWorkspace.getServerURI(), WorkspaceLocation.LOCAL.equals((Object)cachedWorkspace.getLocation()));
        Check.notNull((Object)cachedWorkspace, (String)"cachedWorkspace");
        this.connectionManager = connectionManager;
        this.cachedWorkspace = cachedWorkspace;
    }

    protected IStatus run(IProgressMonitor monitor) {
        Credentials credentials;
        URI serverURI = this.cachedWorkspace.getServerURI();
        CredentialsManager credentialsProvider = CredentialsManagerFactory.getCredentialsManager((PersistenceStoreProvider)DefaultPersistenceStoreProvider.INSTANCE);
        CachedCredentials cachedCredentials = credentialsProvider.getCredentials(serverURI);
        if (cachedCredentials != null) {
            credentials = cachedCredentials.toCredentials();
            if (cachedCredentials.getPassword() == null && WorkspaceLocation.SERVER.equals((Object)this.cachedWorkspace.getLocation())) {
                credentials = this.getDataProvider().getCredentials(this.cachedWorkspace, cachedCredentials.toCredentials());
            }
        } else {
            credentials = new DefaultNTCredentials();
        }
        if (credentials == null) {
            return Status.CANCEL_STATUS;
        }
        this.setCredentials(credentials);
        return super.run(monitor);
    }
}

