/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.client.eclipse.project;

import com.microsoft.tfs.client.eclipse.Messages;
import com.microsoft.tfs.client.eclipse.project.ProjectManagerDataProvider;
import com.microsoft.tfs.core.TFSTeamProjectCollection;
import com.microsoft.tfs.core.config.ConnectionAdvisor;
import com.microsoft.tfs.core.exceptions.TFSUnauthorizedException;
import com.microsoft.tfs.core.httpclient.Credentials;
import com.microsoft.tfs.core.ws.runtime.exceptions.TransportRequestHandlerCanceledException;
import com.microsoft.tfs.util.Check;
import java.net.URI;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

class ProjectManagerConnectionJob
extends Job {
    private static final Log log = LogFactory.getLog(ProjectManagerConnectionJob.class);
    private final Object lock = new Object();
    private final ProjectManagerDataProvider dataProvider;
    private final URI serverURI;
    private final boolean stayOffline;
    private Credentials credentials;
    private TFSTeamProjectCollection connection;

    protected ProjectManagerConnectionJob(ProjectManagerDataProvider dataProvider, URI serverURI, boolean stayOffline) {
        super(MessageFormat.format(Messages.getString("ProjectManagerConnectionJob.ConnectingToServerFormat"), serverURI));
        Check.notNull((Object)dataProvider, (String)"dataProvider");
        Check.notNull((Object)serverURI, (String)"serverURI");
        this.dataProvider = dataProvider;
        this.serverURI = serverURI;
        this.stayOffline = stayOffline;
    }

    ProjectManagerConnectionJob(ProjectManagerDataProvider dataProvider, URI serverURI, Credentials credentials, boolean stayOffline) {
        this(dataProvider, serverURI, stayOffline);
        Check.notNull((Object)credentials, (String)"credentials");
        this.credentials = credentials;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCredentials(Credentials credentials) {
        Check.notNull((Object)credentials, (String)"credentials");
        Object object = this.lock;
        synchronized (object) {
            this.credentials = credentials;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ProjectManagerDataProvider getDataProvider() {
        Object object = this.lock;
        synchronized (object) {
            return this.dataProvider;
        }
    }

    public URI getServerURI() {
        return this.serverURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        Credentials credentials;
        URI serverURI;
        ProjectManagerDataProvider dataProvider;
        Check.notNull((Object)this.serverURI, (String)"serverURI");
        Check.notNull((Object)this.credentials, (String)"credentials");
        Object object = this.lock;
        synchronized (object) {
            dataProvider = this.dataProvider;
            serverURI = this.serverURI;
            credentials = this.credentials;
        }
        ConnectionAdvisor connectionAdvisor = dataProvider.getConnectionAdvisor();
        if (connectionAdvisor == null) {
            return new Status(4, "com.microsoft.tfs.client.eclipse", 0, Messages.getString("ProjectManagerConnectionJob.AConnectionAdvisorCouldNotBeCreatedForThisConnection"), null);
        }
        TFSTeamProjectCollection connection = null;
        do {
            try {
                log.info((Object)MessageFormat.format("Connecting to server {0}", serverURI));
                connection = new TFSTeamProjectCollection(serverURI, credentials, connectionAdvisor);
                if (this.stayOffline) continue;
                connection.authenticate();
            }
            catch (Exception e) {
                log.warn((Object)MessageFormat.format("Could not connect to Team Foundation Server: {0}", e.getMessage()));
                connection = null;
                if (e instanceof TFSUnauthorizedException) {
                    if ((credentials = dataProvider.getCredentials(serverURI, credentials, e.getLocalizedMessage())) != null) continue;
                    return Status.CANCEL_STATUS;
                }
                if (e instanceof TransportRequestHandlerCanceledException) {
                    return Status.CANCEL_STATUS;
                }
                connection = dataProvider.promptForConnection(serverURI, credentials, e.getLocalizedMessage());
                if (connection != null) continue;
                return Status.CANCEL_STATUS;
            }
        } while (connection == null);
        Object object2 = this.lock;
        synchronized (object2) {
            this.connection = connection;
        }
        if (!this.stayOffline) {
            dataProvider.notifyConnectionEstablished(connection);
        }
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setConnection(TFSTeamProjectCollection connection) {
        Object object = this.lock;
        synchronized (object) {
            this.connection = connection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TFSTeamProjectCollection getConnection() {
        Object object = this.lock;
        synchronized (object) {
            return this.connection;
        }
    }
}

