/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.client.eclipse.project;

import com.microsoft.tfs.client.common.framework.command.ExtensionPointAsyncObjectWaiter;
import com.microsoft.tfs.client.common.repository.RepositoryConflictException;
import com.microsoft.tfs.client.common.repository.TFSRepository;
import com.microsoft.tfs.client.eclipse.Messages;
import com.microsoft.tfs.client.eclipse.TFSEclipseClientPlugin;
import com.microsoft.tfs.client.eclipse.project.ProjectConnectionManager;
import com.microsoft.tfs.client.eclipse.project.ProjectManagerConnectionJob;
import com.microsoft.tfs.client.eclipse.project.ProjectManagerDataProvider;
import com.microsoft.tfs.core.TFSTeamProjectCollection;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.core.clients.versioncontrol.workspacecache.WorkspaceInfo;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

class ProjectManagerRepositoryJob
extends Job {
    private final Object lock = new Object();
    private final ProjectConnectionManager connectionManager;
    private final ProjectManagerDataProvider dataProvider;
    private final WorkspaceInfo cachedWorkspace;
    private final TFSTeamProjectCollection connection;
    private final ProjectManagerConnectionJob connectionJob;
    private TFSRepository repository;

    ProjectManagerRepositoryJob(ProjectConnectionManager connectionManager, ProjectManagerDataProvider dataProvider, WorkspaceInfo cachedWorkspace, TFSTeamProjectCollection connection) {
        super(MessageFormat.format(Messages.getString("ProjectManagerRepositoryJob.JobNameFormat"), ProjectConnectionManager.getConnectionName(cachedWorkspace)));
        this.connectionManager = connectionManager;
        this.dataProvider = dataProvider;
        this.cachedWorkspace = cachedWorkspace;
        this.connection = connection;
        this.connectionJob = null;
    }

    ProjectManagerRepositoryJob(ProjectConnectionManager connectionManager, ProjectManagerDataProvider dataProvider, WorkspaceInfo cachedWorkspace, ProjectManagerConnectionJob connectionJob) {
        super(MessageFormat.format(Messages.getString("ProjectManagerRepositoryJob.JobNameFormat"), ProjectConnectionManager.getConnectionName(cachedWorkspace)));
        this.connectionManager = connectionManager;
        this.dataProvider = dataProvider;
        this.cachedWorkspace = cachedWorkspace;
        this.connection = null;
        this.connectionJob = connectionJob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final WorkspaceInfo getCachedWorkspace() {
        Object object = this.lock;
        synchronized (object) {
            return this.cachedWorkspace;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        Object object = this.lock;
        synchronized (object) {
            block16: {
                TFSTeamProjectCollection connection;
                if (this.connectionJob != null) {
                    try {
                        new ExtensionPointAsyncObjectWaiter().joinJob((Job)this.connectionJob);
                    }
                    catch (InterruptedException e) {
                        this.connectionManager.connectionFailed(this.cachedWorkspace);
                        return new Status(8, "com.microsoft.tfs.client.eclipse", 0, Messages.getString("ProjectManagerRepositoryJob.InterruptionWhileConnectingToServer"), (Throwable)e);
                    }
                    if (!this.connectionJob.getResult().isOK()) {
                        this.connectionManager.connectionFailed(this.cachedWorkspace);
                        return this.connectionJob.getResult();
                    }
                    connection = this.connectionJob.getConnection();
                } else {
                    connection = this.connection;
                }
                Workspace workspace = this.cachedWorkspace.getWorkspace(connection);
                if (workspace == null) {
                    this.connectionManager.connectionFailed(this.cachedWorkspace);
                    return new Status(4, "com.microsoft.tfs.client.eclipse", 0, MessageFormat.format(Messages.getString("ProjectManagerRepositoryJob.CouldNotLocateWorkspaceOnServerFormat"), this.cachedWorkspace.getName(), ProjectConnectionManager.getConnectionName(this.cachedWorkspace)), null);
                }
                try {
                    this.repository = TFSEclipseClientPlugin.getDefault().getRepositoryManager().getOrCreateRepository(workspace);
                }
                catch (RepositoryConflictException e) {
                    boolean notifyConflict = true;
                    if (this.dataProvider.getConnectionConflictHandler().resolveRepositoryConflict()) {
                        try {
                            this.repository = TFSEclipseClientPlugin.getDefault().getRepositoryManager().getOrCreateRepository(workspace);
                        }
                        catch (RepositoryConflictException f) {
                            this.repository = null;
                        }
                    } else {
                        notifyConflict = false;
                        this.repository = null;
                    }
                    if (this.repository != null) break block16;
                    if (notifyConflict) {
                        this.dataProvider.getConnectionConflictHandler().notifyRepositoryConflict();
                    }
                    this.connectionManager.connectionFailed(this.cachedWorkspace);
                    return new Status(1, "com.microsoft.tfs.client.eclipse", 0, Messages.getString("ProjectManagerRepositoryJob.ConnectionToDifferentServerAlreadyExists"), (Throwable)e);
                }
            }
        }
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TFSRepository getRepository() {
        Object object = this.lock;
        synchronized (object) {
            return this.repository;
        }
    }
}

