/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.client.eclipse.project;

import com.microsoft.tfs.client.eclipse.Messages;
import com.microsoft.tfs.client.eclipse.project.ProjectManagerDataProvider;
import com.microsoft.tfs.core.TFSTeamProjectCollection;
import com.microsoft.tfs.core.clients.versioncontrol.VersionControlClient;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.core.httpclient.Credentials;
import com.microsoft.tfs.util.Check;
import java.net.URI;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

class ProjectManagerWorkspaceJob
extends Job {
    private static final Log log = LogFactory.getLog(ProjectManagerWorkspaceJob.class);
    private final IProject project;
    private final URI serverURI;
    private final Credentials credentials;
    private Workspace workspace;

    ProjectManagerWorkspaceJob(ProjectManagerDataProvider dataProvider, IProject project, URI serverURI, Credentials credentials) {
        super(MessageFormat.format(Messages.getString("ProjectManagerWorkspaceJob.JobNameFormat"), serverURI.toString()));
        this.setSystem(true);
        this.project = project;
        this.serverURI = serverURI;
        this.credentials = credentials;
    }

    protected IStatus run(IProgressMonitor monitor) {
        VersionControlClient client;
        Check.notNull((Object)this.serverURI, (String)"serverURI");
        Check.notNull((Object)this.credentials, (String)"credentials");
        Check.notNull((Object)this.project, (String)"project");
        Check.notNull((Object)this.project.getLocation(), (String)"project.getLocation()");
        Check.notNull((Object)this.project.getLocation().toOSString(), (String)"project.getLocation().toOSString()");
        try {
            TFSTeamProjectCollection connection = new TFSTeamProjectCollection(this.serverURI, this.credentials);
            connection.ensureAuthenticated();
            client = connection.getVersionControlClient();
        }
        catch (Exception e) {
            return new Status(4, "com.microsoft.tfs.client.eclipse", 0, MessageFormat.format(Messages.getString("ProjectManagerWorkspaceJob.CouldNotConnectToServerFormat"), this.serverURI.toString()), (Throwable)e);
        }
        this.workspace = client.getWorkspace(this.project.getLocation().toOSString());
        return Status.OK_STATUS;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }
}

