/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.client.eclipse.project;

import com.microsoft.tfs.client.common.codemarker.CodeMarker;
import com.microsoft.tfs.client.common.codemarker.CodeMarkerDispatch;
import com.microsoft.tfs.client.common.framework.background.BackgroundTask;
import com.microsoft.tfs.client.common.framework.background.IBackgroundTask;
import com.microsoft.tfs.client.common.framework.command.ExtensionPointAsyncObjectWaiter;
import com.microsoft.tfs.client.common.license.LicenseListener;
import com.microsoft.tfs.client.common.license.LicenseManager;
import com.microsoft.tfs.client.common.repository.RepositoryManager;
import com.microsoft.tfs.client.common.repository.RepositoryManagerAdapter;
import com.microsoft.tfs.client.common.repository.RepositoryManagerEvent;
import com.microsoft.tfs.client.common.repository.RepositoryManagerListener;
import com.microsoft.tfs.client.common.repository.TFSRepository;
import com.microsoft.tfs.client.common.server.ServerManager;
import com.microsoft.tfs.client.common.server.TFSServer;
import com.microsoft.tfs.client.eclipse.Messages;
import com.microsoft.tfs.client.eclipse.TFSEclipseClientPlugin;
import com.microsoft.tfs.client.eclipse.license.TFSEclipseClientLicenseManager;
import com.microsoft.tfs.client.eclipse.project.ProjectCloseListener;
import com.microsoft.tfs.client.eclipse.project.ProjectConnectionManager;
import com.microsoft.tfs.client.eclipse.project.ProjectConnectionManagerResult;
import com.microsoft.tfs.client.eclipse.project.ProjectManagerDataProvider;
import com.microsoft.tfs.client.eclipse.project.ProjectManagerDataProviderFactory;
import com.microsoft.tfs.client.eclipse.project.ProjectRepositoryManagerListener;
import com.microsoft.tfs.client.eclipse.project.ProjectRepositoryStatus;
import com.microsoft.tfs.client.eclipse.util.TeamUtils;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.listeners.SingleListenerFacade;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectRepositoryManager {
    private static final Log log = LogFactory.getLog(ProjectRepositoryManager.class);
    public static final CodeMarker FINISH_PROJECT_ADDITION = new CodeMarker("com.microsoft.tfs.client.eclipse.project.ProjectRepositoryManager#finishProjectAddition");
    public static final CodeMarker FINISH_CONNECTION = new CodeMarker("com.microsoft.tfs.client.eclipse.project.ProjectRepositoryManager#finishConnection");
    private static final QualifiedName REPOSITORY_STATUS_KEY = new QualifiedName("com.microsoft.tfs.client.eclipse", "TFSRepositoryStatus");
    private static final String REPOSITORY_STATUS_ONLINE_VALUE = "online";
    private static final String REPOSITORY_STATUS_OFFLINE_VALUE = "offline";
    private final RepositoryManager repositoryManager;
    private final ServerManager serverManager;
    private final ProjectConnectionManager connectionManager;
    private final Object licenseLock = new Object();
    private boolean licenseTested = false;
    private boolean licenseValid = false;
    private final Object projectDataLock = new Object();
    private boolean started = false;
    private final Map<IProject, ProjectRepositoryData> projectDataMap = new HashMap<IProject, ProjectRepositoryData>();
    private final Map<TFSRepository, Set<IProject>> repositoryToProjectMap = new HashMap<TFSRepository, Set<IProject>>();
    private final Map<TFSServer, Set<IProject>> serverToProjectMap = new HashMap<TFSServer, Set<IProject>>();
    private final Set<IProject> projectClosedSet = new HashSet<IProject>();
    private final ProjectCloseListener projectCloseListener;
    private final RepositoryManagerListener reconnectListener = new RepositoryManagerReconnectListener();
    private final SingleListenerFacade listeners = new SingleListenerFacade(ProjectRepositoryManagerListener.class);

    public ProjectRepositoryManager(ServerManager serverManager, RepositoryManager repositoryManager) {
        Check.notNull((Object)serverManager, (String)"serverManager");
        Check.notNull((Object)repositoryManager, (String)"repositoryManager");
        this.repositoryManager = repositoryManager;
        this.serverManager = serverManager;
        this.connectionManager = new ProjectConnectionManager(serverManager, repositoryManager);
        this.projectCloseListener = new ProjectCloseListener(this);
        repositoryManager.addListener(this.reconnectListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        HashMap<IProject, ProjectRepositoryData> projectsToConnect = new HashMap<IProject, ProjectRepositoryData>();
        log.info((Object)"Starting TFS repository manager");
        Object object = this.projectDataLock;
        synchronized (object) {
            Check.isTrue((!this.started ? 1 : 0) != 0, (String)"started == false");
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.projectCloseListener, 2);
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            for (int i = 0; i < projects.length; ++i) {
                Boolean shouldConnect = this.shouldConnect(projects[i]);
                if (shouldConnect == null) {
                    log.debug((Object)MessageFormat.format("Project {0} is not managed by TFS, ignoring", projects[i].getName()));
                    continue;
                }
                ProjectRepositoryData projectData = new ProjectRepositoryData();
                this.projectDataMap.put(projects[i], projectData);
                if (shouldConnect == Boolean.TRUE) {
                    projectData.setStatus(ProjectRepositoryStatus.CONNECTING);
                    projectsToConnect.put(projects[i], projectData);
                    log.info((Object)MessageFormat.format("Connecting project {0} to TFS server", projects[i].getName()));
                    continue;
                }
                projectData.setStatus(ProjectRepositoryStatus.OFFLINE);
                log.info((Object)MessageFormat.format("Project {0} is offline from TFS server, will not be connected", projects[i].getName()));
            }
            this.started = true;
        }
        for (Map.Entry projectEntry : projectsToConnect.entrySet()) {
            IProject project = (IProject)projectEntry.getKey();
            ProjectRepositoryData projectData = (ProjectRepositoryData)projectEntry.getValue();
            this.connectInternal(project, true, projectData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForManagerStartup() {
        while (true) {
            Object object = this.projectDataLock;
            synchronized (object) {
                if (this.started) {
                    return;
                }
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(Messages.getString("ProjectRepositoryManager.InterruptedWhileWaitingForProjectManagerStartup"), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProject(IProject project, TFSRepository repository) {
        Check.notNull((Object)project, (String)"project");
        Check.notNull((Object)repository, (String)"repository");
        log.debug((Object)MessageFormat.format("Adding project {0} for repository {1}", project.getName(), repository.getName()));
        this.waitForManagerStartup();
        Object object = this.projectDataLock;
        synchronized (object) {
            ProjectRepositoryData projectData = this.projectDataMap.get(project);
            if (projectData != null) {
                log.error((Object)MessageFormat.format("Project Manager already contains project {0} (when adding)", project.getName()));
                CodeMarkerDispatch.dispatch((CodeMarker)FINISH_PROJECT_ADDITION);
                return;
            }
            projectData = new ProjectRepositoryData();
            projectData.setRepository(repository);
            this.projectDataMap.put(project, projectData);
            this.connectRepository(project, repository);
        }
        log.info((Object)MessageFormat.format("Project {0} is now managed by TFS", project.getName()));
        TFSEclipseClientPlugin.getDefault().getResourceDataManager().addProject(repository, project);
        CodeMarkerDispatch.dispatch((CodeMarker)FINISH_PROJECT_ADDITION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOfflineProject(IProject project) {
        Check.notNull((Object)project, (String)"project");
        log.debug((Object)MessageFormat.format("Adding project {0} for offline repository", project.getName()));
        this.waitForManagerStartup();
        try {
            project.setPersistentProperty(REPOSITORY_STATUS_KEY, REPOSITORY_STATUS_OFFLINE_VALUE);
        }
        catch (CoreException e) {
            log.error((Object)MessageFormat.format("Could not set offline status for project {0}", project.getName()), (Throwable)e);
        }
        Object object = this.projectDataLock;
        synchronized (object) {
            ProjectRepositoryData projectData = this.projectDataMap.get(project);
            if (projectData != null) {
                log.error((Object)MessageFormat.format("Project Manager already contains project {0} (when adding)", project.getName()));
                CodeMarkerDispatch.dispatch((CodeMarker)FINISH_PROJECT_ADDITION);
                return;
            }
            projectData = new ProjectRepositoryData();
            projectData.setStatus(ProjectRepositoryStatus.OFFLINE);
            this.projectDataMap.put(project, projectData);
        }
        log.info((Object)MessageFormat.format("Project {0} is now managed by TFS (but offline)", project.getName()));
        CodeMarkerDispatch.dispatch((CodeMarker)FINISH_PROJECT_ADDITION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAndConnectProject(IProject project) {
        Check.notNull((Object)project, (String)"project");
        log.debug((Object)MessageFormat.format("Adding project {0} for offline repository", project.getName()));
        this.waitForManagerStartup();
        Object object = this.projectDataLock;
        synchronized (object) {
            ProjectRepositoryData projectData = this.projectDataMap.get(project);
            if (projectData != null) {
                log.error((Object)MessageFormat.format("Project Manager already contains project {0} (when adding)", project.getName()));
                CodeMarkerDispatch.dispatch((CodeMarker)FINISH_PROJECT_ADDITION);
                return;
            }
            projectData = new ProjectRepositoryData();
            projectData.setStatus(ProjectRepositoryStatus.CONNECTING);
            this.projectDataMap.put(project, projectData);
        }
        this.connect(project);
        CodeMarkerDispatch.dispatch((CodeMarker)FINISH_PROJECT_ADDITION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProject(IProject project) {
        TFSRepository repository;
        Check.notNull((Object)project, (String)"project");
        log.debug((Object)MessageFormat.format("Removing project {0}", project.getName()));
        this.waitForManagerStartup();
        Object object = this.projectDataLock;
        synchronized (object) {
            ProjectRepositoryData projectData = this.projectDataMap.get(project);
            if (projectData == null) {
                log.error((Object)MessageFormat.format("Project Manager does not contain project {0} (when removing)", project.getName()));
                return;
            }
            ProjectRepositoryData projectRepositoryData = projectData;
            synchronized (projectRepositoryData) {
                repository = projectData.getRepository();
            }
            this.projectDataMap.remove(project);
            if (repository != null) {
                this.disconnectRepository(project, repository, true, true);
            }
        }
        if (repository != null) {
            TFSEclipseClientPlugin.getDefault().getResourceDataManager().removeProject(repository, project);
        }
        ((ProjectRepositoryManagerListener)this.listeners.getListener()).onProjectRemoved(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearErrors() {
        Object object = this.licenseLock;
        synchronized (object) {
            this.licenseTested = false;
        }
        this.connectionManager.clearErrors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TFSRepository connectIfNecessary(IProject project) {
        ProjectRepositoryData projectData;
        Check.notNull((Object)project, (String)"project");
        this.waitForManagerStartup();
        Object object = this.projectDataLock;
        synchronized (object) {
            projectData = this.projectDataMap.get(project);
            if (projectData == null) {
                Boolean shouldConnect = this.shouldConnect(project);
                if (shouldConnect == null) {
                    return null;
                }
                projectData = new ProjectRepositoryData();
                this.projectDataMap.put(project, projectData);
                this.projectClosedSet.remove(project);
                if (shouldConnect.equals(Boolean.FALSE) && this.isAnyProjectOfStatus(ProjectRepositoryStatus.ONLINE)) {
                    shouldConnect = Boolean.TRUE;
                } else if (shouldConnect.equals(Boolean.TRUE) && this.isAnyProjectOfStatus(ProjectRepositoryStatus.OFFLINE)) {
                    shouldConnect = Boolean.FALSE;
                }
                if (shouldConnect == Boolean.FALSE) {
                    projectData.setStatus(ProjectRepositoryStatus.OFFLINE);
                    return null;
                }
                projectData.setStatus(ProjectRepositoryStatus.CONNECTING);
            } else {
                ProjectRepositoryData projectRepositoryData = projectData;
                synchronized (projectRepositoryData) {
                    if (projectData.getStatus() == ProjectRepositoryStatus.INITIALIZING) {
                        return null;
                    }
                    if (projectData.getStatus() != ProjectRepositoryStatus.CONNECTING) {
                        return projectData.getRepository();
                    }
                }
            }
        }
        return this.connectInternal(project, true, projectData);
    }

    private Boolean shouldConnect(IProject project) {
        String providerName;
        Check.notNull((Object)project, (String)"project");
        if (!project.isOpen()) {
            log.debug((Object)MessageFormat.format("Ignoring closed project {0}", project.getName()));
            return null;
        }
        try {
            providerName = project.getPersistentProperty(TeamUtils.PROVIDER_PROP_KEY);
        }
        catch (CoreException e) {
            log.warn((Object)MessageFormat.format("Could not query repository manager for project {0} (when determining connection viability)", project.getName()), (Throwable)e);
            return null;
        }
        if (providerName == null || !providerName.equals("com.microsoft.tfs.client.eclipse.TFSRepositoryProvider")) {
            return null;
        }
        String repositoryStatus = null;
        try {
            repositoryStatus = project.getPersistentProperty(REPOSITORY_STATUS_KEY);
        }
        catch (CoreException e) {
            log.warn((Object)MessageFormat.format("Repository status could not be determined for project {0} (when determining connection viability)", project.getName()), (Throwable)e);
        }
        if (REPOSITORY_STATUS_OFFLINE_VALUE.equals(repositoryStatus)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public TFSRepository connect(IProject project) {
        return this.connect(project, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TFSRepository connect(IProject project, boolean disconnectOtherServers) {
        ProjectRepositoryData projectData;
        Check.notNull((Object)project, (String)"project");
        log.info((Object)MessageFormat.format("Connecting project {0} to TFS server", project.getName()));
        this.waitForManagerStartup();
        Object object = this.projectDataLock;
        synchronized (object) {
            projectData = this.projectDataMap.get(project);
            if (projectData == null) {
                log.error((Object)MessageFormat.format("Project Manager does not contain project {0} (when returning online)", project.getName()));
                return null;
            }
            ProjectRepositoryData projectRepositoryData = projectData;
            synchronized (projectRepositoryData) {
                if (projectData.getStatus() == ProjectRepositoryStatus.INITIALIZING) {
                    log.error((Object)MessageFormat.format("Project manager does not contain a status for project {0} (when returning online)", project.getName()));
                    return null;
                }
                if (projectData.getStatus() == ProjectRepositoryStatus.OFFLINE) {
                    projectData.setStatus(ProjectRepositoryStatus.CONNECTING);
                }
            }
        }
        return this.connectInternal(project, disconnectOtherServers, projectData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TFSRepository connectInternal(IProject project, boolean disconnectOtherServers, ProjectRepositoryData projectData) {
        ProjectRepositoryConnectionJob connectionJob;
        if (!this.testLicense()) {
            ProjectRepositoryData projectRepositoryData = projectData;
            synchronized (projectRepositoryData) {
                if (projectData.getStatus() == ProjectRepositoryStatus.CONNECTING) {
                    projectData.setStatus(ProjectRepositoryStatus.OFFLINE);
                    return null;
                }
                return projectData.getRepository();
            }
        }
        ProjectRepositoryData projectRepositoryData = projectData;
        synchronized (projectRepositoryData) {
            if (projectData.getStatus() != ProjectRepositoryStatus.CONNECTING) {
                return projectData.getRepository();
            }
            connectionJob = projectData.getConnectionJob();
            if (connectionJob == null) {
                connectionJob = new ProjectRepositoryConnectionJob(project, disconnectOtherServers, projectData);
                connectionJob.schedule();
                projectData.setConnectionJob(connectionJob);
            }
        }
        try {
            new ExtensionPointAsyncObjectWaiter().joinJob((Job)connectionJob);
        }
        catch (InterruptedException e) {
            log.error((Object)MessageFormat.format("Interrupted while waiting to connect to project {0}", project.getName()));
            return null;
        }
        projectRepositoryData = projectData;
        synchronized (projectRepositoryData) {
            return projectData.getRepository();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean testLicense() {
        Object object = this.licenseLock;
        synchronized (object) {
            if (!this.licenseTested) {
                this.licenseValid = TFSEclipseClientLicenseManager.isLicensed();
                this.licenseTested = true;
            }
            if (!this.licenseValid) {
                LicenseManager.getInstance().addListener((LicenseListener)new ProjectManagerLicenseListener());
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectionFinished(IProject project, ProjectRepositoryData projectData, TFSRepository repository) {
        Object object = this.projectDataLock;
        synchronized (object) {
            ProjectRepositoryData projectRepositoryData = projectData;
            synchronized (projectRepositoryData) {
                if (repository == null) {
                    projectData.setStatus(ProjectRepositoryStatus.OFFLINE);
                } else {
                    projectData.setRepository(repository);
                }
                projectData.setConnectionJob(null);
                if (repository != null) {
                    this.connectRepository(project, repository);
                }
            }
        }
        String repositoryStatusValue = repository != null ? REPOSITORY_STATUS_ONLINE_VALUE : REPOSITORY_STATUS_OFFLINE_VALUE;
        try {
            project.setPersistentProperty(REPOSITORY_STATUS_KEY, repositoryStatusValue);
        }
        catch (CoreException e) {
            log.error((Object)MessageFormat.format("Could not set repository online/offline persistent property for project {0}", project.getName()), (Throwable)e);
        }
        if (repository != null) {
            log.info((Object)MessageFormat.format("Connection to TFS server successful for project {0}", project.getName()));
            TFSEclipseClientPlugin.getDefault().getResourceDataManager().addProject(repository, project);
            ((ProjectRepositoryManagerListener)this.listeners.getListener()).onProjectConnected(project, repository);
        } else {
            log.info((Object)MessageFormat.format("Connection to TFS server failed for project {0}", project.getName()));
            ((ProjectRepositoryManagerListener)this.listeners.getListener()).onProjectDisconnected(project);
        }
        CodeMarkerDispatch.dispatch((CodeMarker)FINISH_CONNECTION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectionCancelled(IProject project, ProjectRepositoryData projectData, TFSRepository repository) {
        Object object = this.projectDataLock;
        synchronized (object) {
            this.projectDataMap.remove(project);
            this.projectClosedSet.add(project);
            if (repository != null) {
                this.disconnectRepository(project, repository, false, true);
            }
        }
        log.info((Object)MessageFormat.format("Connection to TFS server cancelled for project {0}", project.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStarted() {
        Object object = this.projectDataLock;
        synchronized (object) {
            return this.started;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnecting() {
        this.waitForManagerStartup();
        Object object = this.projectDataLock;
        synchronized (object) {
            Iterator<ProjectRepositoryData> i = this.projectDataMap.values().iterator();
            while (i.hasNext()) {
                ProjectRepositoryData projectData;
                ProjectRepositoryData projectRepositoryData = projectData = i.next();
                synchronized (projectRepositoryData) {
                    if (projectData.getStatus() == ProjectRepositoryStatus.INITIALIZING) {
                        log.error((Object)"Project data contains no status (during connection check)");
                        return true;
                    }
                    if (projectData.getStatus() == ProjectRepositoryStatus.CONNECTING) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IProject[] getProjects() {
        this.waitForManagerStartup();
        Object object = this.projectDataLock;
        synchronized (object) {
            Set<IProject> projectSet = this.projectDataMap.keySet();
            return projectSet.toArray(new IProject[projectSet.size()]);
        }
    }

    public boolean isAnyProjectOfStatus(ProjectRepositoryStatus status) {
        return this.getProjectsOfStatus(status).length > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IProject[] getProjectsOfStatus(ProjectRepositoryStatus status) {
        Check.notNull((Object)((Object)status), (String)"status");
        this.waitForManagerStartup();
        ArrayList<IProject> projectList = new ArrayList<IProject>();
        Object object = this.projectDataLock;
        synchronized (object) {
            for (Map.Entry<IProject, ProjectRepositoryData> projectEntry : this.projectDataMap.entrySet()) {
                ProjectRepositoryData projectData;
                ProjectRepositoryData projectRepositoryData = projectData = projectEntry.getValue();
                synchronized (projectRepositoryData) {
                    if (status.contains(projectData.getStatus())) {
                        projectList.add(projectEntry.getKey());
                    }
                }
            }
        }
        return projectList.toArray(new IProject[projectList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IProject[] getClosedProjects() {
        this.waitForManagerStartup();
        Object object = this.projectDataLock;
        synchronized (object) {
            return this.projectClosedSet.toArray(new IProject[this.projectClosedSet.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IProject[] getProjectsForRepository(TFSRepository repository) {
        Check.notNull((Object)repository, (String)"repository");
        this.waitForManagerStartup();
        Object object = this.projectDataLock;
        synchronized (object) {
            Set<IProject> projectsForRepository = this.repositoryToProjectMap.get(repository);
            if (projectsForRepository == null) {
                return new IProject[0];
            }
            return projectsForRepository.toArray(new IProject[projectsForRepository.size()]);
        }
    }

    public void disconnect(TFSRepository repository) {
        this.disconnect(repository, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(TFSRepository repository, boolean disconnectServer) {
        Check.notNull((Object)repository, (String)"repository");
        log.debug((Object)MessageFormat.format("Disconnecting all projects for repository {0}", repository.getWorkspace().getDisplayName()));
        this.waitForManagerStartup();
        Object object = this.projectDataLock;
        synchronized (object) {
            Set<IProject> projectsForRepository = this.repositoryToProjectMap.get(repository);
            if (projectsForRepository == null) {
                return;
            }
            IProject[] projects = projectsForRepository.toArray(new IProject[projectsForRepository.size()]);
            for (int i = 0; i < projects.length; ++i) {
                this.disconnect(projects[i], disconnectServer);
            }
        }
    }

    public void disconnect(IProject[] projects) {
        this.disconnect(projects, true);
    }

    public void disconnect(IProject[] projects, boolean disconnectServer) {
        Check.notNull((Object)projects, (String)"projects");
        this.waitForManagerStartup();
        ((ProjectRepositoryManagerListener)this.listeners.getListener()).onOperationStarted();
        for (int i = 0; i < projects.length; ++i) {
            this.disconnect(projects[i], disconnectServer);
        }
        ((ProjectRepositoryManagerListener)this.listeners.getListener()).onOperationFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(IProject project, boolean disconnectServer) {
        Check.notNull((Object)project, (String)"project");
        log.info((Object)MessageFormat.format("Moving project {0} offline from TFS server", project.getName()));
        this.waitForManagerStartup();
        try {
            project.setPersistentProperty(REPOSITORY_STATUS_KEY, REPOSITORY_STATUS_OFFLINE_VALUE);
        }
        catch (CoreException e) {
            log.error((Object)MessageFormat.format("Could not set offline status for project {0}", project.getName()), (Throwable)e);
        }
        Object object = this.projectDataLock;
        synchronized (object) {
            TFSRepository projectRepository;
            ProjectRepositoryData projectData = this.projectDataMap.get(project);
            if (projectData == null) {
                log.error((Object)MessageFormat.format("Project Manager does not contain project {0} (while disconnecting)", project.getName()));
                return;
            }
            ProjectRepositoryData projectRepositoryData = projectData;
            synchronized (projectRepositoryData) {
                if (projectData.getStatus() != ProjectRepositoryStatus.ONLINE) {
                    log.error((Object)MessageFormat.format("Project Manager not online for project {0} (while disconnecting)", project.getName()));
                    return;
                }
                projectRepository = projectData.getRepository();
                if (projectRepository == null) {
                    log.error((Object)MessageFormat.format("Project Manager does not contain repository for project {0} (while disconnecting)", project.getName()));
                    return;
                }
                projectData.setStatus(ProjectRepositoryStatus.OFFLINE);
                this.disconnectRepository(project, projectRepository, true, disconnectServer);
            }
            TFSEclipseClientPlugin.getDefault().getResourceDataManager().removeProject(projectRepository, project);
            ((ProjectRepositoryManagerListener)this.listeners.getListener()).onProjectDisconnected(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(IProject project) {
        Check.notNull((Object)project, (String)"project");
        this.waitForManagerStartup();
        TFSRepository projectRepository = null;
        Object object = this.projectDataLock;
        synchronized (object) {
            this.projectClosedSet.add(project);
            ProjectRepositoryData projectData = this.projectDataMap.get(project);
            if (projectData == null) {
                log.error((Object)MessageFormat.format("Project Manager does not contain project {0} (while closing project)", project.getName()));
                return;
            }
            ProjectRepositoryData projectRepositoryData = projectData;
            synchronized (projectRepositoryData) {
                this.projectDataMap.remove(project);
                if (projectData.getStatus() == ProjectRepositoryStatus.CONNECTING) {
                    if (projectData.getConnectionJob() == null) {
                        projectData.setStatus(ProjectRepositoryStatus.INITIALIZING);
                    } else {
                        projectData.getConnectionJob().cancelConnection();
                    }
                } else if (projectData.getStatus() == ProjectRepositoryStatus.ONLINE) {
                    projectRepository = projectData.getRepository();
                    if (projectRepository == null) {
                        log.error((Object)MessageFormat.format("Project Manager does not contain repository for project {0} (while closing)", project.getName()));
                        return;
                    }
                    this.disconnectRepository(project, projectRepository, true, true);
                }
            }
        }
        if (projectRepository != null) {
            TFSEclipseClientPlugin.getDefault().getResourceDataManager().removeProject(projectRepository, project);
            ((ProjectRepositoryManagerListener)this.listeners.getListener()).onProjectDisconnected(project);
        }
    }

    private void connectRepository(IProject project, TFSRepository repository) {
        Check.notNull((Object)project, (String)"project");
        Check.notNull((Object)repository, (String)"repository");
        Set<IProject> projectsForRepository = this.repositoryToProjectMap.get(repository);
        if (projectsForRepository == null) {
            projectsForRepository = new HashSet<IProject>();
            this.repositoryToProjectMap.put(repository, projectsForRepository);
        }
        if (projectsForRepository.contains(project)) {
            log.error((Object)MessageFormat.format("Repository {0} already contains reference for project {1}", repository.getName(), project.getName()));
        } else {
            projectsForRepository.add(project);
        }
        TFSServer server = this.serverManager.getOrCreateServer(repository.getVersionControlClient().getConnection());
        Set<IProject> projectsForServer = this.serverToProjectMap.get(server);
        if (projectsForServer == null) {
            projectsForServer = new HashSet<IProject>();
            this.serverToProjectMap.put(server, projectsForServer);
        }
        if (projectsForServer.contains(project)) {
            log.error((Object)MessageFormat.format("Server {0} already contains reference for project {1}", server.getName(), project.getName()));
        } else {
            projectsForServer.add(project);
        }
    }

    private void disconnectRepository(IProject project, TFSRepository repository, boolean isConnected, boolean disconnectServer) {
        TFSServer server;
        Check.notNull((Object)project, (String)"project");
        Check.notNull((Object)repository, (String)"repository");
        Set<IProject> projectsForRepository = this.repositoryToProjectMap.get(repository);
        if (projectsForRepository == null) {
            log.error((Object)MessageFormat.format("Project Manager out of sync for repository {0}", repository.getName()));
            return;
        }
        if (!projectsForRepository.contains(project)) {
            if (isConnected) {
                log.error((Object)MessageFormat.format("Project Manager out of sync for repository {0} for project {1}", repository.getName(), project.getName()));
            }
        } else {
            projectsForRepository.remove(project);
        }
        if (projectsForRepository.size() == 0) {
            this.repositoryToProjectMap.remove(repository);
            repository.close();
            this.repositoryManager.removeRepository(repository);
        }
        if ((server = this.serverManager.getServer(repository.getVersionControlClient().getConnection())) == null) {
            log.error((Object)MessageFormat.format("Project Manager cannot locate server for project {0} (repository = {1}", project.getName(), repository.getName()));
            return;
        }
        Set<IProject> projectsForServer = this.serverToProjectMap.get(server);
        if (projectsForServer == null) {
            log.error((Object)MessageFormat.format("Project Manager out of sync for server {0}", server.getName()));
            return;
        }
        if (!projectsForServer.contains(project)) {
            log.error((Object)MessageFormat.format("Project Manager out of sync for server {0} for project {1}", server.getName(), project.getName()));
        } else {
            projectsForServer.remove(project);
            if (projectsForServer.size() == 0) {
                this.serverToProjectMap.remove(server);
                if (disconnectServer) {
                    server.close();
                    this.serverManager.removeServer(server);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectRepositoryStatus getProjectStatus(IProject project) {
        Check.notNull((Object)project, (String)"project");
        this.waitForManagerStartup();
        Object object = this.projectDataLock;
        synchronized (object) {
            ProjectRepositoryData projectData = this.projectDataMap.get(project);
            if (projectData == null) {
                log.error((Object)MessageFormat.format("Project Manager does not contain project {0} (during status query)", project.getName()));
                return ProjectRepositoryStatus.INITIALIZING;
            }
            ProjectRepositoryData projectRepositoryData = projectData;
            synchronized (projectRepositoryData) {
                return projectData.getStatus();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<TFSRepository, Set<IProject>> getRepositoryToProjectMap() {
        this.waitForManagerStartup();
        HashMap<TFSRepository, Set<IProject>> cloneMap = new HashMap<TFSRepository, Set<IProject>>();
        Object object = this.projectDataLock;
        synchronized (object) {
            for (Map.Entry<TFSRepository, Set<IProject>> entry : this.repositoryToProjectMap.entrySet()) {
                cloneMap.put(entry.getKey(), new HashSet(entry.getValue()));
            }
        }
        return cloneMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TFSRepository[] getRepositories() {
        this.waitForManagerStartup();
        ArrayList<TFSRepository> repositories = new ArrayList<TFSRepository>();
        Object object = this.projectDataLock;
        synchronized (object) {
            for (Map.Entry<IProject, ProjectRepositoryData> entry : this.projectDataMap.entrySet()) {
                IProject project = entry.getKey();
                ProjectRepositoryData projectData = entry.getValue();
                if (projectData == null) {
                    log.error((Object)MessageFormat.format("Project Manager does not contain project {0} (during query)", project.getName()));
                    continue;
                }
                ProjectRepositoryData projectRepositoryData = projectData;
                synchronized (projectRepositoryData) {
                    if (projectData.getRepository() != null) {
                        repositories.add(projectData.getRepository());
                    }
                }
            }
        }
        return repositories.toArray(new TFSRepository[repositories.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TFSRepository getRepository(IProject project) {
        Check.notNull((Object)project, (String)"project");
        this.waitForManagerStartup();
        Object object = this.projectDataLock;
        synchronized (object) {
            ProjectRepositoryData projectData = this.projectDataMap.get(project);
            if (projectData == null) {
                log.error((Object)MessageFormat.format("Project Manager does not contain project {0} (during query)", project.getName()));
                return null;
            }
            ProjectRepositoryData projectRepositoryData = projectData;
            synchronized (projectRepositoryData) {
                return projectData.getRepository();
            }
        }
    }

    public void addListener(ProjectRepositoryManagerListener listener) {
        this.listeners.addListener((Object)listener);
    }

    public void removeListener(ProjectRepositoryManagerListener listener) {
        this.listeners.removeListener((Object)listener);
    }

    private class RepositoryManagerReconnectListener
    extends RepositoryManagerAdapter {
        private RepositoryManagerReconnectListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onRepositoryAdded(RepositoryManagerEvent event) {
            IProject[] offlineProjects;
            final ProjectManagerDataProvider dataProvider = ProjectManagerDataProviderFactory.getDataProvider();
            if (!dataProvider.shouldReconnectProjects()) {
                return;
            }
            final ArrayList onlineProjects = new ArrayList();
            Object object = ProjectRepositoryManager.this.projectDataLock;
            synchronized (object) {
                if (ProjectRepositoryManager.this.getProjectsOfStatus(ProjectRepositoryStatus.INITIALIZING.combine(ProjectRepositoryStatus.ONLINE.combine(ProjectRepositoryStatus.CONNECTING))).length > 0) {
                    return;
                }
                offlineProjects = ProjectRepositoryManager.this.getProjectsOfStatus(ProjectRepositoryStatus.OFFLINE);
            }
            Job reconnectJob = new Job(Messages.getString("ProjectRepositoryManager.ReconnectJobName")){

                public IStatus run(IProgressMonitor progressMonitor) {
                    if (offlineProjects.length == 0) {
                        return Status.OK_STATUS;
                    }
                    TFSRepository repository = null;
                    for (int i = 0; i < offlineProjects.length; ++i) {
                        TFSRepository projectRepository = ProjectRepositoryManager.this.connect(offlineProjects[i], false);
                        if (projectRepository == null) continue;
                        if (repository != null && repository != projectRepository) {
                            log.warn((Object)"Multiple repositories were returned when trying to reconnect projects to existing repository.");
                            return new Status(4, "com.microsoft.tfs.client.eclipse", 0, Messages.getString("ProjectRepositoryManager.ReconnectToNewRepositoryFailureMessage"), null);
                        }
                        repository = projectRepository;
                        onlineProjects.add(offlineProjects[i]);
                    }
                    if (onlineProjects.size() > 0) {
                        dataProvider.notifyProjectsReconnected(repository, onlineProjects.toArray(new IProject[onlineProjects.size()]));
                    }
                    return Status.OK_STATUS;
                }
            };
            reconnectJob.schedule();
        }
    }

    private final class ProjectRepositoryConnectionJob
    extends Job {
        private final Object lock;
        private final IProject project;
        private final boolean disconnectOtherServers;
        private final ProjectRepositoryData projectData;
        private boolean cancelled;

        public ProjectRepositoryConnectionJob(IProject project, boolean disconnectOtherServers, ProjectRepositoryData projectData) {
            super(MessageFormat.format(Messages.getString("ProjectRepositoryManager.JobNameFormat"), project.getName()));
            this.lock = new Object();
            this.cancelled = false;
            this.project = project;
            this.disconnectOtherServers = disconnectOtherServers;
            this.projectData = projectData;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            BackgroundTask connectTask = new BackgroundTask(this.getName());
            TFSEclipseClientPlugin.getDefault().getServerManager().backgroundConnectionTaskStarted((IBackgroundTask)connectTask);
            try {
                ProjectConnectionManagerResult result = ProjectRepositoryManager.this.connectionManager.connect(this.project, this.disconnectOtherServers);
                Object object = this.lock;
                synchronized (object) {
                    if (this.cancelled) {
                        ProjectRepositoryManager.this.connectionCancelled(this.project, this.projectData, result.getRepository());
                    } else {
                        ProjectRepositoryManager.this.connectionFinished(this.project, this.projectData, result.getRepository());
                    }
                }
            }
            catch (Throwable e) {
                log.error((Object)MessageFormat.format("Failed to build connection for project {0}", this.project.getName()), e);
                ProjectRepositoryManager.this.connectionFinished(this.project, this.projectData, null);
            }
            finally {
                TFSEclipseClientPlugin.getDefault().getServerManager().backgroundConnectionTaskFinished((IBackgroundTask)connectTask);
            }
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancelConnection() {
            Object object = this.lock;
            synchronized (object) {
                this.cancelled = true;
            }
            super.cancel();
        }
    }

    private class ProjectManagerLicenseListener
    implements LicenseListener {
        private ProjectManagerLicenseListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void eulaAcceptanceChanged(boolean eulaAccepted) {
            Object object = ProjectRepositoryManager.this.licenseLock;
            synchronized (object) {
                ProjectRepositoryManager.this.licenseTested = false;
            }
            LicenseManager.getInstance().removeListener((LicenseListener)this);
        }
    }

    private static class ProjectRepositoryData {
        private TFSRepository repository = null;
        private ProjectRepositoryStatus status = ProjectRepositoryStatus.INITIALIZING;
        private ProjectRepositoryConnectionJob connectionJob = null;

        public void setRepository(TFSRepository repository) {
            Check.notNull((Object)repository, (String)"repository");
            this.repository = repository;
            this.status = ProjectRepositoryStatus.ONLINE;
            this.connectionJob = null;
        }

        public TFSRepository getRepository() {
            return this.repository;
        }

        public void setStatus(ProjectRepositoryStatus status) {
            Check.notNull((Object)((Object)status), (String)"status");
            Check.isTrue((status != ProjectRepositoryStatus.ONLINE ? 1 : 0) != 0, (String)"status != ONLINE");
            this.status = status;
            this.repository = null;
        }

        public ProjectRepositoryStatus getStatus() {
            return this.status;
        }

        public ProjectRepositoryConnectionJob getConnectionJob() {
            return this.connectionJob;
        }

        public void setConnectionJob(ProjectRepositoryConnectionJob connectionJob) {
            if (connectionJob != null) {
                Check.isTrue((this.status == ProjectRepositoryStatus.CONNECTING ? 1 : 0) != 0, (String)"status == CONNECTING");
                Check.isTrue((this.connectionJob == null ? 1 : 0) != 0, (String)"this.connectionJob == null");
            }
            this.connectionJob = connectionJob;
        }
    }
}

