/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.client.eclipse.refresh;

import com.microsoft.tfs.client.common.framework.command.CommandExecutor;
import com.microsoft.tfs.client.common.framework.command.ICommand;
import com.microsoft.tfs.client.common.repository.RepositoryManager;
import com.microsoft.tfs.client.common.repository.RepositoryManagerAdapter;
import com.microsoft.tfs.client.common.repository.RepositoryManagerEvent;
import com.microsoft.tfs.client.common.repository.RepositoryManagerListener;
import com.microsoft.tfs.client.common.repository.TFSRepository;
import com.microsoft.tfs.client.common.util.CoreAffectedResourceCollector;
import com.microsoft.tfs.client.eclipse.commands.eclipse.RefreshResourcesCommand;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceRefreshManager
extends CoreAffectedResourceCollector {
    private final Set<Thread> ignoreThreads = new HashSet<Thread>();

    public ResourceRefreshManager(RepositoryManager repositoryManager) {
        TFSRepository[] repositories = repositoryManager.getRepositoriesAndAddListener((RepositoryManagerListener)new RepositoryManagerAdapter(){

            public void onRepositoryAdded(RepositoryManagerEvent event) {
                ResourceRefreshManager.this.addRepository(event.getRepository());
            }

            public void onRepositoryRemoved(RepositoryManagerEvent event) {
                ResourceRefreshManager.this.removeRepository(event.getRepository());
            }
        });
        for (int i = 0; i < repositories.length; ++i) {
            this.addRepository(repositories[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startIgnoreThreadResourceRefreshEvents() {
        Thread t = Thread.currentThread();
        Set<Thread> set = this.ignoreThreads;
        synchronized (set) {
            this.ignoreThreads.add(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopIgnoreThreadResourceRefreshEvents() {
        Thread t = Thread.currentThread();
        Set<Thread> set = this.ignoreThreads;
        synchronized (set) {
            this.ignoreThreads.remove(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resourcesChanged(Set<IResource> resources) {
        Set<Thread> set = this.ignoreThreads;
        synchronized (set) {
            if (this.ignoreThreads.contains(Thread.currentThread())) {
                return;
            }
        }
        RefreshResourcesCommand refreshCommand = new RefreshResourcesCommand(resources.toArray(new IResource[resources.size()]));
        new CommandExecutor().execute((ICommand)refreshCommand);
    }
}

