/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.client.eclipse.repository;

import com.microsoft.tfs.client.common.repository.PendingChangeRepositoryMap;
import com.microsoft.tfs.client.common.repository.RepositoryMap;
import com.microsoft.tfs.client.common.repository.TFSRepository;
import com.microsoft.tfs.client.eclipse.resource.PluginResourceHelpers;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PendingChange;
import org.eclipse.core.resources.IResource;

public class ResourceRepositoryMap
extends RepositoryMap {
    public ResourceRepositoryMap() {
        super(IResource.class);
    }

    public TFSRepository getRepository(IResource resource) {
        return this.getRepositoryInternal(resource);
    }

    public IResource[] getResources(TFSRepository repository) {
        return (IResource[])this.getMappedObjectsInternal(repository);
    }

    public IResource[] getAllResources() {
        return (IResource[])this.getAllMappedObjectsInternal();
    }

    public ResourceRepositoryMap subMap(IResource[] subset) {
        return (ResourceRepositoryMap)this.subMapInternal(subset);
    }

    public void addMappings(TFSRepository repository, IResource[] resources) {
        this.addMappingsInternal(repository, resources);
    }

    public PendingChangeRepositoryMap getPendingChangesMap() {
        PendingChangeRepositoryMap resultMap = new PendingChangeRepositoryMap();
        TFSRepository[] repositories = this.getRepositories();
        for (int i = 0; i < repositories.length; ++i) {
            IResource[] resources = this.getResources(repositories[i]);
            for (int j = 0; j < resources.length; ++j) {
                PendingChange[] changesForResource = PluginResourceHelpers.pendingChangesForResource(resources[j], repositories[i]);
                resultMap.addMappings(repositories[i], changesForResource);
            }
        }
        return resultMap;
    }
}

