/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.client.eclipse.resource;

import com.microsoft.tfs.client.common.framework.resources.filter.ResourceFilter;
import com.microsoft.tfs.client.common.framework.resources.filter.ResourceFilterResult;
import com.microsoft.tfs.client.common.repository.TFSRepository;
import com.microsoft.tfs.client.eclipse.TFSEclipseClientPlugin;
import com.microsoft.tfs.client.eclipse.resource.PluginResourceHelpers;
import com.microsoft.tfs.client.eclipse.resource.RepositoryUnavailablePolicy;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ChangeType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PendingChange;
import com.microsoft.tfs.util.Check;
import org.eclipse.core.resources.IResource;

public class HasNoPendingChangeTypeFilter
extends ResourceFilter {
    private final ChangeType[] changeTypes;
    private final RepositoryUnavailablePolicy repositoryUnavailablePolicy;
    private final boolean matchChangesForChildResources;

    public HasNoPendingChangeTypeFilter(ChangeType[] changeTypes, RepositoryUnavailablePolicy repositoryUnavailablePolicy, boolean matchChangesForChildResources) {
        Check.notNull((Object)changeTypes, (String)"changeTypes");
        Check.notNull((Object)repositoryUnavailablePolicy, (String)"repositoryUnavailablePolicy");
        this.changeTypes = changeTypes;
        this.repositoryUnavailablePolicy = repositoryUnavailablePolicy;
        this.matchChangesForChildResources = matchChangesForChildResources;
    }

    public ResourceFilterResult filter(IResource resource, int flags) {
        TFSRepository repository = TFSEclipseClientPlugin.getDefault().getProjectManager().getRepository(resource.getProject());
        if (repository == null) {
            return this.repositoryUnavailablePolicy.acceptResourceWithNoRepository(resource) ? ACCEPT : REJECT;
        }
        PendingChange[] pendingChanges = PluginResourceHelpers.pendingChangesForResource(resource, repository, this.matchChangesForChildResources);
        for (int i = 0; i < pendingChanges.length; ++i) {
            for (int j = 0; j < this.changeTypes.length; ++j) {
                if (!pendingChanges[i].getChangeType().contains(this.changeTypes[j])) continue;
                return REJECT;
            }
        }
        return ACCEPT;
    }
}

