/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.client.eclipse.resource;

import com.microsoft.tfs.client.common.framework.resources.filter.ResourceFilter;
import com.microsoft.tfs.client.common.framework.resources.filter.ResourceFilterResult;
import com.microsoft.tfs.client.common.repository.TFSRepository;
import com.microsoft.tfs.client.eclipse.TFSEclipseClientPlugin;
import com.microsoft.tfs.client.eclipse.resource.PluginResourceHelpers;
import com.microsoft.tfs.client.eclipse.resource.RepositoryUnavailablePolicy;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PendingChange;
import com.microsoft.tfs.util.Check;
import org.eclipse.core.resources.IResource;

public class HasPendingChangeFilter
extends ResourceFilter {
    private final RepositoryUnavailablePolicy repositoryUnavailablePolicy;

    public HasPendingChangeFilter(RepositoryUnavailablePolicy repositoryUnavailablePolicy) {
        Check.notNull((Object)repositoryUnavailablePolicy, (String)"repositoryUnavailablePolicy");
        this.repositoryUnavailablePolicy = repositoryUnavailablePolicy;
    }

    public ResourceFilterResult filter(IResource resource, int flags) {
        TFSRepository repository = TFSEclipseClientPlugin.getDefault().getProjectManager().getRepository(resource.getProject());
        if (repository == null) {
            return this.repositoryUnavailablePolicy.acceptResourceWithNoRepository(resource) ? ACCEPT : REJECT;
        }
        PendingChange[] pendingChanges = PluginResourceHelpers.pendingChangesForResource(resource, repository, true);
        return pendingChanges != null && pendingChanges.length > 0 ? ACCEPT : REJECT;
    }
}

