/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.client.eclipse.resource;

import com.microsoft.tfs.client.common.framework.resources.filter.ResourceFilter;
import com.microsoft.tfs.client.common.framework.resources.filter.ResourceFilterResult;
import com.microsoft.tfs.client.common.repository.TFSRepository;
import com.microsoft.tfs.client.eclipse.TFSEclipseClientPlugin;
import com.microsoft.tfs.client.eclipse.resource.RepositoryUnavailablePolicy;
import com.microsoft.tfs.core.clients.versioncontrol.WorkspaceLocation;
import com.microsoft.tfs.util.Check;
import org.eclipse.core.resources.IResource;

public class InLocalWorkspaceFilter
extends ResourceFilter {
    private final RepositoryUnavailablePolicy repositoryUnavailablePolicy;

    public InLocalWorkspaceFilter(RepositoryUnavailablePolicy repositoryUnavailablePolicy) {
        Check.notNull((Object)repositoryUnavailablePolicy, (String)"repositoryUnavailablePolicy");
        this.repositoryUnavailablePolicy = repositoryUnavailablePolicy;
    }

    public ResourceFilterResult filter(IResource resource, int flags) {
        if (resource.getType() == 8) {
            return REJECT;
        }
        TFSRepository repository = TFSEclipseClientPlugin.getDefault().getProjectManager().getRepository(resource.getProject());
        if (repository == null) {
            return this.repositoryUnavailablePolicy.acceptResourceWithNoRepository(resource) ? ACCEPT : REJECT;
        }
        return repository.getWorkspace().getLocation() == WorkspaceLocation.LOCAL ? ACCEPT : REJECT;
    }
}

