/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.client.eclipse.resource;

import com.microsoft.tfs.client.common.framework.resources.filter.ResourceFilter;
import com.microsoft.tfs.client.common.framework.resources.filter.ResourceFilterResult;
import com.microsoft.tfs.client.common.repository.TFSRepository;
import com.microsoft.tfs.client.eclipse.TFSEclipseClientPlugin;
import com.microsoft.tfs.client.eclipse.resource.RepositoryUnavailablePolicy;
import com.microsoft.tfs.client.eclipse.resourcedata.ResourceDataManager;
import com.microsoft.tfs.core.exceptions.InputValidationException;
import com.microsoft.tfs.util.Check;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class InRepositoryFilter
extends ResourceFilter {
    private final RepositoryUnavailablePolicy repositoryUnavailablePolicy;

    public InRepositoryFilter(RepositoryUnavailablePolicy repositoryUnavailablePolicy) {
        Check.notNull((Object)repositoryUnavailablePolicy, (String)"repositoryUnavailablePolicy");
        this.repositoryUnavailablePolicy = repositoryUnavailablePolicy;
    }

    public ResourceFilterResult filter(IResource resource, int flags) {
        IProject project = resource.getProject();
        if (project == null) {
            return REJECT;
        }
        TFSRepository repository = TFSEclipseClientPlugin.getDefault().getProjectManager().getRepository(resource.getProject());
        if (repository == null) {
            return this.repositoryUnavailablePolicy.acceptResourceWithNoRepository(resource) ? ACCEPT : REJECT;
        }
        if (resource.getType() == 2 || resource.getType() == 4) {
            try {
                return repository.getWorkspace().isLocalPathMapped(resource.getLocation().toOSString()) ? ACCEPT : REJECT;
            }
            catch (InputValidationException e) {
                return REJECT;
            }
        }
        if (resource.getType() == 1) {
            ResourceDataManager resourceDataManager = TFSEclipseClientPlugin.getDefault().getResourceDataManager();
            return !resourceDataManager.hasCompletedRefresh(resource.getProject()) || resourceDataManager.hasResourceData(resource) ? ACCEPT : REJECT;
        }
        return REJECT;
    }
}

