/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.client.eclipse.resource;

import com.microsoft.tfs.client.common.framework.resources.filter.ResourceFilter;
import com.microsoft.tfs.client.common.framework.resources.filter.ResourceFilterResult;
import com.microsoft.tfs.client.common.repository.TFSRepository;
import com.microsoft.tfs.client.eclipse.TFSEclipseClientPlugin;
import com.microsoft.tfs.client.eclipse.resource.RepositoryUnavailablePolicy;
import com.microsoft.tfs.core.clients.versioncontrol.WorkspaceLocation;
import com.microsoft.tfs.core.clients.versioncontrol.localworkspace.BaselineFolder;
import com.microsoft.tfs.util.Check;
import org.eclipse.core.resources.IResource;

public class LocalWorkspaceBaselineFilter
extends ResourceFilter {
    private final RepositoryUnavailablePolicy repositoryUnavailablePolicy;

    public LocalWorkspaceBaselineFilter(RepositoryUnavailablePolicy repositoryUnavailablePolicy) {
        Check.notNull((Object)repositoryUnavailablePolicy, (String)"repositoryUnavailablePolicy");
        this.repositoryUnavailablePolicy = repositoryUnavailablePolicy;
    }

    public ResourceFilterResult filter(IResource resource, int flags) {
        if (resource.getType() == 8) {
            return ACCEPT;
        }
        TFSRepository repository = TFSEclipseClientPlugin.getDefault().getProjectManager().getRepository(resource.getProject());
        if (repository == null) {
            return this.repositoryUnavailablePolicy.acceptResourceWithNoRepository(resource) ? ACCEPT : REJECT;
        }
        if (repository.getWorkspace().getLocation() != WorkspaceLocation.LOCAL) {
            return ACCEPT;
        }
        IResource r = resource;
        while (r.getType() != 8) {
            if (r.getType() == 2 && BaselineFolder.isPotentialBaselineFolderName((String)r.getName())) {
                return REJECT_AND_REJECT_CHILDREN;
            }
            r = r.getParent();
        }
        return ACCEPT;
    }
}

