/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.client.eclipse.resource;

import com.microsoft.tfs.client.common.framework.resources.filter.CompositeResourceFilter;
import com.microsoft.tfs.client.common.framework.resources.filter.ResourceFilter;
import com.microsoft.tfs.client.common.framework.resources.filter.ResourceFilters;
import com.microsoft.tfs.client.eclipse.resource.HasNoPendingChangeTypeFilter;
import com.microsoft.tfs.client.eclipse.resource.HasPendingChangeFilter;
import com.microsoft.tfs.client.eclipse.resource.HasPendingChangeTypeFilter;
import com.microsoft.tfs.client.eclipse.resource.InLocalWorkspaceFilter;
import com.microsoft.tfs.client.eclipse.resource.InRepositoryFilter;
import com.microsoft.tfs.client.eclipse.resource.LocalWorkspaceBaselineFilter;
import com.microsoft.tfs.client.eclipse.resource.RemoteSyncInfoFilter;
import com.microsoft.tfs.client.eclipse.resource.RepositoryUnavailablePolicy;
import com.microsoft.tfs.client.eclipse.resource.ResourceExistsFilter;
import com.microsoft.tfs.client.eclipse.resource.TFSIgnoreResourcesFilter;
import com.microsoft.tfs.client.eclipse.resource.TPIgnoreResourcesFilter;
import com.microsoft.tfs.client.eclipse.resource.TeamIgnoredResourcesFilter;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ChangeType;

public abstract class PluginResourceFilters {
    private static final RepositoryUnavailablePolicy DEFAULT_RESOURCE_UNAVAILABLE_POLICY = RepositoryUnavailablePolicy.REJECT_RESOURCE;
    public static final ResourceFilter TPIGNORE_FILTER = new TPIgnoreResourcesFilter(RepositoryUnavailablePolicy.ACCEPT_RESOURCE);
    public static final ResourceFilter TPIGNORE_FILTER_INVERSE = ResourceFilters.getInverse((ResourceFilter)TPIGNORE_FILTER);
    public static final ResourceFilter TEAM_IGNORED_RESOURCES_FILTER = new TeamIgnoredResourcesFilter();
    public static final TFSIgnoreResourcesFilter TFS_IGNORE_FILTER = new TFSIgnoreResourcesFilter(RepositoryUnavailablePolicy.ACCEPT_RESOURCE);
    public static final ResourceFilter LOCAL_WORKSPACE_BASELINE_FILTER = new LocalWorkspaceBaselineFilter(RepositoryUnavailablePolicy.ACCEPT_RESOURCE);
    public static final ResourceFilter STANDARD_FILTER = PluginResourceFilters.createStandardFilter();
    public static final ResourceFilter IN_REPOSITORY_FILTER = new CompositeResourceFilter.Builder(CompositeResourceFilter.CompositeResourceFilterType.ALL_MUST_ACCEPT).addFilter(STANDARD_FILTER).addFilter((ResourceFilter)new InRepositoryFilter(DEFAULT_RESOURCE_UNAVAILABLE_POLICY)).build();
    public static final ResourceFilter IN_REPOSITORY_OR_HAS_BRANCH_PENDING_CHANGES_FILTER = new CompositeResourceFilter.Builder(CompositeResourceFilter.CompositeResourceFilterType.ONE_MUST_ACCEPT).addFilter(IN_REPOSITORY_FILTER).addFilter((ResourceFilter)new HasPendingChangeTypeFilter(new ChangeType[]{ChangeType.BRANCH}, DEFAULT_RESOURCE_UNAVAILABLE_POLICY, false)).build();
    public static final ResourceFilter HAS_PENDING_CHANGES_FILTER = new CompositeResourceFilter.Builder(CompositeResourceFilter.CompositeResourceFilterType.ALL_MUST_ACCEPT).addFilter(STANDARD_FILTER).addFilter((ResourceFilter)new HasPendingChangeFilter(DEFAULT_RESOURCE_UNAVAILABLE_POLICY)).build();
    public static final ResourceFilter HAS_LOCK_PENDING_CHANGES_FILTER = new CompositeResourceFilter.Builder(CompositeResourceFilter.CompositeResourceFilterType.ALL_MUST_ACCEPT).addFilter(STANDARD_FILTER).addFilter((ResourceFilter)new HasPendingChangeTypeFilter(new ChangeType[]{ChangeType.LOCK}, DEFAULT_RESOURCE_UNAVAILABLE_POLICY, false)).build();
    public static final ResourceFilter CAN_APPLY_LABEL_FILTER = new CompositeResourceFilter.Builder(CompositeResourceFilter.CompositeResourceFilterType.ALL_MUST_ACCEPT).addFilter(IN_REPOSITORY_FILTER).addFilter((ResourceFilter)new HasNoPendingChangeTypeFilter(new ChangeType[]{ChangeType.ADD}, DEFAULT_RESOURCE_UNAVAILABLE_POLICY, false)).build();
    public static final ResourceFilter CAN_CHECKOUT_FILTER = new CompositeResourceFilter.Builder(CompositeResourceFilter.CompositeResourceFilterType.ALL_MUST_ACCEPT).addFilter(IN_REPOSITORY_OR_HAS_BRANCH_PENDING_CHANGES_FILTER).addFilter((ResourceFilter)new HasNoPendingChangeTypeFilter(new ChangeType[]{ChangeType.ADD, ChangeType.EDIT}, DEFAULT_RESOURCE_UNAVAILABLE_POLICY, false)).addFilter((ResourceFilter)new ResourceExistsFilter()).build();
    public static final ResourceFilter SYNCHRONIZE_OR_IN_REPOSITORY_FILTER = new CompositeResourceFilter.Builder(CompositeResourceFilter.CompositeResourceFilterType.ONE_MUST_ACCEPT).addFilter(IN_REPOSITORY_FILTER).addFilter((ResourceFilter)new RemoteSyncInfoFilter()).build();
    public static final ResourceFilter HAS_PENDING_CHANGES_OR_IN_REPOSITORY_FILTER = new CompositeResourceFilter.Builder(CompositeResourceFilter.CompositeResourceFilterType.ONE_MUST_ACCEPT).addFilter(HAS_PENDING_CHANGES_FILTER).addFilter(IN_REPOSITORY_FILTER).build();
    public static final ResourceFilter IN_LOCAL_WORKSPACE_FILTER = new InLocalWorkspaceFilter(RepositoryUnavailablePolicy.REJECT_RESOURCE);
    public static final ResourceFilter IN_SERVER_WORKSPACE_FILTER = ResourceFilters.getInverse((ResourceFilter)IN_LOCAL_WORKSPACE_FILTER);

    private static ResourceFilter createStandardFilter() {
        CompositeResourceFilter.Builder builder = new CompositeResourceFilter.Builder(CompositeResourceFilter.CompositeResourceFilterType.ALL_MUST_ACCEPT);
        builder.addFilter(LOCAL_WORKSPACE_BASELINE_FILTER);
        builder.addFilter(TEAM_IGNORED_RESOURCES_FILTER);
        builder.addFilter(ResourceFilters.TEAM_PRIVATE_RESOURCES_FILTER);
        builder.addFilter(ResourceFilters.LINKED_RESOURCES_FILTER);
        builder.addFilter(TPIGNORE_FILTER);
        builder.addFilter((ResourceFilter)TFS_IGNORE_FILTER);
        return builder.build();
    }
}

