/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.client.eclipse.resource;

import com.microsoft.tfs.client.common.framework.resources.LocationUnavailablePolicy;
import com.microsoft.tfs.client.common.framework.resources.Resources;
import com.microsoft.tfs.client.common.repository.TFSRepository;
import com.microsoft.tfs.client.common.repository.cache.pendingchange.PendingChangeCache;
import com.microsoft.tfs.client.common.vc.TypedItemSpec;
import com.microsoft.tfs.client.eclipse.TFSEclipseClientPlugin;
import com.microsoft.tfs.client.eclipse.repository.ResourceRepositoryMap;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PendingChange;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RecursionType;
import com.microsoft.tfs.util.Check;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class PluginResourceHelpers {
    private static final Log log = LogFactory.getLog(PluginResourceHelpers.class);

    public static ResourceRepositoryMap mapResources(IResource[] resources) {
        HashMap<IProject, ArrayList<IResource>> projectsToResources = new HashMap<IProject, ArrayList<IResource>>();
        for (int i = 0; i < resources.length; ++i) {
            IProject project = resources[i].getProject();
            ArrayList<IResource> list = (ArrayList<IResource>)projectsToResources.get(project);
            if (list == null) {
                list = new ArrayList<IResource>();
                projectsToResources.put(project, list);
            }
            list.add(resources[i]);
        }
        IProject[] projects = projectsToResources.keySet().toArray(new IProject[projectsToResources.keySet().size()]);
        HashMap<TFSRepository, ArrayList<IProject>> repositoriesToProjects = new HashMap<TFSRepository, ArrayList<IProject>>();
        for (int i = 0; i < projects.length; ++i) {
            TFSRepository repository = TFSEclipseClientPlugin.getDefault().getProjectManager().getRepository(projects[i]);
            if (repository == null) {
                log.warn((Object)MessageFormat.format("No TFS Repository for project {0}", projects[i].getName()));
                continue;
            }
            ArrayList<IProject> list = (ArrayList<IProject>)repositoriesToProjects.get(repository);
            if (list == null) {
                list = new ArrayList<IProject>();
                repositoriesToProjects.put(repository, list);
            }
            list.add(projects[i]);
        }
        TFSRepository[] repositories = repositoriesToProjects.keySet().toArray(new TFSRepository[repositoriesToProjects.keySet().size()]);
        ResourceRepositoryMap resultMap = new ResourceRepositoryMap();
        for (int i = 0; i < repositories.length; ++i) {
            IProject[] projectsForRepository = ((List)repositoriesToProjects.get(repositories[i])).toArray(new IProject[0]);
            ArrayList resourcesForRepositoryList = new ArrayList();
            for (int j = 0; j < projectsForRepository.length; ++j) {
                resourcesForRepositoryList.addAll((Collection)projectsToResources.get(projectsForRepository[j]));
            }
            IResource[] resourcesForRepository = resourcesForRepositoryList.toArray(new IResource[resourcesForRepositoryList.size()]);
            resultMap.addMappings(repositories[i], resourcesForRepository);
        }
        return resultMap;
    }

    public static int countPendingChangesForResource(IResource resource, TFSRepository repository) {
        return PluginResourceHelpers.countPendingChangesForResource(resource, repository, true);
    }

    public static int countPendingChangesForResource(IResource resource, TFSRepository repository, boolean includeChildPendingChanges) {
        String location = Resources.getLocation((IResource)resource, (LocationUnavailablePolicy)LocationUnavailablePolicy.THROW);
        PendingChangeCache pendingChangesCache = repository.getPendingChangeCache();
        if (resource.getType() == 1 || !includeChildPendingChanges) {
            if (pendingChangesCache.getPendingChangeByLocalPath(location) != null) {
                return 1;
            }
            return 0;
        }
        return pendingChangesCache.getPendingChangesByLocalPathRecursive(location).length;
    }

    public static PendingChange[] pendingChangesForResource(IResource resource, TFSRepository repository) {
        return PluginResourceHelpers.pendingChangesForResource(resource, repository, true);
    }

    public static PendingChange[] pendingChangesForResource(IResource resource, TFSRepository repository, boolean includeChildPendingChanges) {
        String location = Resources.getLocation((IResource)resource, (LocationUnavailablePolicy)LocationUnavailablePolicy.THROW);
        PendingChangeCache pendingChangesCache = repository.getPendingChangeCache();
        if (resource.getType() == 1 || !includeChildPendingChanges) {
            PendingChange change = pendingChangesCache.getPendingChangeByLocalPath(location);
            if (change != null) {
                return new PendingChange[]{change};
            }
            return new PendingChange[0];
        }
        PendingChange[] changes = pendingChangesCache.getPendingChangesByLocalPathRecursive(location);
        return changes;
    }

    public static TypedItemSpec[] typedItemSpecsForResources(IResource[] resources, boolean recursiveIfAppropriate, LocationUnavailablePolicy locationUnavailablePolicy) {
        Check.notNull((Object)resources, (String)"resources");
        Check.notNull((Object)locationUnavailablePolicy, (String)"locationUnavailablePolicy");
        ArrayList<TypedItemSpec> itemSpecs = new ArrayList<TypedItemSpec>();
        for (int i = 0; i < resources.length; ++i) {
            TypedItemSpec itemSpec = PluginResourceHelpers.typedItemSpecForResource(resources[i], recursiveIfAppropriate, locationUnavailablePolicy);
            if (itemSpec == null) continue;
            itemSpecs.add(itemSpec);
        }
        return itemSpecs.toArray(new TypedItemSpec[itemSpecs.size()]);
    }

    public static TypedItemSpec typedItemSpecForResource(IResource resource, boolean recursiveIfAppropriate, LocationUnavailablePolicy locationUnavailablePolicy) {
        Check.notNull((Object)resource, (String)"resource");
        Check.notNull((Object)locationUnavailablePolicy, (String)"locationUnavailablePolicy");
        int type = resource.getType();
        if (type == 8) {
            throw new IllegalArgumentException("Can't create typed item spec for workspace root");
        }
        String location = Resources.getLocation((IResource)resource, (LocationUnavailablePolicy)locationUnavailablePolicy);
        if (location == null) {
            return null;
        }
        RecursionType recursionType = recursiveIfAppropriate && type != 1 ? RecursionType.FULL : RecursionType.NONE;
        return new TypedItemSpec(location, recursionType, type == 1 ? ItemType.FILE : ItemType.FOLDER);
    }
}

