/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.client.eclipse.resource;

import com.microsoft.tfs.client.common.framework.resources.filter.ResourceFilter;
import com.microsoft.tfs.client.common.framework.resources.filter.ResourceFilterResult;
import com.microsoft.tfs.client.eclipse.sync.SynchronizeSubscriber;
import com.microsoft.tfs.client.eclipse.sync.syncinfo.SynchronizeInfo;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IResource;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.synchronize.SyncInfo;

public class RemoteSyncInfoFilter
extends ResourceFilter {
    private static final Log log = LogFactory.getLog(RemoteSyncInfoFilter.class);

    public ResourceFilterResult filter(IResource resource, int flags) {
        SyncInfo syncInfo;
        try {
            syncInfo = SynchronizeSubscriber.getInstance().getSyncInfo(resource);
        }
        catch (TeamException e) {
            log.warn((Object)MessageFormat.format("Could not determine synchronization info for {0}", resource), (Throwable)e);
            return ResourceFilterResult.REJECT;
        }
        if (syncInfo != null && syncInfo instanceof SynchronizeInfo && ((SynchronizeInfo)syncInfo).getRemoteOperation() != null) {
            return ResourceFilterResult.ACCEPT;
        }
        return ResourceFilterResult.REJECT;
    }
}

