/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.client.eclipse.resource;

import java.text.MessageFormat;
import org.eclipse.core.resources.IResource;

public abstract class RepositoryUnavailablePolicy {
    public static final RepositoryUnavailablePolicy THROW = new Throw();
    public static final RepositoryUnavailablePolicy ACCEPT_RESOURCE = new Accept();
    public static final RepositoryUnavailablePolicy REJECT_RESOURCE = new Reject();

    private RepositoryUnavailablePolicy() {
    }

    public abstract boolean acceptResourceWithNoRepository(IResource var1);

    private static class Reject
    extends RepositoryUnavailablePolicy {
        private Reject() {
        }

        public boolean acceptResourceWithNoRepository(IResource resource) {
            return false;
        }
    }

    private static class Accept
    extends RepositoryUnavailablePolicy {
        private Accept() {
        }

        public boolean acceptResourceWithNoRepository(IResource resource) {
            return true;
        }
    }

    private static class Throw
    extends RepositoryUnavailablePolicy {
        private Throw() {
        }

        public boolean acceptResourceWithNoRepository(IResource resource) {
            throw new IllegalArgumentException(MessageFormat.format("Resource {0} does not have a repository", resource));
        }
    }
}

