/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.client.eclipse.resource;

import com.microsoft.tfs.client.common.framework.resources.filter.ResourceFilter;
import com.microsoft.tfs.client.common.framework.resources.filter.ResourceFilterResult;
import com.microsoft.tfs.client.common.repository.RepositoryManagerEvent;
import com.microsoft.tfs.client.common.repository.RepositoryManagerListener;
import com.microsoft.tfs.client.common.repository.TFSRepository;
import com.microsoft.tfs.client.common.repository.TFSRepositoryUpdatedListener;
import com.microsoft.tfs.client.eclipse.TFSEclipseClientPlugin;
import com.microsoft.tfs.client.eclipse.resource.RepositoryUnavailablePolicy;
import com.microsoft.tfs.core.clients.versioncontrol.WorkspaceLocation;
import com.microsoft.tfs.core.clients.versioncontrol.events.WorkspaceEvent;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.ItemNotMappedException;
import com.microsoft.tfs.core.clients.versioncontrol.localworkspace.LocalItemExclusionEvaluator;
import com.microsoft.tfs.core.clients.versioncontrol.localworkspace.LocalMetadataTableLock;
import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.WorkingFolder;
import com.microsoft.tfs.util.Check;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IResource;

public class TFSIgnoreResourcesFilter
extends ResourceFilter {
    private static final Log log = LogFactory.getLog(TFSIgnoreResourcesFilter.class);
    private final RepositoryUnavailablePolicy repositoryUnavailablePolicy;
    private volatile boolean repositoryManagerHooked;
    private final TFSRepositoryUpdatedListener repositoryUpdatedListener = new TFSRepositoryUpdatedListener(){

        public void onRepositoryUpdated() {
            TFSIgnoreResourcesFilter.this.evaluators.clear();
        }

        public void onGetCompletedEvent(WorkspaceEvent.WorkspaceEventSource source) {
        }

        public void onFolderContentChanged(int changesetID) {
            TFSIgnoreResourcesFilter.this.evaluators.clear();
        }

        public void onLocalWorkspaceScan(WorkspaceEvent.WorkspaceEventSource source) {
        }
    };
    private final Map<String, LocalItemExclusionEvaluator> evaluators = Collections.synchronizedMap(new TreeMap(String.CASE_INSENSITIVE_ORDER));

    public TFSIgnoreResourcesFilter(RepositoryUnavailablePolicy repositoryUnavailablePolicy) {
        Check.notNull((Object)repositoryUnavailablePolicy, (String)"repositoryUnavailablePolicy");
        this.repositoryUnavailablePolicy = repositoryUnavailablePolicy;
    }

    public ResourceFilterResult filter(IResource resource, int flags) {
        if (resource.getType() == 8) {
            return ACCEPT;
        }
        TFSRepository repository = TFSEclipseClientPlugin.getDefault().getProjectManager().getRepository(resource.getProject());
        if (repository == null) {
            return this.repositoryUnavailablePolicy.acceptResourceWithNoRepository(resource) ? ACCEPT : REJECT;
        }
        if (repository.getWorkspace().getLocation() != WorkspaceLocation.LOCAL) {
            return ACCEPT;
        }
        this.ensureRepositoryManagerHooked();
        String localPath = resource.getLocation().toOSString();
        WorkingFolder[] folders = null;
        while (folders == null) {
            try {
                folders = repository.getWorkspace().getFolders();
            }
            catch (LocalMetadataTableLock.LocalMetadataTableTimeoutException e) {
                log.info((Object)"Timeout reading working folders while decorating labels, retrying");
                log.debug((Object)"Label decoration timeout exception details", (Throwable)e);
            }
        }
        String mappingRoot = this.getWorkspaceRoot(localPath, folders);
        if (mappingRoot == null) {
            log.warn((Object)MessageFormat.format("No mapping root found for local item {0}, using default repository unavailable policy", localPath));
            return this.repositoryUnavailablePolicy.acceptResourceWithNoRepository(resource) ? ACCEPT : REJECT;
        }
        try {
            LocalItemExclusionEvaluator evaluator = this.evaluators.get(mappingRoot);
            if (evaluator == null) {
                evaluator = new LocalItemExclusionEvaluator(repository.getWorkspace(), mappingRoot);
                this.evaluators.put(mappingRoot, evaluator);
            }
            if (evaluator.isExcluded(localPath, resource.getType() == 2)) {
                return REJECT;
            }
        }
        catch (ItemNotMappedException e) {
            log.info((Object)MessageFormat.format("Error checking if resource {0} is excluded", resource), (Throwable)e);
        }
        return ACCEPT;
    }

    public void clearCachedEvaluators() {
        this.evaluators.clear();
    }

    private void ensureRepositoryManagerHooked() {
        if (this.repositoryManagerHooked) {
            return;
        }
        TFSEclipseClientPlugin plugin = TFSEclipseClientPlugin.getDefault();
        if (plugin == null) {
            return;
        }
        plugin.getRepositoryManager().addListener(new RepositoryManagerListener(){

            public void onRepositoryRemoved(RepositoryManagerEvent event) {
                TFSIgnoreResourcesFilter.this.evaluators.clear();
                event.getRepository().removeRepositoryUpdatedListener(TFSIgnoreResourcesFilter.this.repositoryUpdatedListener);
            }

            public void onRepositoryAdded(RepositoryManagerEvent event) {
                TFSIgnoreResourcesFilter.this.evaluators.clear();
                event.getRepository().addRepositoryUpdatedListener(TFSIgnoreResourcesFilter.this.repositoryUpdatedListener);
            }

            public void onDefaultRepositoryChanged(RepositoryManagerEvent event) {
            }
        });
        TFSRepository defaultRepository = plugin.getRepositoryManager().getDefaultRepository();
        if (defaultRepository != null) {
            defaultRepository.addRepositoryUpdatedListener(this.repositoryUpdatedListener);
        }
        this.repositoryManagerHooked = true;
    }

    private String getWorkspaceRoot(String localPath, WorkingFolder[] workingFolders) {
        for (String workspaceRoot : WorkingFolder.getWorkspaceRoots((WorkingFolder[])workingFolders)) {
            if (!LocalPath.isChild((String)workspaceRoot, (String)localPath)) continue;
            return workspaceRoot;
        }
        return null;
    }
}

