/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.client.eclipse.resource;

import com.microsoft.tfs.client.common.framework.resources.filter.ResourceFilter;
import com.microsoft.tfs.client.common.framework.resources.filter.ResourceFilterResult;
import com.microsoft.tfs.client.common.repository.TFSRepository;
import com.microsoft.tfs.client.eclipse.TFSEclipseClientPlugin;
import com.microsoft.tfs.client.eclipse.resource.RepositoryUnavailablePolicy;
import com.microsoft.tfs.client.eclipse.tpignore.TPIgnoreCache;
import com.microsoft.tfs.core.clients.versioncontrol.WorkspaceLocation;
import com.microsoft.tfs.util.Check;
import org.eclipse.core.resources.IResource;

public class TPIgnoreResourcesFilter
extends ResourceFilter {
    private final RepositoryUnavailablePolicy repositoryUnavailablePolicy;
    private final TPIgnoreCache ignorableResourcesCache;

    public TPIgnoreResourcesFilter(RepositoryUnavailablePolicy repositoryUnavailablePolicy) {
        Check.notNull((Object)repositoryUnavailablePolicy, (String)"repositoryUnavailablePolicy");
        this.repositoryUnavailablePolicy = repositoryUnavailablePolicy;
        this.ignorableResourcesCache = new TPIgnoreCache();
    }

    public ResourceFilterResult filter(IResource resource, int flags) {
        if (resource.getType() == 8) {
            return ACCEPT;
        }
        TFSRepository repository = TFSEclipseClientPlugin.getDefault().getProjectManager().getRepository(resource.getProject());
        if (repository == null) {
            return this.repositoryUnavailablePolicy.acceptResourceWithNoRepository(resource) ? ACCEPT : REJECT;
        }
        if (repository.getWorkspace().getLocation() != WorkspaceLocation.SERVER) {
            return ACCEPT;
        }
        return this.ignorableResourcesCache.matchesAnyPattern(resource) ? REJECT : ACCEPT;
    }

    public TPIgnoreCache getIgnorableResourcesCache() {
        return this.ignorableResourcesCache;
    }
}

