/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.client.eclipse.resourcechange;

import com.microsoft.tfs.client.common.framework.resources.filter.ResourceFilter;
import com.microsoft.tfs.client.common.framework.resources.filter.ResourceFilterResult;
import com.microsoft.tfs.client.common.repository.TFSRepository;
import com.microsoft.tfs.client.eclipse.TFSEclipseClientPlugin;
import com.microsoft.tfs.client.eclipse.resourcechange.TFSResourceChangeListener;
import com.microsoft.tfs.client.eclipse.resourcechange.TFSResourceChangeSet;
import com.microsoft.tfs.client.eclipse.util.TeamUtils;
import com.microsoft.tfs.core.clients.versioncontrol.WorkspaceLocation;
import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ChangeType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PendingChange;
import com.microsoft.tfs.core.util.CodePageMapping;
import com.microsoft.tfs.core.util.FileEncoding;
import java.io.File;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.team.core.Team;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeltaVisitor
implements IResourceDeltaVisitor {
    private static final Log log = LogFactory.getLog(TFSResourceChangeListener.class);
    private final ResourceFilter localWorkspaceBaselineFilter;
    private final ResourceFilter ignoreFilter;
    private final ResourceFilter inRepositoryFilter;
    private final IStatus status = Status.OK_STATUS;
    private final Set<String> filesToAddByLocalPath = new HashSet<String>();
    private final Map<TFSRepository, Set<PendingChange>> convertToEditPendingChanges = new HashMap<TFSRepository, Set<PendingChange>>();
    private final Map<TFSRepository, TFSResourceChangeSet> filesToAddByRepository = new HashMap<TFSRepository, TFSResourceChangeSet>();
    private final Map<TFSRepository, Set<String>> filesNeedingScan = new HashMap<TFSRepository, Set<String>>();
    private final Map<TFSRepository, Set<IFile>> filesNeedingResourceData = new HashMap<TFSRepository, Set<IFile>>();

    public DeltaVisitor(ResourceFilter localWorkspaceBaselineFilter, ResourceFilter ignoreFilter, ResourceFilter inRepositoryFilter) {
        this.localWorkspaceBaselineFilter = localWorkspaceBaselineFilter;
        this.ignoreFilter = ignoreFilter;
        this.inRepositoryFilter = inRepositoryFilter;
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        if (this.localWorkspaceBaselineFilter.filter(resource).isReject()) {
            resource.setTeamPrivateMember(true);
            return false;
        }
        ResourceFilterResult result = this.ignoreFilter.filter(resource, 1);
        if (result.isReject()) {
            return !result.isRejectChildren();
        }
        ResourceFilterResult inRepositoryResult = this.inRepositoryFilter.filter(resource, 1);
        if (inRepositoryResult.isAccept()) {
            return this.visitResourceInRepository(delta);
        }
        return this.visitResourceNotInRepository(delta);
    }

    private boolean visitResourceInRepository(IResourceDelta delta) {
        IResource resource = delta.getResource();
        if (resource.getType() != 1 || resource.getProject() == null) {
            return true;
        }
        if (delta.getKind() == 4 && delta.getFlags() == 131072) {
            return true;
        }
        IProject project = resource.getProject();
        TFSRepository repository = TFSEclipseClientPlugin.getDefault().getProjectManager().getRepository(project);
        String localPath = resource.getLocation().toOSString();
        if (repository != null && localPath != null) {
            this.getOrCreateFilesNeedingScanSet(repository).add(localPath);
            if (delta.getKind() == 4 && delta.getFlags() == 0x100000) {
                return true;
            }
            PendingChange pendingChange = repository.getPendingChangeCache().getPendingChangeByLocalPath(localPath);
            if (pendingChange != null) {
                if (new File(localPath).exists() && pendingChange.getChangeType().contains(ChangeType.DELETE)) {
                    this.getOrCreateConvertToEditPendingChangesSet(repository).add(pendingChange);
                    if (repository.getWorkspace().getLocation() == WorkspaceLocation.LOCAL) {
                        this.getOrCreateFilesNeedingScanSet(repository).add(localPath);
                    }
                    return true;
                }
                return true;
            }
            this.getOrCreateFilesNeedingResourceDataSet(repository).add((IFile)resource);
        }
        return true;
    }

    private boolean visitResourceNotInRepository(IResourceDelta delta) {
        IResource resource = delta.getResource();
        if (delta.getKind() != 1) {
            return delta.getKind() == 4 && resource.getType() != 1;
        }
        IProject project = resource.getProject();
        TFSRepository repository = TFSEclipseClientPlugin.getDefault().getProjectManager().getRepository(project);
        IFile originalFile = null;
        if ((delta.getFlags() & 0x1000) != 0 && TeamUtils.isConfiguredWith((IResource)(originalFile = ResourcesPlugin.getWorkspace().getRoot().getFile(delta.getMovedFromPath())), "com.microsoft.tfs.client.eclipse.TFSRepositoryProvider")) {
            String localPath;
            if (repository != null && repository.getWorkspace().getLocation() == WorkspaceLocation.LOCAL && (localPath = resource.getLocation().toOSString()) != null) {
                this.getOrCreateFilesNeedingScanSet(repository).add(localPath);
                return true;
            }
            return false;
        }
        if (resource.getType() == 1) {
            String localPath = resource.getLocation().toOSString();
            if (repository != null && localPath != null && !this.filesToAddByLocalPath.contains(localPath)) {
                PendingChange pendingChange = repository.getPendingChangeCache().getPendingChangeByLocalPath(localPath);
                ChangeType[] conflictingChangeTypes = new ChangeType[]{ChangeType.ADD, ChangeType.BRANCH, ChangeType.UNDELETE};
                if (pendingChange != null) {
                    for (int i = 0; i < conflictingChangeTypes.length; ++i) {
                        if (!pendingChange.getChangeType().contains(conflictingChangeTypes[i])) continue;
                        log.info((Object)MessageFormat.format("Ignoring add notification for {0} (already pended as {1})", resource, conflictingChangeTypes[i].toUIString(true, pendingChange)));
                        return true;
                    }
                    if (pendingChange != null && pendingChange.getChangeType().contains(ChangeType.RENAME) && LocalPath.equals((String)pendingChange.getLocalItem(), (String)localPath)) {
                        log.info((Object)MessageFormat.format("Ignoring add notification for {0} (already pended as target of rename)", resource));
                        return true;
                    }
                }
                if (originalFile != null) {
                    log.info((Object)MessageFormat.format("Rename detected from file {0} to {1} (source not managed by TFS, target will be added)", originalFile, resource));
                } else {
                    log.info((Object)MessageFormat.format("Detected new file {0}", resource));
                }
                this.getOrCreateFilesToAddSet(repository).add(localPath, DeltaVisitor.getEncodingForResource(resource), resource);
                this.filesToAddByLocalPath.add(localPath);
            }
        }
        return true;
    }

    public Map<TFSRepository, Set<PendingChange>> getConvertToEditPendingChangesSet() {
        return this.convertToEditPendingChanges;
    }

    public Map<TFSRepository, TFSResourceChangeSet> getFilesToAdd() {
        return this.filesToAddByRepository;
    }

    public Map<TFSRepository, Set<String>> getFilesNeedingScan() {
        return this.filesNeedingScan;
    }

    public Map<TFSRepository, Set<IFile>> getFilesNeedingResourceData() {
        return this.filesNeedingResourceData;
    }

    private Set<PendingChange> getOrCreateConvertToEditPendingChangesSet(TFSRepository repository) {
        Set<PendingChange> changesSet = this.convertToEditPendingChanges.get(repository);
        if (changesSet == null) {
            changesSet = new HashSet<PendingChange>();
            this.convertToEditPendingChanges.put(repository, changesSet);
        }
        return changesSet;
    }

    private TFSResourceChangeSet getOrCreateFilesToAddSet(TFSRepository repository) {
        TFSResourceChangeSet additionSet = this.filesToAddByRepository.get(repository);
        if (additionSet == null) {
            additionSet = new TFSResourceChangeSet();
            this.filesToAddByRepository.put(repository, additionSet);
        }
        return additionSet;
    }

    private Set<String> getOrCreateFilesNeedingScanSet(TFSRepository repository) {
        Set<String> scansForRepository = this.filesNeedingScan.get(repository);
        if (scansForRepository == null) {
            scansForRepository = new HashSet<String>();
            this.filesNeedingScan.put(repository, scansForRepository);
        }
        return scansForRepository;
    }

    private Set<IFile> getOrCreateFilesNeedingResourceDataSet(TFSRepository repository) {
        Set<IFile> filesForRepository = this.filesNeedingResourceData.get(repository);
        if (filesForRepository == null) {
            filesForRepository = new HashSet<IFile>();
            this.filesNeedingResourceData.put(repository, filesForRepository);
        }
        return filesForRepository;
    }

    public IStatus getStatus() {
        return this.status;
    }

    private static FileEncoding getEncodingForResource(IResource resource) {
        String encoding;
        if (resource.getType() != 1) {
            return null;
        }
        IFile file = (IFile)resource;
        int teamType = Team.getType((IStorage)file);
        if (teamType == 2) {
            return FileEncoding.BINARY;
        }
        try {
            encoding = file.getCharset();
        }
        catch (CoreException e) {
            encoding = ResourcesPlugin.getEncoding();
        }
        int codePage = CodePageMapping.getCodePage((String)encoding, (boolean)false);
        if (codePage == 0) {
            return null;
        }
        return new FileEncoding(codePage);
    }
}

