/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.client.eclipse.resourcechange;

import com.microsoft.tfs.client.common.commands.vc.AddCommand;
import com.microsoft.tfs.client.common.commands.vc.EditCommand;
import com.microsoft.tfs.client.common.commands.vc.QueryItemsCommand;
import com.microsoft.tfs.client.common.commands.vc.ScanLocalWorkspaceCommand;
import com.microsoft.tfs.client.common.commands.vc.UndoCommand;
import com.microsoft.tfs.client.common.framework.command.CommandExecutor;
import com.microsoft.tfs.client.common.framework.command.CommandList;
import com.microsoft.tfs.client.common.framework.command.ICommand;
import com.microsoft.tfs.client.common.framework.command.JobCommandExecutor;
import com.microsoft.tfs.client.common.framework.command.JobOptions;
import com.microsoft.tfs.client.common.framework.resources.command.ResourceChangingCommand;
import com.microsoft.tfs.client.common.framework.resources.filter.CompositeResourceFilter;
import com.microsoft.tfs.client.common.framework.resources.filter.ResourceFilter;
import com.microsoft.tfs.client.common.repository.TFSRepository;
import com.microsoft.tfs.client.eclipse.Messages;
import com.microsoft.tfs.client.eclipse.TFSEclipseClientPlugin;
import com.microsoft.tfs.client.eclipse.resource.ConfiguredTeamProviderFilter;
import com.microsoft.tfs.client.eclipse.resource.InRepositoryFilter;
import com.microsoft.tfs.client.eclipse.resource.PluginResourceFilters;
import com.microsoft.tfs.client.eclipse.resource.RepositoryUnavailablePolicy;
import com.microsoft.tfs.client.eclipse.resourcechange.DeltaVisitor;
import com.microsoft.tfs.client.eclipse.resourcechange.TFSResourceChangeSet;
import com.microsoft.tfs.client.eclipse.resourcechange.TFSResourceChangeStatusReporter;
import com.microsoft.tfs.client.eclipse.resourcedata.ResourceData;
import com.microsoft.tfs.client.eclipse.resourcedata.ResourceDataUpdate;
import com.microsoft.tfs.core.clients.versioncontrol.GetItemsOptions;
import com.microsoft.tfs.core.clients.versioncontrol.GetOptions;
import com.microsoft.tfs.core.clients.versioncontrol.PendChangesOptions;
import com.microsoft.tfs.core.clients.versioncontrol.WorkspaceLocation;
import com.microsoft.tfs.core.clients.versioncontrol.events.EventSource;
import com.microsoft.tfs.core.clients.versioncontrol.events.NonFatalErrorEvent;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.VersionControlException;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.DeletedState;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Failure;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Item;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemSet;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.LockLevel;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PathTranslation;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PendingChange;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RecursionType;
import com.microsoft.tfs.core.clients.versioncontrol.specs.ItemSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.VersionSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.WorkspaceVersionSpec;
import com.microsoft.tfs.core.util.FileEncoding;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.FileHelpers;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TFSResourceChangeListener
implements IResourceChangeListener {
    private static final Log log = LogFactory.getLog(TFSResourceChangeListener.class);
    private static final String STATUS_REPORTERS_EXTENSION_POINT_ID = "com.microsoft.tfs.client.eclipse.resourceChangeStatusReporters";
    private final Object statusReporterLock = new Object();
    private TFSResourceChangeStatusReporter[] statusReporters;
    private final ResourceFilter localWorkspaceBaselineFilter;
    private final ResourceFilter ignoreFilter;
    private final ResourceFilter inRepositoryFilter;
    private final Set<Thread> ignoreThreads = new HashSet<Thread>();

    public TFSResourceChangeListener() {
        this.localWorkspaceBaselineFilter = PluginResourceFilters.LOCAL_WORKSPACE_BASELINE_FILTER;
        CompositeResourceFilter.Builder builder = new CompositeResourceFilter.Builder(CompositeResourceFilter.CompositeResourceFilterType.ALL_MUST_ACCEPT);
        builder.addFilter((ResourceFilter)new ConfiguredTeamProviderFilter("com.microsoft.tfs.client.eclipse.TFSRepositoryProvider"));
        builder.addFilter(PluginResourceFilters.STANDARD_FILTER);
        this.ignoreFilter = builder.build();
        this.inRepositoryFilter = new InRepositoryFilter(RepositoryUnavailablePolicy.REJECT_RESOURCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startIgnoreThreadResourceChangeEvents() {
        Thread t = Thread.currentThread();
        Set<Thread> set = this.ignoreThreads;
        synchronized (set) {
            this.ignoreThreads.add(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopIgnoreThreadResourceChangeEvents() {
        Thread t = Thread.currentThread();
        Set<Thread> set = this.ignoreThreads;
        synchronized (set) {
            this.ignoreThreads.remove(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resourceChanged(IResourceChangeEvent event) {
        Thread t = Thread.currentThread();
        Set<Thread> set = this.ignoreThreads;
        synchronized (set) {
            if (this.ignoreThreads.contains(t)) {
                return;
            }
        }
        if (!TFSEclipseClientPlugin.getDefault().getProjectManager().isStarted()) {
            log.warn((Object)"Resource change event called before workbench has started, ignoring resource changes");
            return;
        }
        DeltaVisitor visitor = new DeltaVisitor(this.localWorkspaceBaselineFilter, this.ignoreFilter, this.inRepositoryFilter);
        try {
            event.getDelta().accept((IResourceDeltaVisitor)visitor);
        }
        catch (CoreException e) {
            TFSEclipseClientPlugin.getDefault().getLog().log(e.getStatus());
            return;
        }
        IStatus visitStatus = visitor.getStatus();
        if (!visitStatus.isOK()) {
            this.reportNonOKVisitorStatus(visitStatus);
        }
        Map<TFSRepository, Set<PendingChange>> convertToEditPendingChangesByRepository = visitor.getConvertToEditPendingChangesSet();
        for (Map.Entry<TFSRepository, Set<PendingChange>> convertToEditChangesForRepository : convertToEditPendingChangesByRepository.entrySet()) {
            TFSRepository repository = convertToEditChangesForRepository.getKey();
            Set<PendingChange> changesSet = convertToEditChangesForRepository.getValue();
            TFSResourceChangeStatus status = this.convertPendingChangesToEdit(repository, changesSet);
            this.reportConvertToEditStatus(status.getStatus(), status.getNonFatals());
        }
        Map<TFSRepository, TFSResourceChangeSet> filesToAddByRepository = visitor.getFilesToAdd();
        for (Map.Entry<TFSRepository, TFSResourceChangeSet> additionsForRepository : filesToAddByRepository.entrySet()) {
            TFSRepository repository = additionsForRepository.getKey();
            TFSResourceChangeSet additionSet = additionsForRepository.getValue();
            TFSResourceChangeStatus status = this.pendAdditions(repository, additionSet);
            this.reportAdditionStatus(status.getStatus(), status.getNonFatals());
        }
        Map<TFSRepository, Set<String>> filesNeedingScan = visitor.getFilesNeedingScan();
        for (Map.Entry<TFSRepository, Set<String>> scansForRepository : filesNeedingScan.entrySet()) {
            TFSRepository repository = scansForRepository.getKey();
            Set<String> localPaths = scansForRepository.getValue();
            TFSResourceChangeStatus status = this.scanItems(repository, localPaths);
            this.reportScanStatus(status.getStatus(), status.getNonFatals());
        }
        Map<TFSRepository, Set<IFile>> filesNeedingResourceData = visitor.getFilesNeedingResourceData();
        for (Map.Entry<TFSRepository, Set<IFile>> refreshesForRepository : filesNeedingResourceData.entrySet()) {
            TFSRepository repository = refreshesForRepository.getKey();
            Set<IFile> fileSet = refreshesForRepository.getValue();
            if (fileSet.size() == 0) continue;
            TFSEclipseClientPlugin.getDefault().getResourceDataManager().refreshAsync(repository, (IResource[])fileSet.toArray(new IFile[fileSet.size()]));
        }
    }

    private void reportNonOKVisitorStatus(IStatus status) {
        for (TFSResourceChangeStatusReporter reporter : this.getStatusReporters()) {
            reporter.reportNonOKVisitorStatus(status);
        }
    }

    private void reportConvertToEditStatus(IStatus status, NonFatalErrorEvent[] nonFatal) {
        for (TFSResourceChangeStatusReporter reporter : this.getStatusReporters()) {
            reporter.reportConvertToEditStatus(status, nonFatal);
        }
    }

    private void reportAdditionStatus(IStatus status, NonFatalErrorEvent[] nonFatal) {
        for (TFSResourceChangeStatusReporter reporter : this.getStatusReporters()) {
            reporter.reportAdditionStatus(status, nonFatal);
        }
    }

    private void reportScanStatus(IStatus status, NonFatalErrorEvent[] nonFatal) {
        for (TFSResourceChangeStatusReporter reporter : this.getStatusReporters()) {
            reporter.reportScanStatus(status, nonFatal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TFSResourceChangeStatus convertPendingChangesToEdit(TFSRepository repository, Set<PendingChange> pendingChanges) {
        Check.notNull((Object)repository, (String)"repository");
        Check.notNull(pendingChanges, (String)"pendingChanges");
        ArrayList<NonFatalErrorEvent> nonFatals = new ArrayList<NonFatalErrorEvent>();
        HashMap<PendingChange, File> tempFiles = new HashMap<PendingChange, File>();
        for (PendingChange change : pendingChanges) {
            File localFile = new File(change.getLocalItem());
            if (!localFile.exists()) continue;
            File tempFile = null;
            try {
                tempFile = File.createTempFile("convertToEdit-" + localFile.getName() + "-", ".tmp", localFile.getParentFile());
                tempFile.delete();
            }
            catch (IOException e) {
                log.error((Object)"Error creating temp file", (Throwable)e);
                nonFatals.add(new NonFatalErrorEvent(EventSource.newFromHere(), repository.getWorkspace(), (Throwable)new VersionControlException(MessageFormat.format(Messages.getString("TFSResourceChangeListener.ConvertToEditCouldNotCreateTemporaryFileErrorFormat"), tempFile, e.getLocalizedMessage(), localFile), (Throwable)e)));
                continue;
            }
            try {
                FileHelpers.rename((File)localFile, (File)tempFile);
            }
            catch (IOException e) {
                log.error((Object)"Error renaming to temp file", (Throwable)e);
                nonFatals.add(new NonFatalErrorEvent(EventSource.newFromHere(), repository.getWorkspace(), (Throwable)new VersionControlException(MessageFormat.format(Messages.getString("TFSResourceChangeListener.ConvertToEditCouldNotRenameToTempErrorFormat"), localFile, tempFile, e.getLocalizedMessage()), (Throwable)e)));
                tempFile.delete();
                continue;
            }
            tempFiles.put(change, tempFile);
        }
        if (tempFiles.size() == 0) {
            return new TFSResourceChangeStatus((IStatus)new Status(4, "com.microsoft.tfs.client.eclipse", Messages.getString("TFSResourceChangeListener.ConvertToEditAllRenamesFailedError")), nonFatals.toArray(new NonFatalErrorEvent[nonFatals.size()]));
        }
        IStatus status = null;
        try {
            ItemSpec[] specs = ItemSpec.fromStrings((String[])PendingChange.toLocalItems((PendingChange[])pendingChanges.toArray(new PendingChange[pendingChanges.size()])), (RecursionType)RecursionType.NONE);
            CommandList commands = new CommandList(Messages.getString("TFSResourceChangeListener.ConvertingPendingChangesCommandName"), Messages.getString("TFSResourceChangeListener.ConvertingPendingChangesCommandErrorText"));
            commands.setCancellable(false);
            commands.addCommand((ICommand)new UndoCommand(repository, specs, GetOptions.NO_DISK_UPDATE));
            if (repository.getWorkspace().getLocation() == WorkspaceLocation.SERVER) {
                commands.addCommand((ICommand)new EditCommand(repository, specs, LockLevel.UNCHANGED));
            }
            status = new CommandExecutor().execute((ICommand)commands);
            Object var11_12 = null;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            for (Map.Entry entry : tempFiles.entrySet()) {
                PendingChange change = (PendingChange)entry.getKey();
                File tempFile = (File)entry.getValue();
                File localFile = new File(change.getLocalItem());
                if (localFile.exists()) {
                    localFile.delete();
                }
                try {
                    FileHelpers.rename((File)tempFile, (File)localFile);
                }
                catch (IOException e) {
                    log.error((Object)"Error renaming from temp file", (Throwable)e);
                    MultiStatus multiStatus = new MultiStatus("com.microsoft.tfs.client.eclipse", 0, Messages.getString("TFSResourceChangeListener.ConvertToEditRenameFromTempMultiStatusError"), null);
                    if (status != null) {
                        multiStatus.add(status);
                    }
                    multiStatus.add((IStatus)new Status(4, "com.microsoft.tfs.client.eclipse", MessageFormat.format(Messages.getString("TFSResourceChangeListener.ConvertToEditRenameFromTempSingleItemErrorFormat"), tempFile, localFile), (Throwable)e));
                    status = multiStatus;
                }
            }
            throw throwable;
        }
        for (Map.Entry entry : tempFiles.entrySet()) {
            PendingChange change = (PendingChange)entry.getKey();
            File tempFile = (File)entry.getValue();
            File localFile = new File(change.getLocalItem());
            if (localFile.exists()) {
                localFile.delete();
            }
            try {
                FileHelpers.rename((File)tempFile, (File)localFile);
            }
            catch (IOException e) {
                log.error((Object)"Error renaming from temp file", (Throwable)e);
                MultiStatus multiStatus = new MultiStatus("com.microsoft.tfs.client.eclipse", 0, Messages.getString("TFSResourceChangeListener.ConvertToEditRenameFromTempMultiStatusError"), null);
                if (status != null) {
                    multiStatus.add(status);
                }
                multiStatus.add((IStatus)new Status(4, "com.microsoft.tfs.client.eclipse", MessageFormat.format(Messages.getString("TFSResourceChangeListener.ConvertToEditRenameFromTempSingleItemErrorFormat"), tempFile, localFile), (Throwable)e));
                status = multiStatus;
            }
        }
        return new TFSResourceChangeStatus(status, nonFatals.toArray(new NonFatalErrorEvent[nonFatals.size()]));
    }

    private TFSResourceChangeStatus pendAdditions(TFSRepository repository, TFSResourceChangeSet additionSet) {
        Check.notNull((Object)repository, (String)"repository");
        Check.notNull((Object)additionSet, (String)"additionSet");
        String[] localPaths = additionSet.getPathList().toArray(new String[additionSet.getPathList().size()]);
        HashMap<String, FileEncoding> encodingHints = new HashMap<String, FileEncoding>();
        for (int i = 0; i < localPaths.length; ++i) {
            encodingHints.put(localPaths[i], additionSet.getPathToEncodingMap().get(localPaths[i]));
        }
        AddCommand addCommand = new AddCommand(repository, localPaths, false, LockLevel.UNCHANGED, GetOptions.NONE, PendChangesOptions.NONE, encodingHints, null);
        addCommand.setIgnoreNonFatals(true);
        IStatus addStatus = new CommandExecutor().execute((ICommand)addCommand);
        if (!addStatus.isOK()) {
            return new TFSResourceChangeStatus(addStatus);
        }
        int expected = localPaths.length;
        int added = addCommand.getAddCount();
        NonFatalErrorEvent[] nonFatals = addCommand.getNonFatalErrors();
        if (added >= expected && nonFatals.length == 0) {
            return TFSResourceChangeStatus.OK_STATUS;
        }
        if (added == expected) {
            return new TFSResourceChangeStatus(Status.OK_STATUS, nonFatals);
        }
        HashMap<String, ArrayList<NonFatalErrorEvent>> nonFatalMap = new HashMap<String, ArrayList<NonFatalErrorEvent>>();
        ArrayList<ItemSpec> queryItems = new ArrayList<ItemSpec>();
        for (int i = 0; i < nonFatals.length; ++i) {
            ArrayList<NonFatalErrorEvent> nonFatalsForPath;
            Failure failure = nonFatals[i].getFailure();
            String serverPath = null;
            if (failure != null && failure.getCode() != null && failure.getCode().equals("ItemExistsException")) {
                PathTranslation translation;
                if (failure.getServerItem() != null) {
                    serverPath = failure.getServerItem();
                } else if (failure.getLocalItem() != null && (translation = repository.getWorkspace().translateLocalPathToServerPath(failure.getLocalItem())) != null) {
                    serverPath = translation.getTranslatedPath();
                }
                if (serverPath != null) {
                    queryItems.add(new ItemSpec(serverPath, RecursionType.NONE));
                }
            }
            if ((nonFatalsForPath = (ArrayList<NonFatalErrorEvent>)nonFatalMap.get(serverPath)) == null) {
                nonFatalsForPath = new ArrayList<NonFatalErrorEvent>();
                nonFatalMap.put(serverPath, nonFatalsForPath);
            }
            nonFatalsForPath.add(nonFatals[i]);
        }
        if (queryItems.size() == 0) {
            return new TFSResourceChangeStatus((IStatus)new Status(2, "com.microsoft.tfs.client.eclipse", Messages.getString("TFSResourceChangeListener.SomeFilesCouldNotBeAdded")), nonFatals);
        }
        QueryItemsCommand queryCommand = new QueryItemsCommand(repository, queryItems.toArray(new ItemSpec[queryItems.size()]), (VersionSpec)new WorkspaceVersionSpec(repository.getWorkspace()), DeletedState.NON_DELETED, ItemType.FILE, GetItemsOptions.NONE);
        IStatus queryStatus = new CommandExecutor().execute((ICommand)queryCommand);
        if (!queryStatus.isOK() || queryCommand.getItemSets().length != queryItems.size()) {
            return new TFSResourceChangeStatus((IStatus)new Status(2, "com.microsoft.tfs.client.eclipse", Messages.getString("TFSResourceChangeListener.SomeFilesCouldNotBeAdded")), nonFatals);
        }
        ItemSet[] itemSets = queryCommand.getItemSets();
        ArrayList<ResourceDataUpdate> resourceDataUpdates = new ArrayList<ResourceDataUpdate>();
        for (int i = 0; i < itemSets.length; ++i) {
            Item[] items = itemSets[i].getItems();
            if (items == null || items.length != 1) continue;
            String serverPath = items[0].getServerItem();
            String localPath = repository.getWorkspace().getMappedLocalPath(serverPath);
            if (localPath == null) continue;
            IResource resource = additionSet.getPathToResourceMap().get(localPath);
            nonFatalMap.remove(serverPath);
            --expected;
            if (resource == null) continue;
            resourceDataUpdates.add(new ResourceDataUpdate(resource, new ResourceData(serverPath, items[0].getChangeSetID())));
        }
        TFSEclipseClientPlugin.getDefault().getResourceDataManager().update(resourceDataUpdates.toArray(new ResourceDataUpdate[resourceDataUpdates.size()]));
        if (added == expected) {
            return TFSResourceChangeStatus.OK_STATUS;
        }
        ArrayList updatedNonFatals = new ArrayList();
        Iterator i = nonFatalMap.values().iterator();
        while (i.hasNext()) {
            updatedNonFatals.addAll((Collection)i.next());
        }
        return new TFSResourceChangeStatus((IStatus)new Status(2, "com.microsoft.tfs.client.eclipse", Messages.getString("TFSResourceChangeListener.SomeFilesCouldNotBeAdded")), updatedNonFatals.toArray(new NonFatalErrorEvent[updatedNonFatals.size()]));
    }

    private TFSResourceChangeStatus scanItems(TFSRepository repository, Set<String> localPaths) {
        Check.notNull((Object)repository, (String)"repository");
        Check.notNull(localPaths, (String)"localPaths");
        if (WorkspaceLocation.LOCAL.equals((Object)repository.getWorkspace().getLocation())) {
            ScanLocalWorkspaceCommand command = new ScanLocalWorkspaceCommand(repository, localPaths);
            new JobCommandExecutor(new JobOptions().setSystem(true)).execute((ICommand)new ResourceChangingCommand((ICommand)command));
        }
        return new TFSResourceChangeStatus(Status.OK_STATUS);
    }

    private TFSResourceChangeStatus pendEncodings(TFSRepository repository, TFSResourceChangeSet encodingSet) {
        Check.notNull((Object)repository, (String)"repository");
        Check.notNull((Object)encodingSet, (String)"encodingSet");
        List<String> pathList = encodingSet.getPathList();
        ItemSpec[] itemSpecs = new ItemSpec[pathList.size()];
        LockLevel[] lockLevels = new LockLevel[pathList.size()];
        FileEncoding[] encodings = new FileEncoding[pathList.size()];
        for (int i = 0; i < pathList.size(); ++i) {
            itemSpecs[i] = new ItemSpec(pathList.get(i), RecursionType.NONE);
            lockLevels[i] = LockLevel.UNCHANGED;
            encodings[i] = encodingSet.getPathToEncodingMap().get(pathList.get(i));
        }
        EditCommand editCommand = new EditCommand(repository, itemSpecs, lockLevels, encodings, GetOptions.NONE, PendChangesOptions.NONE, true);
        IStatus editStatus = new CommandExecutor().execute((ICommand)editCommand);
        return new TFSResourceChangeStatus(editStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final TFSResourceChangeStatusReporter[] getStatusReporters() {
        Object object = this.statusReporterLock;
        synchronized (object) {
            if (this.statusReporters == null) {
                ArrayList<TFSResourceChangeStatusReporter> reporterList = new ArrayList<TFSResourceChangeStatusReporter>();
                reporterList.add(new TFSResourceChangeLoggingStatusReporter());
                IExtensionRegistry registry = Platform.getExtensionRegistry();
                IExtensionPoint extensionPoint = registry.getExtensionPoint(STATUS_REPORTERS_EXTENSION_POINT_ID);
                IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
                for (int i = 0; i < elements.length; ++i) {
                    try {
                        TFSResourceChangeStatusReporter reporter = (TFSResourceChangeStatusReporter)elements[i].createExecutableExtension("class");
                        if (reporter == null) continue;
                        reporterList.add(reporter);
                        continue;
                    }
                    catch (CoreException e) {
                        log.warn((Object)MessageFormat.format("Could not create {0} class", STATUS_REPORTERS_EXTENSION_POINT_ID), (Throwable)e);
                    }
                }
                this.statusReporters = reporterList.toArray(new TFSResourceChangeStatusReporter[reporterList.size()]);
            }
            return this.statusReporters;
        }
    }

    private final class TFSResourceChangeLoggingStatusReporter
    implements TFSResourceChangeStatusReporter {
        private TFSResourceChangeLoggingStatusReporter() {
        }

        public void reportNonOKVisitorStatus(IStatus status) {
            String message = MessageFormat.format(Messages.getString("TFSResourceChangeListener.VisitorErrorMessageFormat"), status.getMessage());
            if (status.getSeverity() == 4) {
                log.error((Object)message, status.getException());
            } else if (status.getSeverity() == 2) {
                log.warn((Object)message, status.getException());
            } else {
                log.info((Object)message, status.getException());
            }
        }

        public void reportConvertToEditStatus(IStatus status, NonFatalErrorEvent[] nonFatals) {
            this.reportNonFatals(Messages.getString("TFSResourceChangeListener.ConvertToEditErrorMessageFormat"), nonFatals);
        }

        public void reportAdditionStatus(IStatus status, NonFatalErrorEvent[] nonFatals) {
            this.reportNonFatals(Messages.getString("TFSResourceChangeListener.AdditionErrorMessageFormat"), nonFatals);
        }

        public void reportScanStatus(IStatus status, NonFatalErrorEvent[] nonFatals) {
            this.reportNonFatals(Messages.getString("TFSResourceChangeListener.ScanningErrorMessageFormat"), nonFatals);
        }

        private void reportNonFatals(String messageFormat, NonFatalErrorEvent[] nonFatals) {
            if (nonFatals == null || nonFatals.length == 0) {
                return;
            }
            for (int i = 0; i < nonFatals.length; ++i) {
                log.warn((Object)MessageFormat.format(messageFormat, nonFatals[i].getMessage()));
            }
        }
    }

    private static final class TFSResourceChangeStatus {
        public static final TFSResourceChangeStatus OK_STATUS = new TFSResourceChangeStatus(Status.OK_STATUS);
        private final IStatus status;
        private final NonFatalErrorEvent[] nonFatals;

        public TFSResourceChangeStatus(IStatus status) {
            this(status, new NonFatalErrorEvent[0]);
        }

        public TFSResourceChangeStatus(NonFatalErrorEvent[] nonFatals) {
            this(Status.OK_STATUS, nonFatals);
        }

        public TFSResourceChangeStatus(IStatus status, NonFatalErrorEvent[] nonFatals) {
            Check.notNull((Object)status, (String)"status");
            Check.notNull((Object)nonFatals, (String)"nonFatals");
            this.status = status;
            this.nonFatals = nonFatals;
        }

        public IStatus getStatus() {
            return this.status;
        }

        public NonFatalErrorEvent[] getNonFatals() {
            return this.nonFatals;
        }
    }
}

