/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.client.eclipse.resourcedata;

import com.microsoft.tfs.client.common.framework.command.Command;
import com.microsoft.tfs.client.common.framework.command.CommandExecutor;
import com.microsoft.tfs.client.common.framework.command.ICommand;
import com.microsoft.tfs.client.common.framework.resources.command.ResourceChangingCommand;
import com.microsoft.tfs.client.eclipse.Messages;
import com.microsoft.tfs.client.eclipse.resourcedata.ResourceData;
import com.microsoft.tfs.client.eclipse.resourcedata.ResourceDataManager;
import com.microsoft.tfs.client.eclipse.resourcedata.ResourceDataUpdate;
import com.microsoft.tfs.util.Check;
import java.text.MessageFormat;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

class ApplyQueuedUpdatesJob
extends Job {
    private static final Log log = LogFactory.getLog(ApplyQueuedUpdatesJob.class);
    private final ResourceDataUpdate[] updates;
    private final ResourceDataManager resourceDataManager;

    public ApplyQueuedUpdatesJob(ResourceDataUpdate[] updates, ResourceDataManager resourceDataManager) {
        super(Messages.getString("ApplyQueuedUpdatesJob.JobName"));
        Check.notNull((Object)updates, (String)"updates");
        Check.notNull((Object)resourceDataManager, (String)"resourceDataManager");
        this.updates = updates;
        this.resourceDataManager = resourceDataManager;
    }

    protected IStatus run(final IProgressMonitor monitor) {
        if (this.updates.length == 0) {
            return Status.OK_STATUS;
        }
        final HashSet resourcesChanged = new HashSet();
        ResourceChangingCommand command = new ResourceChangingCommand((ICommand)new Command(){

            protected IStatus doRun(IProgressMonitor progressMonitor) throws Exception {
                monitor.beginTask("", ApplyQueuedUpdatesJob.this.updates.length + 2);
                HashSet<IProject> projectsChanged = new HashSet<IProject>();
                for (int i = 0; i < ApplyQueuedUpdatesJob.this.updates.length; ++i) {
                    IResource[] resources = ApplyQueuedUpdatesJob.this.updates[i].getResources();
                    ResourceData resourceData = ApplyQueuedUpdatesJob.this.updates[i].getResourceData();
                    for (int j = 0; j < resources.length; ++j) {
                        try {
                            monitor.subTask(resources[j].getLocation().toString());
                            ApplyQueuedUpdatesJob.this.resourceDataManager.setResourceDataInternal(resources[j], resourceData);
                            resourcesChanged.add(resources[j]);
                            if (resources[j].getType() != 4) continue;
                            projectsChanged.add((IProject)resources[j]);
                            continue;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    monitor.worked(1);
                }
                monitor.subTask(Messages.getString("ApplyQueuedUpdatesJob.MarkingProjectsRefreshed"));
                for (IProject project : projectsChanged) {
                    ApplyQueuedUpdatesJob.this.resourceDataManager.setCompletedRefresh(project);
                }
                monitor.worked(1);
                return Status.OK_STATUS;
            }

            public String getName() {
                return Messages.getString("ApplyQueuedUpdatesJob.SavingCommandText");
            }

            public String getErrorDescription() {
                return Messages.getString("ApplyQueuedUpdatesJob.SavingCommandDescription");
            }

            public String getLoggingDescription() {
                if (ApplyQueuedUpdatesJob.this.updates.length == 1 && ApplyQueuedUpdatesJob.this.updates[0].getResources().length == 1) {
                    return MessageFormat.format("Saving server item information for {0}", ApplyQueuedUpdatesJob.this.updates[0].getResources()[0]);
                }
                return MessageFormat.format("Saving server item information for {0} items", ApplyQueuedUpdatesJob.this.updates.length);
            }
        });
        CommandExecutor executor = new CommandExecutor(monitor);
        executor.execute((ICommand)command);
        monitor.subTask(Messages.getString("ApplyQueuedUpdatesJob.NotifyingListeners"));
        this.resourceDataManager.fireResourceDataChanged(resourcesChanged.toArray(new IResource[resourcesChanged.size()]));
        monitor.worked(1);
        monitor.done();
        return Status.OK_STATUS;
    }
}

