/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.client.eclipse.resourcedata;

import com.microsoft.tfs.client.common.framework.resources.ResourceType;
import com.microsoft.tfs.client.common.framework.resources.Resources;
import com.microsoft.tfs.client.common.repository.TFSRepository;
import com.microsoft.tfs.client.eclipse.TFSEclipseClientPlugin;
import com.microsoft.tfs.client.eclipse.resourcedata.LocalItemChangeData;
import com.microsoft.tfs.client.eclipse.resourcedata.ResourceDataManager;
import com.microsoft.tfs.client.eclipse.resourcedata.ResourceDataUpdate;
import com.microsoft.tfs.client.eclipse.util.TeamUtils;
import com.microsoft.tfs.core.clients.versioncontrol.OperationStatus;
import com.microsoft.tfs.core.clients.versioncontrol.WorkspaceLocation;
import com.microsoft.tfs.core.clients.versioncontrol.events.CheckinEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.CheckinListener;
import com.microsoft.tfs.core.clients.versioncontrol.events.ConflictResolvedEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.ConflictResolvedListener;
import com.microsoft.tfs.core.clients.versioncontrol.events.GetEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.GetListener;
import com.microsoft.tfs.core.clients.versioncontrol.events.NewPendingChangeListener;
import com.microsoft.tfs.core.clients.versioncontrol.events.OperationCompletedEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.OperationCompletedListener;
import com.microsoft.tfs.core.clients.versioncontrol.events.OperationStartedEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.OperationStartedListener;
import com.microsoft.tfs.core.clients.versioncontrol.events.PendingChangeEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.UndonePendingChangeListener;
import com.microsoft.tfs.core.clients.versioncontrol.events.WorkspaceUpdatedEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.WorkspaceUpdatedListener;
import com.microsoft.tfs.core.clients.versioncontrol.path.ServerPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ChangeType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Conflict;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.GetOperation;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PendingChange;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Resolution;
import com.microsoft.tfs.util.Check;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

class CoreEventsListener
implements OperationStartedListener,
CheckinListener,
GetListener,
OperationCompletedListener,
UndonePendingChangeListener,
NewPendingChangeListener,
ConflictResolvedListener,
WorkspaceUpdatedListener {
    private static final Log log = LogFactory.getLog(CoreEventsListener.class);
    private final List<LocalItemChangeData> queuedLocalItemChanges = Collections.synchronizedList(new ArrayList());
    private final ResourceDataManager manager;

    protected CoreEventsListener(ResourceDataManager manager) {
        Check.notNull((Object)manager, (String)"manager");
        this.manager = manager;
    }

    public void onConflictResolved(ConflictResolvedEvent e) {
        Conflict conflict = e.getConflict();
        Resolution resolution = conflict.getResolution();
        String localItem = conflict.getTargetLocalItem();
        String serverItem = null;
        ItemType itemType = null;
        int version = 0;
        if (resolution == Resolution.ACCEPT_YOURS || resolution == Resolution.ACCEPT_MERGE || resolution == Resolution.ACCEPT_YOURS_RENAME_THEIRS) {
            serverItem = conflict.getYourServerItem();
            itemType = conflict.getYourItemType();
            version = conflict.getTheirVersion();
        }
        if (localItem != null && serverItem != null && itemType != null) {
            this.queuedLocalItemChanges.add(new LocalItemChangeData(localItem, itemType, serverItem, version));
        }
        this.processQueuedLocalItems();
    }

    public void onNewPendingChange(PendingChangeEvent e) {
        PendingChange change = e.getPendingChange();
        if (change.getChangeType().contains(ChangeType.RENAME)) {
            if (change.getSourceLocalItem() != null) {
                this.queuedLocalItemChanges.add(0, new LocalItemChangeData(change.getSourceLocalItem(), change.getItemType(), change.getSourceServerItem(), 0));
            }
            this.queuedLocalItemChanges.add(new LocalItemChangeData(change.getLocalItem(), change.getItemType(), change.getServerItem(), change.getVersion()));
        } else if (change.getChangeType().contains(ChangeType.DELETE)) {
            this.queuedLocalItemChanges.add(new LocalItemChangeData(change.getLocalItem(), change.getItemType(), change.getServerItem(), 0));
        } else {
            this.queuedLocalItemChanges.add(new LocalItemChangeData(change.getLocalItem(), change.getItemType(), change.getServerItem(), change.getVersion()));
        }
    }

    public void onGet(GetEvent e) {
        GetOperation getOperation = e.getOperation();
        if (getOperation.hasConflict()) {
            return;
        }
        OperationStatus status = e.getStatus();
        if (status == OperationStatus.GETTING || status == OperationStatus.REPLACING) {
            String localPath = getOperation.getTargetLocalItem() != null ? getOperation.getTargetLocalItem() : getOperation.getCurrentLocalItem();
            this.queuedLocalItemChanges.add(new LocalItemChangeData(localPath, getOperation.getItemType(), getOperation.getTargetServerItem(), getOperation.getVersionServer()));
        } else if (status == OperationStatus.DELETING) {
            String localPath = getOperation.getTargetLocalItem() != null ? getOperation.getTargetLocalItem() : getOperation.getCurrentLocalItem();
            this.queuedLocalItemChanges.add(new LocalItemChangeData(localPath, getOperation.getItemType(), getOperation.getTargetServerItem(), 0));
        }
    }

    public void onUndonePendingChange(PendingChangeEvent e) {
        PendingChange undoneChange = e.getPendingChange();
        if (undoneChange.isLocalItemDelete()) {
            if (undoneChange.getLocalItem() != null) {
                this.queuedLocalItemChanges.add(new LocalItemChangeData(undoneChange.getLocalItem(), undoneChange.getItemType(), undoneChange.getServerItem(), 0));
            }
        } else if (undoneChange.getChangeType().contains(ChangeType.RENAME)) {
            if (undoneChange.getSourceLocalItem() != null) {
                this.queuedLocalItemChanges.add(0, new LocalItemChangeData(undoneChange.getSourceLocalItem(), undoneChange.getItemType(), undoneChange.getSourceServerItem(), 0));
            }
            if (undoneChange.getLocalItem() != null) {
                this.queuedLocalItemChanges.add(new LocalItemChangeData(undoneChange.getLocalItem(), undoneChange.getItemType(), undoneChange.getServerItem(), undoneChange.getVersion()));
            }
        } else {
            String localPath = undoneChange.getLocalItem() != null ? undoneChange.getLocalItem() : undoneChange.getSourceLocalItem();
            this.queuedLocalItemChanges.add(new LocalItemChangeData(localPath, undoneChange.getItemType(), undoneChange.getServerItem(), undoneChange.getVersion()));
        }
    }

    public void onCheckin(CheckinEvent e) {
        if (e.getChangesetID() == 0) {
            return;
        }
        PendingChange[] committedChanges = e.getCommittedChanges();
        PendingChange[] undoneChanges = e.getUndoneChanges();
        ArrayList<PendingChange> allChanges = new ArrayList<PendingChange>();
        allChanges.addAll(Arrays.asList(committedChanges));
        allChanges.addAll(Arrays.asList(undoneChanges));
        this.doInitialProjectsRefresh(TFSEclipseClientPlugin.getDefault().getRepositoryManager().getRepository(e.getWorkspace()), allChanges.toArray(new PendingChange[allChanges.size()]));
        for (int i = 0; i < committedChanges.length; ++i) {
            if (committedChanges[i].getSourceLocalItem() != null && !ServerPath.equals((String)committedChanges[i].getSourceLocalItem(), (String)committedChanges[i].getLocalItem())) {
                this.queuedLocalItemChanges.add(0, new LocalItemChangeData(committedChanges[i].getSourceLocalItem(), committedChanges[i].getItemType(), null, 0));
            }
            if (committedChanges[i].getLocalItem() == null) continue;
            int csId = committedChanges[i].getChangeType().containsAny(ChangeType.DELETE) ? 0 : e.getChangesetID();
            this.queuedLocalItemChanges.add(new LocalItemChangeData(committedChanges[i].getLocalItem(), committedChanges[i].getItemType(), committedChanges[i].getServerItem(), csId));
        }
        this.processQueuedLocalItems();
    }

    private void doInitialProjectsRefresh(TFSRepository repository, PendingChange[] changes) {
        if (repository == null || changes == null || changes.length == 0) {
            return;
        }
        HashSet<IProject> projectsNeedingRefresh = new HashSet<IProject>();
        for (int i = 0; i < changes.length; ++i) {
            PendingChange change = changes[i];
            ResourceType resourceType = change.getItemType() == ItemType.FILE ? ResourceType.FILE : ResourceType.CONTAINER;
            IResource resource = Resources.getResourceForLocation((String)change.getLocalItem(), (ResourceType)resourceType, (boolean)false);
            if (resource == null) {
                log.trace((Object)MessageFormat.format("Could not find a resource for initial project refresh (even inaccessible ones) for local path {0}, ignoring", change.getLocalItem()));
                continue;
            }
            IProject project = resource.getProject();
            if (this.manager.hasCompletedRefresh(project)) continue;
            projectsNeedingRefresh.add(project);
        }
        if (projectsNeedingRefresh.size() > 0) {
            this.manager.refreshAsync(repository, (IResource[])projectsNeedingRefresh.toArray(new IProject[projectsNeedingRefresh.size()]));
        }
    }

    public void onOperationStarted(OperationStartedEvent e) {
    }

    public void onOperationCompleted(OperationCompletedEvent event) {
        this.processQueuedLocalItems();
    }

    public void onWorkspaceUpdated(WorkspaceUpdatedEvent e) {
        TFSRepository repository;
        WorkspaceLocation newLocation = e.getWorkspace().getLocation();
        WorkspaceLocation oldLocation = e.getOriginalLocation();
        if (oldLocation != null && newLocation != oldLocation && (repository = TFSEclipseClientPlugin.getDefault().getRepositoryManager().getRepository(e.getWorkspace())) != null) {
            IProject[] projects = TFSEclipseClientPlugin.getDefault().getProjectManager().getProjectsForRepository(repository);
            if (newLocation == WorkspaceLocation.SERVER) {
                if (projects.length > 0) {
                    this.manager.refreshAsync(repository, (IResource[])projects);
                }
            } else if (newLocation == WorkspaceLocation.LOCAL) {
                for (IProject project : projects) {
                    try {
                        TeamUtils.markBaselineFoldersTeamPrivate((IResource)project);
                    }
                    catch (CoreException ex) {
                        log.warn((Object)"Error during share marking baseline folders as team private members", (Throwable)ex);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processQueuedLocalItems() {
        LocalItemChangeData[] changes;
        List<LocalItemChangeData> list = this.queuedLocalItemChanges;
        synchronized (list) {
            if (this.queuedLocalItemChanges.size() == 0) {
                return;
            }
            changes = this.queuedLocalItemChanges.toArray(new LocalItemChangeData[this.queuedLocalItemChanges.size()]);
            this.queuedLocalItemChanges.clear();
        }
        ArrayList<ResourceDataUpdate> resourceDataUpdates = new ArrayList<ResourceDataUpdate>();
        for (int i = 0; i < changes.length; ++i) {
            ResourceDataUpdate update;
            LocalItemChangeData localItemChange = changes[i];
            if (localItemChange == null || (update = localItemChange.createResourceDataUpdate()) == null) continue;
            resourceDataUpdates.add(update);
        }
        if (resourceDataUpdates.size() > 0) {
            this.manager.update(resourceDataUpdates.toArray(new ResourceDataUpdate[resourceDataUpdates.size()]));
        }
    }
}

