/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.client.eclipse.resourcedata;

import com.microsoft.tfs.client.common.framework.resources.ResourceType;
import com.microsoft.tfs.client.common.framework.resources.Resources;
import com.microsoft.tfs.client.eclipse.resourcedata.ResourceData;
import com.microsoft.tfs.client.eclipse.resourcedata.ResourceDataUpdate;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemType;
import com.microsoft.tfs.util.Check;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IResource;

class LocalItemChangeData {
    private static final Log log = LogFactory.getLog(LocalItemChangeData.class);
    private final String localItem;
    private final ItemType itemType;
    private final String serverItem;
    private final int version;

    protected LocalItemChangeData(String localItem, ItemType itemType, String serverItem, int version) {
        Check.notNull((Object)localItem, (String)"localItem");
        Check.notNull((Object)itemType, (String)"itemType");
        Check.isTrue((itemType != ItemType.ANY ? 1 : 0) != 0, (String)"ItemType.ANY is not allowed");
        this.localItem = localItem;
        this.itemType = itemType;
        this.serverItem = serverItem;
        this.version = version;
    }

    public String getLocalItem() {
        return this.localItem;
    }

    public ItemType getItemType() {
        return this.itemType;
    }

    public String getServerItem() {
        return this.serverItem;
    }

    public int getVersion() {
        return this.version;
    }

    public ResourceDataUpdate createResourceDataUpdate() {
        ResourceType resourceType = this.itemType == ItemType.FILE ? ResourceType.FILE : ResourceType.CONTAINER;
        IResource[] resources = Resources.getAllResourcesForLocation((String)this.getLocalItem(), (ResourceType)resourceType, (boolean)false);
        if (resources == null || resources.length == 0) {
            log.trace((Object)MessageFormat.format("Could not find a resource (even inaccessible ones) for local path {0}, ignoring", this.localItem));
            return null;
        }
        boolean notInServer = this.serverItem == null || this.version == 0;
        return new ResourceDataUpdate(resources, notInServer ? null : new ResourceData(this.serverItem, this.version));
    }
}

