/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.client.eclipse.resourcedata;

import com.microsoft.tfs.util.Check;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResourceData {
    private static final Log log = LogFactory.getLog(ResourceData.class);
    private final String serverItem;
    private final int changesetId;

    public ResourceData(String serverItem, int changesetId) {
        Check.notNull((Object)serverItem, (String)"serverItem");
        this.serverItem = serverItem;
        this.changesetId = changesetId;
    }

    public String getServerItem() {
        return this.serverItem;
    }

    public int getChangesetID() {
        return this.changesetId;
    }

    public String toString() {
        return MessageFormat.format("{0} {1}", this.serverItem, Integer.toString(this.changesetId));
    }

    public byte[] toByteArray() {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(os);
            dos.writeUTF(this.serverItem);
            dos.writeInt(this.changesetId);
            dos.close();
            return os.toByteArray();
        }
        catch (IOException e) {
            log.error((Object)"Error serializing", (Throwable)e);
            return null;
        }
    }

    public static ResourceData fromByteArray(byte[] value) {
        Check.notNull((Object)value, (String)"value");
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(value);
            DataInputStream dis = new DataInputStream(is);
            return new ResourceData(dis.readUTF(), dis.readInt());
        }
        catch (IOException e) {
            log.error((Object)"Error deserializing", (Throwable)e);
            return null;
        }
    }
}

