/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.client.eclipse.resourcedata;

import com.microsoft.tfs.client.common.repository.TFSRepository;
import com.microsoft.tfs.client.eclipse.Messages;
import com.microsoft.tfs.client.eclipse.TFSEclipseClientPlugin;
import com.microsoft.tfs.client.eclipse.resourcedata.ApplyQueuedUpdatesJob;
import com.microsoft.tfs.client.eclipse.resourcedata.CoreEventsListener;
import com.microsoft.tfs.client.eclipse.resourcedata.LocalItemChangeData;
import com.microsoft.tfs.client.eclipse.resourcedata.ResourceData;
import com.microsoft.tfs.client.eclipse.resourcedata.ResourceDataListener;
import com.microsoft.tfs.client.eclipse.resourcedata.ResourceDataUpdate;
import com.microsoft.tfs.core.clients.versioncontrol.GetItemsOptions;
import com.microsoft.tfs.core.clients.versioncontrol.WorkspaceLocation;
import com.microsoft.tfs.core.clients.versioncontrol.events.CheckinListener;
import com.microsoft.tfs.core.clients.versioncontrol.events.ConflictResolvedListener;
import com.microsoft.tfs.core.clients.versioncontrol.events.GetListener;
import com.microsoft.tfs.core.clients.versioncontrol.events.NewPendingChangeListener;
import com.microsoft.tfs.core.clients.versioncontrol.events.OperationCompletedListener;
import com.microsoft.tfs.core.clients.versioncontrol.events.OperationStartedListener;
import com.microsoft.tfs.core.clients.versioncontrol.events.UndonePendingChangeListener;
import com.microsoft.tfs.core.clients.versioncontrol.events.WorkspaceUpdatedListener;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.ServerPathFormatException;
import com.microsoft.tfs.core.clients.versioncontrol.localworkspace.LocalMetadataTableLock;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.DeletedState;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ExtendedItem;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Item;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemSet;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RecursionType;
import com.microsoft.tfs.core.clients.versioncontrol.specs.ItemSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.VersionSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.WorkspaceVersionSpec;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.listeners.SingleListenerFacade;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ISynchronizer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceDataManager {
    private static final Log log = LogFactory.getLog(ResourceDataManager.class);
    private static final QualifiedName SYNCHRONIZER_RESOURCE_DATA_PARTNER_QNAME = new QualifiedName("com.microsoft.tfs.client.eclipse", "resourceData");
    private static final QualifiedName PROJECT_HAS_DATA_PROPERTY_QNAME = new QualifiedName("com.microsoft.tfs.client.eclipse", "hasResourceData");
    private static final String PROJECT_HAS_DATA_PROPERTY_TRUTH_VALUE = "true";
    private static final int LOCAL_REFRESH_TRIES = 5;
    private final CoreEventsListener repositoryCoreEventsListener;
    private final Map<TFSRepository, Set<IProject>> repositoryToProjectSetMap = new HashMap<TFSRepository, Set<IProject>>();
    private final Object repositoryMapLock = new Object();
    protected final SingleListenerFacade resourceDataListeners = new SingleListenerFacade(ResourceDataListener.class);
    private final Set<IProject> projectsWithCompletedDataCache = Collections.synchronizedSet(new HashSet());
    private final ISynchronizer synchronizer;
    private final Object deferLock = new Object();
    private int deferCount = 0;
    private final Map<TFSRepository, Set<IResource>> deferMap = new HashMap<TFSRepository, Set<IResource>>();

    public ResourceDataManager(ISynchronizer synchronizer) {
        Check.notNull((Object)synchronizer, (String)"synchronizer");
        this.synchronizer = synchronizer;
        this.synchronizer.add(SYNCHRONIZER_RESOURCE_DATA_PARTNER_QNAME);
        this.repositoryCoreEventsListener = new CoreEventsListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deferAutomaticRefresh() {
        Object object = this.deferLock;
        synchronized (object) {
            ++this.deferCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void continueAutomaticRefresh() {
        Object object = this.deferLock;
        synchronized (object) {
            --this.deferCount;
            if (this.deferCount == 0) {
                Iterator<Map.Entry<TFSRepository, Set<IResource>>> i = this.deferMap.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry<TFSRepository, Set<IResource>> deferEntry = i.next();
                    IResource[] deferredResources = deferEntry.getValue().toArray(new IResource[deferEntry.getValue().size()]);
                    this.refreshAsyncInternal(deferEntry.getKey(), deferredResources);
                    i.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProject(TFSRepository repository, IProject project) {
        Check.notNull((Object)repository, (String)"repository");
        Check.notNull((Object)project, (String)"project");
        Object object = this.repositoryMapLock;
        synchronized (object) {
            this.hookRepositoryEvents(project, repository);
            if (!this.hasCompletedRefresh(project)) {
                this.refreshAsync(repository, (IResource[])new IProject[]{project});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProject(TFSRepository repository, IProject project) {
        Check.notNull((Object)repository, (String)"repository");
        Check.notNull((Object)project, (String)"project");
        Object object = this.repositoryMapLock;
        synchronized (object) {
            this.unhookRepositoryEvents(project, repository);
        }
        this.projectsWithCompletedDataCache.remove(project);
    }

    private void hookRepositoryEvents(IProject project, TFSRepository repository) {
        Set<Object> projectSet;
        if (!this.repositoryToProjectSetMap.containsKey(repository)) {
            projectSet = new HashSet();
            this.repositoryToProjectSetMap.put(repository, projectSet);
            repository.getWorkspace().getClient().getEventEngine().addOperationStartedListener((OperationStartedListener)this.repositoryCoreEventsListener);
            repository.getWorkspace().getClient().getEventEngine().addCheckinListener((CheckinListener)this.repositoryCoreEventsListener);
            repository.getWorkspace().getClient().getEventEngine().addGetListener((GetListener)this.repositoryCoreEventsListener);
            repository.getWorkspace().getClient().getEventEngine().addOperationCompletedListener((OperationCompletedListener)this.repositoryCoreEventsListener);
            repository.getWorkspace().getClient().getEventEngine().addNewPendingChangeListener((NewPendingChangeListener)this.repositoryCoreEventsListener);
            repository.getWorkspace().getClient().getEventEngine().addConflictResolvedListener((ConflictResolvedListener)this.repositoryCoreEventsListener);
            repository.getWorkspace().getClient().getEventEngine().addUndonePendingChangeListener((UndonePendingChangeListener)this.repositoryCoreEventsListener);
            repository.getWorkspace().getClient().getEventEngine().addWorkspaceUpdatedListener((WorkspaceUpdatedListener)this.repositoryCoreEventsListener);
        } else {
            projectSet = this.repositoryToProjectSetMap.get(repository);
        }
        projectSet.add(project);
    }

    private void unhookRepositoryEvents(IProject project, TFSRepository repository) {
        if (this.repositoryToProjectSetMap.containsKey(repository)) {
            Set<IProject> projectSet = this.repositoryToProjectSetMap.get(repository);
            Check.notNull(projectSet, (String)"projectSet");
            projectSet.remove(project);
            if (projectSet.isEmpty()) {
                repository.getWorkspace().getClient().getEventEngine().removeOperationStartedListener((OperationStartedListener)this.repositoryCoreEventsListener);
                repository.getWorkspace().getClient().getEventEngine().removeCheckinListener((CheckinListener)this.repositoryCoreEventsListener);
                repository.getWorkspace().getClient().getEventEngine().removeGetListener((GetListener)this.repositoryCoreEventsListener);
                repository.getWorkspace().getClient().getEventEngine().removeOperationCompletedListener((OperationCompletedListener)this.repositoryCoreEventsListener);
                repository.getWorkspace().getClient().getEventEngine().removeNewPendingChangeListener((NewPendingChangeListener)this.repositoryCoreEventsListener);
                repository.getWorkspace().getClient().getEventEngine().removeConflictResolvedListener((ConflictResolvedListener)this.repositoryCoreEventsListener);
                repository.getWorkspace().getClient().getEventEngine().removeUndonePendingChangeListener((UndonePendingChangeListener)this.repositoryCoreEventsListener);
                repository.getWorkspace().getClient().getEventEngine().removeWorkspaceUpdatedListener((WorkspaceUpdatedListener)this.repositoryCoreEventsListener);
                this.repositoryToProjectSetMap.remove(repository);
            }
        }
    }

    public boolean hasCompletedRefresh(IProject project) {
        if (this.projectsWithCompletedDataCache.contains(project)) {
            return true;
        }
        boolean hasData = false;
        try {
            hasData = PROJECT_HAS_DATA_PROPERTY_TRUTH_VALUE.equals(project.getPersistentProperty(PROJECT_HAS_DATA_PROPERTY_QNAME));
            if (hasData) {
                this.projectsWithCompletedDataCache.add(project);
            }
        }
        catch (CoreException e) {
            TFSEclipseClientPlugin.getDefault().getLog().log(e.getStatus());
        }
        return hasData;
    }

    protected void setCompletedRefresh(IProject project) {
        try {
            project.setPersistentProperty(PROJECT_HAS_DATA_PROPERTY_QNAME, PROJECT_HAS_DATA_PROPERTY_TRUTH_VALUE);
            this.projectsWithCompletedDataCache.add(project);
        }
        catch (CoreException e) {
            TFSEclipseClientPlugin.getDefault().getLog().log(e.getStatus());
        }
    }

    public boolean hasResourceData(IResource resource) {
        try {
            return this.synchronizer.getSyncInfo(SYNCHRONIZER_RESOURCE_DATA_PARTNER_QNAME, resource) != null;
        }
        catch (CoreException e) {
            log.debug((Object)MessageFormat.format("Could not test for existence of sync info for {0}", resource.getLocation().toOSString()), (Throwable)e);
            return false;
        }
    }

    public ResourceData getResourceData(IResource resource) {
        byte[] value = null;
        try {
            value = this.synchronizer.getSyncInfo(SYNCHRONIZER_RESOURCE_DATA_PARTNER_QNAME, resource);
        }
        catch (CoreException e) {
            log.debug((Object)MessageFormat.format("Could not load sync info for {0}", resource.getLocation().toOSString()), (Throwable)e);
        }
        if (value == null) {
            return null;
        }
        return ResourceData.fromByteArray(value);
    }

    void setResourceDataInternal(IResource resource, ResourceData resourceData) {
        block6: {
            block5: {
                Check.notNull((Object)resource, (String)"resource");
                try {
                    int depth = resource.getType() == 1 ? 0 : 2;
                    resource.refreshLocal(depth, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (Throwable t) {
                    if (!resource.exists()) break block5;
                    log.warn((Object)MessageFormat.format("Could not refresh resource {0}", resource.getLocation().toOSString()));
                }
            }
            try {
                if (log.isTraceEnabled()) {
                    log.trace((Object)MessageFormat.format("Set {0} = {1}", resource.toString(), resourceData == null ? "<null>" : resourceData.toString()));
                }
                this.synchronizer.setSyncInfo(SYNCHRONIZER_RESOURCE_DATA_PARTNER_QNAME, resource, resourceData != null ? resourceData.toByteArray() : null);
            }
            catch (Throwable t) {
                if (!resource.exists()) break block6;
                log.warn((Object)MessageFormat.format("Could not save sync info for resource {0}", resource.getLocation().toString()), t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshAsync(TFSRepository repository, IResource[] resources) {
        Object object = this.deferLock;
        synchronized (object) {
            if (this.deferCount > 0) {
                Set<IResource> deferredForRepository = this.deferMap.get(repository);
                if (deferredForRepository == null) {
                    deferredForRepository = new HashSet<IResource>();
                    this.deferMap.put(repository, deferredForRepository);
                }
                for (int i = 0; i < resources.length; ++i) {
                    deferredForRepository.add(resources[i]);
                }
            } else {
                this.refreshAsyncInternal(repository, resources);
            }
        }
    }

    private void refreshAsyncInternal(final TFSRepository repository, final IResource[] resources) {
        Check.notNull((Object)repository, (String)"repository");
        Check.notNull((Object)resources, (String)"resources");
        String label = resources.length == 1 ? MessageFormat.format(Messages.getString("ResourceDataManager.RefreshingServerItemInformationForFormat"), resources[0].getName()) : MessageFormat.format(Messages.getString("ResourceDataManager.RefreshingServerItemInformationForCountFormat"), resources.length);
        Job updateJob = new Job(label){

            protected IStatus run(IProgressMonitor monitor) {
                ResourceDataManager.this.refreshInternal(repository, resources);
                return Status.OK_STATUS;
            }
        };
        updateJob.schedule();
    }

    private void refreshInternal(TFSRepository repository, IResource[] resources) {
        Check.notNull((Object)repository, (String)"repository");
        Check.notNull((Object)resources, (String)"resources");
        ArrayList<ItemSpec> itemSpecList = new ArrayList<ItemSpec>();
        for (int resourceIndex = 0; resourceIndex < resources.length; ++resourceIndex) {
            Check.notNull((Object)resources[resourceIndex], (String)"resources[resourceIndex]");
            if (resources[resourceIndex].getLocation() == null) continue;
            RecursionType recursionType = resources[resourceIndex].getType() == 1 ? RecursionType.NONE : RecursionType.FULL;
            itemSpecList.add(new ItemSpec(resources[resourceIndex].getLocation().toOSString(), recursionType));
        }
        ItemSpec[] itemSpecs = itemSpecList.toArray(new ItemSpec[itemSpecList.size()]);
        List<ResourceDataUpdate> updates = repository.getWorkspace().getLocation().equals((Object)WorkspaceLocation.SERVER) ? this.getServerWorkspaceUpdates(repository, itemSpecs) : this.getLocalWorkspaceUpdates(repository, itemSpecs);
        if (updates.size() > 0) {
            this.update(updates.toArray(new ResourceDataUpdate[updates.size()]));
        }
    }

    private List<ResourceDataUpdate> getServerWorkspaceUpdates(TFSRepository repository, ItemSpec[] itemSpecs) {
        ArrayList<ResourceDataUpdate> updates = new ArrayList<ResourceDataUpdate>();
        if (itemSpecs.length == 1) {
            log.info((Object)MessageFormat.format("Refreshing server item information for {0}", itemSpecs[0].getItem()));
        } else {
            log.info((Object)MessageFormat.format("Refreshing server item information for {0} resources", itemSpecs.length));
        }
        ItemSet[] itemSets = repository.getVersionControlClient().getItems(itemSpecs, (VersionSpec)new WorkspaceVersionSpec(repository.getWorkspace()), DeletedState.NON_DELETED, ItemType.ANY, GetItemsOptions.UNSORTED);
        for (int setIndex = 0; setIndex < itemSets.length; ++setIndex) {
            Item[] items = itemSets[setIndex].getItems();
            for (int itemIndex = 0; itemIndex < items.length; ++itemIndex) {
                String localPath;
                String serverPath = items[itemIndex].getServerItem();
                try {
                    localPath = repository.getWorkspace().getMappedLocalPath(serverPath);
                }
                catch (ServerPathFormatException e) {
                    log.warn((Object)MessageFormat.format("Could not compute local path from mapped path {0}", serverPath), (Throwable)e);
                    continue;
                }
                if (localPath != null) {
                    ResourceDataUpdate update = new LocalItemChangeData(localPath, items[itemIndex].getItemType(), items[itemIndex].getServerItem(), items[itemIndex].getChangeSetID()).createResourceDataUpdate();
                    if (update == null) continue;
                    updates.add(update);
                    continue;
                }
                log.warn((Object)MessageFormat.format("The server path {0} is not mapped to any local path, cannot refresh!", serverPath));
            }
        }
        return updates;
    }

    private List<ResourceDataUpdate> getLocalWorkspaceUpdates(TFSRepository repository, ItemSpec[] itemSpecs) {
        ArrayList<ResourceDataUpdate> updates = new ArrayList<ResourceDataUpdate>();
        if (itemSpecs.length == 1) {
            log.info((Object)MessageFormat.format("Refreshing local workspace item information for {0}", itemSpecs[0].getItem()));
        } else {
            log.info((Object)MessageFormat.format("Refreshing local workspace item information for {0} resources", itemSpecs.length));
        }
        ExtendedItem[][] items = null;
        for (int i = 0; i < 5; ++i) {
            try {
                items = repository.getVersionControlClient().getExtendedItems(itemSpecs, DeletedState.NON_DELETED, ItemType.ANY, GetItemsOptions.LOCAL_ONLY);
                break;
            }
            catch (LocalMetadataTableLock.LocalMetadataTableTimeoutException e) {
                log.info((Object)"Timeout reading local workspace server item information for ResourceDataManager, retrying");
                log.debug((Object)"ResourceDataManager timeout exception details", (Throwable)e);
                continue;
            }
        }
        if (items != null) {
            ExtendedItem[][] arr$ = items;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                ExtendedItem[] itemSubArray;
                for (ExtendedItem item : itemSubArray = arr$[i$]) {
                    ResourceDataUpdate update = new LocalItemChangeData(item.getLocalItem(), item.getItemType(), item.getTargetServerItem(), item.getLocalVersion()).createResourceDataUpdate();
                    if (update == null) continue;
                    updates.add(update);
                }
            }
        }
        return updates;
    }

    public void update(ResourceDataUpdate[] updates) {
        if (updates.length == 0) {
            log.debug((Object)"0 updates given, not launching apply job");
            return;
        }
        ApplyQueuedUpdatesJob job = new ApplyQueuedUpdatesJob(updates, this);
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.schedule();
    }

    public void addListener(ResourceDataListener listener) {
        this.resourceDataListeners.addListener((Object)listener);
    }

    public void removeListener(ResourceDataListener listener) {
        this.resourceDataListeners.removeListener((Object)listener);
    }

    void fireResourceDataChanged(IResource[] changedResources) {
        ((ResourceDataListener)this.resourceDataListeners.getListener()).resourceDataChanged(changedResources);
    }
}

