/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.client.eclipse.sync;

import com.microsoft.tfs.client.common.codemarker.CodeMarker;
import com.microsoft.tfs.client.common.codemarker.CodeMarkerDispatch;
import com.microsoft.tfs.client.common.commands.vc.PreviewGetCommand;
import com.microsoft.tfs.client.common.repository.TFSRepository;
import com.microsoft.tfs.client.common.util.CoreAffectedResourceCollector;
import com.microsoft.tfs.client.eclipse.Messages;
import com.microsoft.tfs.client.eclipse.TFSEclipseClientPlugin;
import com.microsoft.tfs.client.eclipse.project.ProjectRepositoryManager;
import com.microsoft.tfs.client.eclipse.project.ProjectRepositoryStatus;
import com.microsoft.tfs.client.eclipse.sync.LocalResourceData;
import com.microsoft.tfs.client.eclipse.sync.SynchronizeComparator;
import com.microsoft.tfs.client.eclipse.sync.resourcestore.GetOperationResourceStore;
import com.microsoft.tfs.client.eclipse.sync.resourcestore.ResourceStore;
import com.microsoft.tfs.client.eclipse.sync.syncinfo.SynchronizeInfo;
import com.microsoft.tfs.client.eclipse.util.TeamUtils;
import com.microsoft.tfs.core.clients.versioncontrol.GetOptions;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.ServerPathFormatException;
import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ChangeType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.DeletedState;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.GetOperation;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.GetRequest;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Item;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemSet;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PendingChange;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RecursionType;
import com.microsoft.tfs.core.clients.versioncontrol.specs.ItemSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.LatestVersionSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.VersionSpec;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.tasks.CanceledException;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.TeamStatus;
import org.eclipse.team.core.subscribers.ISubscriberChangeEvent;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberChangeEvent;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.variants.IResourceVariantComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizeSubscriber
extends Subscriber {
    public static final CodeMarker CODEMARKER_SYNCH_COMPLETE = new CodeMarker("com.microsoft.tfs.client.eclipse.sync.SynchronizeSubscriber#SynchComplete");
    private static final Log log = LogFactory.getLog(SynchronizeSubscriber.class);
    private static final int PROJECT_REPOSITORY_STATUS_CODE = 1024;
    private final SynchronizeComparator comparator = new SynchronizeComparator();
    private final ResourceStore<LocalResourceData> localTree = new ResourceStore();
    private final GetOperationResourceStore remoteGetOperationTree = new GetOperationResourceStore();
    private static SynchronizeSubscriber instance;
    private final SynchronizeResourceRefresher resourceRefresher = new SynchronizeResourceRefresher();
    private final Object deferLock = new Object();
    private int deferCount = 0;
    private final List<IResource> deferRefreshes = new ArrayList<IResource>();

    private SynchronizeSubscriber() {
    }

    public static synchronized SynchronizeSubscriber getInstance() {
        if (instance == null) {
            instance = new SynchronizeSubscriber();
        }
        return instance;
    }

    public String getName() {
        return Messages.getString("SynchronizeSubscriber.Name");
    }

    public IResource[] roots() {
        IProject[] allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> configuredProjects = new ArrayList<IProject>();
        for (int i = 0; i < allProjects.length; ++i) {
            if (!allProjects[i].isOpen()) continue;
            try {
                String providerName = allProjects[i].getPersistentProperty(TeamUtils.PROVIDER_PROP_KEY);
                if (providerName == null || !providerName.equals("com.microsoft.tfs.client.eclipse.TFSRepositoryProvider")) continue;
                configuredProjects.add(allProjects[i]);
                continue;
            }
            catch (CoreException e) {
                log.warn((Object)MessageFormat.format("Could not determine provider for project {0}", allProjects[i].getName()), (Throwable)e);
            }
        }
        return (IResource[])configuredProjects.toArray(new IProject[configuredProjects.size()]);
    }

    public IResource[] members(IResource resource) throws TeamException {
        return new IResource[0];
    }

    public SyncInfo getSyncInfo(IResource resource) throws TeamException {
        if (resource == null || !this.isSupervised(resource)) {
            return null;
        }
        ProjectRepositoryStatus projectStatus = TFSEclipseClientPlugin.getDefault().getProjectManager().getProjectStatus(resource.getProject());
        TFSRepository repository = TFSEclipseClientPlugin.getDefault().getProjectManager().getRepository(resource.getProject());
        if (projectStatus == ProjectRepositoryStatus.CONNECTING) {
            throw new TeamException((IStatus)new Status(4, "com.microsoft.tfs.client.eclipse", 0, MessageFormat.format(Messages.getString("SynchronizeSubscriber.ProjectIsCurrentlyBeingConnectedWaitBeforeSynchronizingFormat"), resource.getProject()), null));
        }
        if (projectStatus == ProjectRepositoryStatus.OFFLINE) {
            throw new TeamException((IStatus)new Status(4, "com.microsoft.tfs.client.eclipse", 0, MessageFormat.format(Messages.getString("SynchronizeSubscriber.ProjectIsCurrentlyOfflineReturnOnlineBeforeSynchronizingFormat"), resource.getProject()), null));
        }
        if (repository == null) {
            throw new TeamException(Messages.getString("SynchronizeSubscriber.ResourceNotConnectedToTFS"));
        }
        if (!this.resourceRefresher.containsRepository(repository)) {
            this.resourceRefresher.addRepository(repository);
        }
        LocalResourceData localData = this.localTree.getOperation(resource);
        GetOperation remoteOperation = (GetOperation)this.remoteGetOperationTree.getOperation(resource);
        SynchronizeInfo syncInfo = new SynchronizeInfo(repository, resource, localData, remoteOperation, this.comparator);
        syncInfo.init();
        return syncInfo;
    }

    private void blockForConnection() throws TeamException {
        ProjectRepositoryManager projectManager = TFSEclipseClientPlugin.getDefault().getProjectManager();
        while (projectManager.isConnecting()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new TeamException(Messages.getString("SynchronizeSubscriber.CouldNotWaitForConnectionDueToInterruption"));
            }
        }
    }

    public boolean isSupervised(IResource resource) throws TeamException {
        this.blockForConnection();
        return TeamUtils.isConfiguredWith((IResource)resource.getProject(), "com.microsoft.tfs.client.eclipse.TFSRepositoryProvider");
    }

    public void refresh(IResource[] resources, int depth, IProgressMonitor monitor) throws TeamException {
        Check.notNull((Object)resources, (String)"resources");
        Check.notNull((Object)monitor, (String)"monitor");
        this.blockForConnection();
        if (monitor.isCanceled()) {
            return;
        }
        RecursionType recursionType = depth == 0 ? RecursionType.NONE : (depth == 1 ? RecursionType.ONE_LEVEL : RecursionType.FULL);
        try {
            IStatus status = this.refresh(resources, recursionType, monitor);
            if (!status.isOK() && status.getSeverity() == 8) {
                throw new TeamException(status);
            }
        }
        catch (CanceledException e) {
            // empty catch block
        }
        CodeMarkerDispatch.dispatch((CodeMarker)CODEMARKER_SYNCH_COMPLETE);
    }

    private IStatus refresh(IResource[] resources, RecursionType recursionType, IProgressMonitor monitor) {
        Check.notNull((Object)resources, (String)"resources");
        Check.notNull((Object)recursionType, (String)"recursionType");
        Check.notNull((Object)monitor, (String)"monitor");
        HashSet<IResource> changedResources = new HashSet<IResource>();
        ArrayList<IStatus> errors = new ArrayList<IStatus>();
        monitor.beginTask(Messages.getString("SynchronizeSubscriber.RefreshingTFSResources"), resources.length + 1);
        SubProgressMonitor pcMonitor = new SubProgressMonitor(monitor, 1);
        this.refreshPendingChanges(resources, (IProgressMonitor)pcMonitor);
        pcMonitor.done();
        for (int i = 0; i < resources.length; ++i) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            monitor.subTask(resources[i].getName());
            SubProgressMonitor resourceMonitor = new SubProgressMonitor(monitor, 1);
            IStatus status = this.refreshResource(resources[i], recursionType, changedResources, (IProgressMonitor)resourceMonitor);
            if (!status.isOK()) {
                errors.add(status);
            }
            resourceMonitor.done();
        }
        monitor.done();
        if (!changedResources.isEmpty()) {
            this.fireTeamResourceChange(changedResources);
        }
        if (!errors.isEmpty()) {
            if (errors.size() == resources.length) {
                int errorCode = -1;
                for (IStatus error : errors) {
                    if ((error.getCode() & 0x400) == 0) {
                        errorCode = -1;
                        break;
                    }
                    int thisErrorCode = error.getCode() & 0xFFFFFBFF;
                    if (errorCode < 0) {
                        errorCode = thisErrorCode;
                        continue;
                    }
                    if (thisErrorCode == errorCode) continue;
                    errorCode = -1;
                    break;
                }
                if (errorCode >= 0) {
                    String message = Messages.getString("SynchronizeSubscriber.ProjectsNotCurrentlyConnectedToTFS");
                    if (errorCode == ProjectRepositoryStatus.CONNECTING.getValue()) {
                        message = Messages.getString("SynchronizeSubscriber.ProjectsBeingConnectedToTFSWaitBeforeRefreshing");
                    } else if (errorCode == ProjectRepositoryStatus.OFFLINE.getValue()) {
                        message = Messages.getString("SynchronizeSubscriber.CurrentlyOfflinePleaseReturnOnlineBeforeRefreshing");
                    } else if (errorCode == ProjectRepositoryStatus.INITIALIZING.getValue()) {
                        message = Messages.getString("SynchronizeSubscriber.ProjectsNotConnectedToTFSOrHaveBeenPermanentlyDisconnected");
                    }
                    return new Status(4, "com.microsoft.tfs.client.eclipse", errorCode, message, null);
                }
            }
            IStatus[] status = errors.toArray(new IStatus[errors.size()]);
            return new MultiStatus("com.microsoft.tfs.client.eclipse", -3, status, Messages.getString("SynchronizeSubscriber.SomeResourcesCouldNotBeRefreshed"), null);
        }
        return Status.OK_STATUS;
    }

    private void refreshPendingChanges(IResource[] resources, IProgressMonitor monitor) {
        Check.notNull((Object)resources, (String)"resources");
        Check.notNull((Object)monitor, (String)"monitor");
        HashMap<TFSRepository, Boolean> repositoryMap = new HashMap<TFSRepository, Boolean>();
        monitor.beginTask(Messages.getString("SynchronizeSubscriber.RefreshingPendingChanges"), 1);
        ProjectRepositoryManager projectManager = TFSEclipseClientPlugin.getDefault().getProjectManager();
        for (int i = 0; i < resources.length; ++i) {
            TFSRepository repository = projectManager.getRepository(resources[i].getProject());
            if (repository == null || repositoryMap.containsKey(repository)) continue;
            repository.getPendingChangeCache().refresh();
            repositoryMap.put(repository, Boolean.TRUE);
        }
        monitor.worked(1);
    }

    private IStatus refreshResource(IResource resource, RecursionType recursionType, Collection<IResource> changedResources, IProgressMonitor monitor) {
        Check.notNull((Object)resource, (String)"resource");
        Check.notNull((Object)recursionType, (String)"recursionType");
        Check.notNull(changedResources, (String)"changedResources");
        log.info((Object)MessageFormat.format("Computing synchronization data for {0}", resource));
        monitor.beginTask(MessageFormat.format(Messages.getString("SynchronizeSubscriber.RefreshingResourceFormat"), resource.getName()), 2);
        ProjectRepositoryStatus projectStatus = TFSEclipseClientPlugin.getDefault().getProjectManager().getProjectStatus(resource.getProject());
        if (projectStatus == ProjectRepositoryStatus.CONNECTING) {
            return new Status(4, "com.microsoft.tfs.client.eclipse", 0x400 | projectStatus.getValue(), MessageFormat.format(Messages.getString("SynchronizeSubscriber.ProjectIsCurrentlyBeingConnectedCannotRefreshUntilCompleteFormat"), resource.getProject().getName()), null);
        }
        if (projectStatus == ProjectRepositoryStatus.OFFLINE) {
            return new Status(4, "com.microsoft.tfs.client.eclipse", 0x400 | projectStatus.getValue(), MessageFormat.format(Messages.getString("SynchronizeSubscriber.ProjectOfflineCannotRefreshFormat"), resource.getProject().getName()), null);
        }
        if (projectStatus == ProjectRepositoryStatus.INITIALIZING) {
            return new Status(4, "com.microsoft.tfs.client.eclipse", 0x400 | projectStatus.getValue(), MessageFormat.format(Messages.getString("SynchronizeSubscriber.ProjectNotConnectedToTFSOrHaveBeenPermanentlyDisconnectedFormat"), resource.getProject().getName()), null);
        }
        TFSRepository repository = TFSEclipseClientPlugin.getDefault().getProjectManager().getRepository(resource.getProject());
        if (repository == null) {
            return new Status(4, "com.microsoft.tfs.client.eclipse", -3, MessageFormat.format(Messages.getString("SynchronizeSubscriber.CouldNotDetermineRepositoryForResourceFormat"), resource), null);
        }
        SubProgressMonitor localMonitor = new SubProgressMonitor(monitor, 1);
        SubProgressMonitor remoteMonitor = new SubProgressMonitor(monitor, 1);
        IStatus localStatus = this.refreshLocalResource(repository, resource, recursionType, changedResources, (IProgressMonitor)localMonitor);
        IStatus remoteStatus = this.refreshRemoteResource(repository, resource, recursionType, changedResources, (IProgressMonitor)remoteMonitor);
        monitor.done();
        if (!localStatus.isOK()) {
            return localStatus;
        }
        if (!remoteStatus.isOK()) {
            return remoteStatus;
        }
        return Status.OK_STATUS;
    }

    private IStatus refreshLocalResource(TFSRepository repository, IResource resource, RecursionType recursionType, Collection<IResource> changedResources, IProgressMonitor monitor) {
        Check.notNull((Object)repository, (String)"repository");
        Check.notNull((Object)resource, (String)"resource");
        Check.notNull((Object)recursionType, (String)"recursionType");
        Check.notNull(changedResources, (String)"changedResources");
        monitor.beginTask(MessageFormat.format(Messages.getString("SynchronizeSubscriber.RefreshingResourceLocalChangesFormat"), resource.getName()), 1);
        changedResources.addAll(this.localTree.removeOperation(resource));
        PendingChange[] pendingChanges = repository.getPendingChangeCache().getPendingChanges();
        ArrayList<LocalResourceData> needsItemQuery = new ArrayList<LocalResourceData>();
        for (int i = 0; i < pendingChanges.length; ++i) {
            IResource[] affectedResources;
            if (!this.isAffected(repository, resource, pendingChanges[i]) || (affectedResources = this.getAffectedResources(repository, resource, pendingChanges[i], recursionType)).length == 0) continue;
            LocalResourceData resourceData = new LocalResourceData(pendingChanges[i]);
            if (pendingChanges[i].getChangeType().contains(ChangeType.DELETE) && pendingChanges[i].getServerItem() != null) {
                needsItemQuery.add(resourceData);
            }
            for (int j = 0; j < affectedResources.length; ++j) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)MessageFormat.format("Resource {0} is affected by pending change of type {1}", affectedResources[j], pendingChanges[i].getChangeType().toUIString(true, pendingChanges[i])));
                }
                this.localTree.addOperation(affectedResources[j], resourceData);
                changedResources.add(affectedResources[j]);
            }
        }
        if (needsItemQuery.size() > 0) {
            ItemSpec[] itemSpecs = new ItemSpec[needsItemQuery.size()];
            for (int i = 0; i < needsItemQuery.size(); ++i) {
                itemSpecs[i] = new ItemSpec(((LocalResourceData)needsItemQuery.get(i)).getPendingChange().getServerItem(), RecursionType.NONE);
            }
            ItemSet[] itemSet = repository.getWorkspace().getClient().getItems(itemSpecs, (VersionSpec)LatestVersionSpec.INSTANCE, DeletedState.ANY, ItemType.FILE, true);
            if (itemSet.length != needsItemQuery.size()) {
                log.warn((Object)MessageFormat.format("Could not query items: requested data on {0} items, received data for {1}", Integer.toString(needsItemQuery.size()), Integer.toString(itemSet.length)));
            } else {
                for (int i = 0; i < needsItemQuery.size(); ++i) {
                    LocalResourceData resourceData = (LocalResourceData)needsItemQuery.get(i);
                    Item[] items = itemSet[i].getItems();
                    if (items.length != 1 || items[0] == null || items[0].getChangeSetID() <= resourceData.getPendingChange().getVersion()) continue;
                    ((LocalResourceData)needsItemQuery.get(i)).setItem(items[0]);
                }
            }
        }
        monitor.worked(1);
        monitor.done();
        return Status.OK_STATUS;
    }

    private boolean isAffected(TFSRepository repository, IResource resource, PendingChange pendingChange) {
        String pendingChangeLocalPath;
        String localPath = resource.getLocation().toOSString();
        if (pendingChange.getSourceLocalItem() != null && LocalPath.isChild((String)localPath, (String)pendingChange.getSourceLocalItem())) {
            return true;
        }
        if (pendingChange.getSourceServerItem() != null && (pendingChangeLocalPath = repository.getWorkspace().getMappedLocalPath(pendingChange.getSourceServerItem())) != null && LocalPath.isChild((String)localPath, (String)pendingChangeLocalPath)) {
            return true;
        }
        if (pendingChange.getLocalItem() != null && LocalPath.isChild((String)localPath, (String)pendingChange.getLocalItem())) {
            return true;
        }
        return pendingChange.getServerItem() != null && (pendingChangeLocalPath = repository.getWorkspace().getMappedLocalPath(pendingChange.getServerItem())) != null && LocalPath.isChild((String)localPath, (String)pendingChangeLocalPath);
    }

    private IResource[] getAffectedResources(TFSRepository repository, IResource resource, PendingChange pendingChange, RecursionType recursionType) {
        Check.notNull((Object)repository, (String)"repository");
        Check.notNull((Object)resource, (String)"resource");
        Check.notNull((Object)pendingChange, (String)"pendingChange");
        Check.notNull((Object)recursionType, (String)"recursionType");
        ArrayList<String> serverPathList = new ArrayList<String>();
        List<String> localPathList = new ArrayList<String>();
        ArrayList<IFile> resourceList = new ArrayList<IFile>();
        String resourcePath = resource.getLocation().toOSString();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        if (!pendingChange.getChangeType().contains(ChangeType.BRANCH) && pendingChange.getSourceLocalItem() != null) {
            localPathList.add(pendingChange.getSourceLocalItem());
        }
        if (pendingChange.getLocalItem() != null) {
            localPathList.add(pendingChange.getLocalItem());
        }
        if (!pendingChange.getChangeType().contains(ChangeType.BRANCH) && pendingChange.getSourceServerItem() != null) {
            serverPathList.add(pendingChange.getSourceServerItem());
        }
        if (pendingChange.getServerItem() != null) {
            serverPathList.add(pendingChange.getServerItem());
        }
        for (String serverPath : serverPathList) {
            String mappedPath = null;
            try {
                mappedPath = repository.getWorkspace().getMappedLocalPath(serverPath);
            }
            catch (ServerPathFormatException e) {
                // empty catch block
            }
            if (mappedPath == null) continue;
            localPathList.add(LocalPath.canonicalize((String)LocalPath.tfsToNative((String)mappedPath)));
        }
        localPathList = this.getUniquePaths(localPathList);
        for (String localPath : localPathList) {
            Object localResource;
            if (!this.isAffected(resourcePath, localPath, recursionType) || (localResource = pendingChange.getItemType() == ItemType.FILE ? workspaceRoot.getFileForLocation((IPath)new Path(localPath)) : workspaceRoot.getContainerForLocation((IPath)new Path(localPath))) == null || resourceList.contains(localResource)) continue;
            resourceList.add((IFile)localResource);
        }
        return resourceList.toArray(new IResource[resourceList.size()]);
    }

    private boolean isAffected(String resourcePath, String changed, RecursionType recursionType) {
        if (recursionType == RecursionType.FULL && LocalPath.isChild((String)resourcePath, (String)changed)) {
            return true;
        }
        if (recursionType == RecursionType.NONE && LocalPath.equals((String)resourcePath, (String)changed)) {
            return true;
        }
        return recursionType == RecursionType.ONE_LEVEL && (LocalPath.equals((String)resourcePath, (String)changed) || LocalPath.equals((String)resourcePath, (String)LocalPath.getDirectory((String)changed)));
    }

    private IStatus refreshRemoteResource(TFSRepository repository, IResource resource, RecursionType recursionType, Collection<IResource> changedResources, IProgressMonitor monitor) {
        monitor.beginTask(MessageFormat.format(Messages.getString("SynchronizeSubscriber.RefreshingResourceRemoteChangesFormat"), resource.getName()), 1);
        if (resource.getType() == 1) {
            recursionType = RecursionType.NONE;
        }
        changedResources.addAll(this.remoteGetOperationTree.removeOperation(resource));
        ItemSpec itemSpec = new ItemSpec(resource.getLocation().toOSString(), recursionType);
        GetRequest[] requests = new GetRequest[]{new GetRequest(itemSpec, (VersionSpec)LatestVersionSpec.INSTANCE)};
        log.debug((Object)MessageFormat.format("Previewing latest server state for {0}", resource.getLocation().toOSString()));
        PreviewGetCommand getCommand = new PreviewGetCommand(repository, requests, GetOptions.PREVIEW);
        try {
            IStatus status = getCommand.run(monitor);
            if (status == null) {
                throw new Exception(Messages.getString("SynchronizeSubscriber.CouldNotExecuteCommand"));
            }
            if (!status.isOK()) {
                return status;
            }
        }
        catch (CanceledException e) {
            return Status.CANCEL_STATUS;
        }
        catch (Exception e) {
            return new TeamStatus(4, "com.microsoft.tfs.client.eclipse", -4, Messages.getString("SynchronizeSubscriber.CouldNotGetStatusFromServer"), (Throwable)e, resource);
        }
        GetOperation[][] operations = getCommand.getOperations();
        for (int i = 0; i < operations.length; ++i) {
            Arrays.sort(operations[i]);
            for (int j = 0; j < operations[i].length; ++j) {
                IResource[] resources = this.getAffectedResources(operations[i][j]);
                if (resources == null || resources.length == 0) {
                    return new TeamStatus(4, "com.microsoft.tfs.client.eclipse", -6, MessageFormat.format(Messages.getString("SynchronizeSubscriber.CouldNotDetermineLocalResourceForItemFormat"), operations[i][j].getTargetServerItem()), null, resource);
                }
                for (int k = 0; k < resources.length; ++k) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)MessageFormat.format("Resource {0} is affected by incoming operation of version {1}", resources[k], operations[i][j].getVersionServer()));
                    }
                    this.remoteGetOperationTree.addOperation(resources[k], operations[i][j]);
                    changedResources.add(resources[k]);
                }
            }
        }
        monitor.worked(1);
        monitor.done();
        return Status.OK_STATUS;
    }

    private IResource[] getAffectedResources(GetOperation operation) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        List<String> localPaths = new ArrayList<String>();
        ArrayList<IFile> localResources = new ArrayList<IFile>();
        if (operation.getCurrentLocalItem() != null && operation.getTargetLocalItem() == null) {
            localPaths.add(operation.getCurrentLocalItem());
        } else if (operation.getCurrentLocalItem() == null && operation.getTargetLocalItem() != null) {
            localPaths.add(operation.getTargetLocalItem());
        } else if (!operation.getCurrentLocalItem().equals(operation.getTargetLocalItem())) {
            localPaths.add(operation.getCurrentLocalItem());
            localPaths.add(operation.getTargetLocalItem());
        } else {
            localPaths.add(operation.getCurrentLocalItem());
        }
        localPaths = this.getUniquePaths(localPaths);
        for (String tfsPath : localPaths) {
            Path local = new Path(LocalPath.tfsToNative((String)tfsPath));
            Object resource = operation.getItemType() == ItemType.FILE ? workspaceRoot.getFileForLocation((IPath)local) : workspaceRoot.getContainerForLocation((IPath)local);
            if (resource == null) continue;
            localResources.add((IFile)resource);
        }
        return localResources.toArray(new IResource[localResources.size()]);
    }

    private List<String> getUniquePaths(List<String> paths) {
        Collator collator = Collator.getInstance(Locale.US);
        ArrayList<String> uniquePaths = new ArrayList<String>();
        for (String givenPath : paths) {
            boolean duplicate = false;
            for (String existingPath : uniquePaths) {
                if (collator.compare(givenPath, existingPath) != 0) continue;
                duplicate = true;
                break;
            }
            if (duplicate) continue;
            uniquePaths.add(givenPath);
        }
        return uniquePaths;
    }

    private void fireTeamResourceChange(Collection<IResource> changed) {
        if (changed.size() > 0) {
            IResource[] changedResources = changed.toArray(new IResource[changed.size()]);
            this.fireTeamResourceChange((ISubscriberChangeEvent[])SubscriberChangeEvent.asSyncChangedDeltas((Subscriber)this, (IResource[])changedResources));
        }
    }

    public IResourceVariantComparator getResourceComparator() {
        return this.comparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deferAutomaticRefresh() {
        Object object = this.deferLock;
        synchronized (object) {
            ++this.deferCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void continueAutomaticRefresh() {
        IResource[] refreshResources = null;
        Object object = this.deferLock;
        synchronized (object) {
            --this.deferCount;
            if (this.deferCount == 0) {
                refreshResources = this.deferRefreshes.toArray(new IResource[this.deferRefreshes.size()]);
                this.deferRefreshes.clear();
            }
        }
        if (refreshResources != null && refreshResources.length > 0) {
            this.refreshBackground(refreshResources);
        }
    }

    private final void refreshBackground(final IResource[] resources) {
        new Job(Messages.getString("SynchronizeSubscriber.ExaminingSynchronizationState")){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    SynchronizeSubscriber.this.refresh(resources, 2, monitor);
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    log.warn((Object)Messages.getString("SynchronizeSubscriber.CouldNotRefreshSynchronizationState"), (Throwable)e);
                    return new Status(4, "com.microsoft.tfs.client.eclipse", 0, e.getLocalizedMessage(), null);
                }
            }
        }.schedule();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class SynchronizeResourceRefresher
    extends CoreAffectedResourceCollector {
        private SynchronizeResourceRefresher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void resourcesChanged(Set<IResource> resourceSet) {
            Object object = SynchronizeSubscriber.this.deferLock;
            synchronized (object) {
                if (SynchronizeSubscriber.this.deferCount > 0) {
                    SynchronizeSubscriber.this.deferRefreshes.addAll(resourceSet);
                    return;
                }
            }
            IResource[] resources = resourceSet.toArray(new IResource[resourceSet.size()]);
            SynchronizeSubscriber.this.refreshBackground(resources);
        }
    }
}

